/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.security.auth.session;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceTracker;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticatedSessionManagerUtil {
    private static final AuthenticatedSessionManagerUtil _instance = new AuthenticatedSessionManagerUtil();
    private final ServiceTracker<?, AuthenticatedSessionManager> _serviceTracker;

    public static AuthenticatedSessionManager getAuthenticatedSessionManager() {
        PortalRuntimePermission.checkGetBeanProperty(AuthenticatedSessionManagerUtil.class);
        return (AuthenticatedSessionManager)AuthenticatedSessionManagerUtil._instance._serviceTracker.getService();
    }

    public static long getAuthenticatedUserId(HttpServletRequest request, String login, String password, String authType) throws PortalException {
        return AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().getAuthenticatedUserId(request, login, password, authType);
    }

    public static void login(HttpServletRequest request, HttpServletResponse response, String login, String password, boolean rememberMe, String authType) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().login(request, response, login, password, rememberMe, authType);
    }

    public static void logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().logout(request, response);
    }

    public static HttpSession renewSession(HttpServletRequest request, HttpSession session) throws Exception {
        return AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().renewSession(request, session);
    }

    public static void signOutSimultaneousLogins(long userId) throws Exception {
        AuthenticatedSessionManagerUtil.getAuthenticatedSessionManager().signOutSimultaneousLogins(userId);
    }

    private AuthenticatedSessionManagerUtil() {
        Registry registry = RegistryUtil.getRegistry();
        this._serviceTracker = registry.trackServices(AuthenticatedSessionManager.class);
        this._serviceTracker.open();
    }
}

