/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.workflow;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class BaseWorkflowHandler<T>
implements WorkflowHandler<T> {
    private static final boolean _ASSET_TYPE_SEARCHABLE = true;
    private static final boolean _SCOPEABLE = true;
    private static final boolean _VISIBLE = true;
    private static final Log _log = LogFactoryUtil.getLog(BaseWorkflowHandler.class);

    @Override
    public AssetRenderer<T> getAssetRenderer(long classPK) throws PortalException {
        AssetRendererFactory<long> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            return assetRendererFactory.getAssetRenderer(classPK, 0);
        }
        return null;
    }

    @Override
    public AssetRendererFactory<T> getAssetRendererFactory() {
        return AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName(this.getClassName());
    }

    @Override
    public String getIconCssClass() {
        AssetRendererFactory<T> assetRendererFactory = this.getAssetRendererFactory();
        if (assetRendererFactory != null) {
            return assetRendererFactory.getIconCssClass();
        }
        return "";
    }

    @Override
    @Deprecated
    public String getIconPath(LiferayPortletRequest liferayPortletRequest) {
        return "";
    }

    @Override
    @Deprecated
    public String getSummary(long classPK, Locale locale) {
        return this.getSummary(classPK, null, null);
    }

    @Override
    public String getSummary(long classPK, PortletRequest portletRequest, PortletResponse portletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getSummary(portletRequest, portletResponse);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String getTitle(long classPK, Locale locale) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getTitle(locale);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public PortletURL getURLEdit(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLEdit(liferayPortletRequest, liferayPortletResponse);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String getURLEditWorkflowTask(long workflowTaskId, ServiceContext serviceContext) throws PortalException {
        try {
            PortletURL portletURL = PortalUtil.getControlPanelPortletURL(serviceContext.getRequest(), "com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet", "RENDER_PHASE");
            portletURL.setParameter("mvcPath", "/edit_workflow_task.jsp");
            portletURL.setParameter("workflowTaskId", String.valueOf(workflowTaskId));
            portletURL.setWindowState(WindowState.MAXIMIZED);
            return portletURL.toString();
        }
        catch (WindowStateException wse) {
            throw new PortalException(wse);
        }
    }

    @Override
    public PortletURL getURLViewDiffs(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLViewDiffs(liferayPortletRequest, liferayPortletResponse);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public String getURLViewInContext(long classPK, LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.getURLViewInContext(liferayPortletRequest, liferayPortletResponse, noSuchEntryRedirect);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return null;
    }

    @Override
    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        return WorkflowDefinitionLinkLocalServiceUtil.fetchWorkflowDefinitionLink(companyId, groupId, this.getClassName(), 0L, 0L);
    }

    @Override
    public boolean include(long classPK, HttpServletRequest request, HttpServletResponse response, String template) {
        block3: {
            try {
                AssetRenderer<T> assetRenderer = this.getAssetRenderer(classPK);
                if (assetRenderer != null) {
                    return assetRenderer.include(request, response, template);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn(e, e);
            }
        }
        return false;
    }

    @Override
    public boolean isAssetTypeSearchable() {
        return true;
    }

    @Override
    public boolean isScopeable() {
        return true;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public void startWorkflowInstance(long companyId, long groupId, long userId, long classPK, T model, Map<String, Serializable> workflowContext) throws PortalException {
        WorkflowInstanceLinkLocalServiceUtil.startWorkflowInstance(companyId, groupId, userId, this.getClassName(), classPK, workflowContext);
    }
}

