/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSettings {
    private final String _content;
    private final Pattern _contentDirPattern = Pattern.compile("\\scontent=(.*?)(,\\\\|\n|$)");
    private final String _fileLocation;
    private Properties _languageProperties;
    private String _releaseVersion;
    private final Pattern _releaseVersionPattern = Pattern.compile("Bundle-Version: (.*)(\n|\\Z)");

    public BNDSettings(String fileLocation, String content) {
        this._fileLocation = fileLocation;
        this._content = content;
    }

    public String getContent() {
        return this._content;
    }

    public String getFileLocation() {
        return this._fileLocation;
    }

    public Properties getLanguageProperties() throws Exception {
        File file;
        if (this._languageProperties != null) {
            return this._languageProperties;
        }
        if (this._content.matches("[\\s\\S]*Provide-Capability:[\\s\\S]*liferay\\.resource\\.bundle[\\s\\S]*")) {
            return null;
        }
        Properties languageProperties = new Properties();
        Matcher matcher = this._contentDirPattern.matcher(this._content);
        if (matcher.find() && (file = new File(this._fileLocation + matcher.group(1) + "/Language.properties")).exists()) {
            languageProperties.load(new FileInputStream(file));
        }
        this._languageProperties = languageProperties;
        return this._languageProperties;
    }

    public String getReleaseVersion() {
        if (this._releaseVersion != null) {
            return this._releaseVersion;
        }
        Matcher matcher = this._releaseVersionPattern.matcher(this._content);
        if (!matcher.find()) {
            return null;
        }
        this._releaseVersion = matcher.group(1);
        return this._releaseVersion;
    }
}

