/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CSSSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.css", "**/*.scss"};
    private final Pattern _commentFormatPattern = Pattern.compile("^-* ?(\\S.*?\\S) ?-*$");
    private final Pattern _commentPattern = Pattern.compile("/\\*[\n ](.*)[\n ]\\*/");
    private final Pattern _emptyLineAfterOpenCurlyBrace = Pattern.compile("\\{\n\n");
    private final Pattern _emptyLineBeforeCloseCurlyBrace = Pattern.compile("\n\n\t*\\}");
    private final Pattern _hexColorPattern = Pattern.compile("#([0-9a-f]+)[\\( ;,]");
    private final Pattern _propertiesPattern = Pattern.compile("(^(\t*)[a-z]\\S*: .+;\n)+", 8);
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        String newContent = StringUtil.replace(content, "  ", " ");
        newContent = this.sortProperties(newContent);
        newContent = this.formatComments(newContent);
        newContent = this.fixEmptyLines(newContent);
        return this.fixHexColors(newContent);
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.ivy/**", "**/.sass-cache/**", "**/__MACOSX/**", "**/_partial.scss", "**/_unstyled/css/**", "**/aui/**", "**/aui_deprecated.css", "**/bourbon/**", "**/converter/dependencies/**", "**/expected/**", "**/frontend-editors-web/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    protected String fixEmptyLines(String content) {
        Matcher matcher = this._emptyLineAfterOpenCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        matcher = this._emptyLineBeforeCloseCurlyBrace.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n\n", "\n", matcher.start());
        }
        return content;
    }

    protected String fixHexColors(String content) {
        Matcher matcher = this._hexColorPattern.matcher(content);
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            if (Validator.isNumber(hexColor) || hexColor.length() < 3) continue;
            content = StringUtil.replace(content, hexColor, StringUtil.toUpperCase(hexColor));
        }
        return content;
    }

    protected String formatComments(String content) {
        Matcher commentMatcher = this._commentPattern.matcher(content);
        while (commentMatcher.find()) {
            Matcher commentFormatMatcher = this._commentFormatPattern.matcher(commentMatcher.group(1));
            if (!commentFormatMatcher.find()) continue;
            String comment = commentFormatMatcher.group(1);
            String[] words = StringUtil.split(comment, ' ');
            for (int i = 1; i < words.length; ++i) {
                String word;
                String previousWord = words[i - 1];
                if (previousWord.endsWith(".") || previousWord.equals("/") || (word = words[i]).length() <= 1 || !Character.isUpperCase(word.charAt(0)) || !StringUtil.isLowerCase(word.substring(1))) continue;
                comment = StringUtil.replaceFirst(comment, word, StringUtil.toLowerCase(word));
            }
            content = StringUtil.replaceFirst(content, commentMatcher.group(), "/* ---------- " + comment + " ---------- */");
        }
        return content;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateSourceChecks() {
        this._sourceChecks.add(new WhitespaceCheck());
    }

    protected String sortProperties(String content) {
        Matcher matcher = this._propertiesPattern.matcher(content);
        while (matcher.find()) {
            String parameters = StringUtil.trimTrailing(matcher.group());
            String newParameters = StringUtil.removeChar(parameters, '\t');
            List<String> parameterList = ListUtil.fromArray(StringUtil.splitLines(newParameters));
            Collections.sort(parameterList, new PropertyComparator());
            String tabs = matcher.group(2);
            StringBundler sb = new StringBundler(parameterList.size() * 3);
            for (String parameter : parameterList) {
                sb.append(tabs);
                sb.append(parameter);
                sb.append("\n");
            }
            newParameters = sb.toString();
            newParameters = newParameters.substring(0, newParameters.length() - 1);
            content = StringUtil.replaceFirst(content, parameters, newParameters, matcher.start() - 1);
        }
        return content;
    }

    private class PropertyComparator
    extends NaturalOrderStringComparator {
        private PropertyComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            int pos1 = s1.indexOf(58);
            int pos2 = s2.indexOf(58);
            return super.compare(s1.substring(0, pos1), s2.substring(0, pos2));
        }
    }
}

