/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class SQLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.sql"};
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        StringBundler sb = new StringBundler();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLineSqlCommand = "";
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (Validator.isNotNull(line) && !line.startsWith("\t")) {
                    String sqlCommand = StringUtil.split(line, ' ')[0];
                    if (Validator.isNotNull(previousLineSqlCommand) && !previousLineSqlCommand.equals(sqlCommand)) {
                        sb.append("\n");
                    }
                    previousLineSqlCommand = sqlCommand;
                } else {
                    previousLineSqlCommand = "";
                }
                String strippedQuotesLine = this.stripQuotes(line, '\'');
                if (strippedQuotesLine.contains("\"")) {
                    line = StringUtil.replace(line, '\"', '\'');
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        content = sb.toString();
        if (content.endsWith("\n")) {
            content = content.substring(0, content.length() - 1);
        }
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        return this.getFileNames(new String[0], this.filterIncludes(new String[]{"**/sql/*.sql"}));
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateSourceChecks() {
        this._sourceChecks.add(new WhitespaceCheck());
    }
}

