/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.XMLBuildFileCheck;
import com.liferay.source.formatter.checks.XMLCustomSQLFileCheck;
import com.liferay.source.formatter.checks.XMLDDLStructuresFileCheck;
import com.liferay.source.formatter.checks.XMLEmptyLinesCheck;
import com.liferay.source.formatter.checks.XMLFriendlyURLRoutesFileCheck;
import com.liferay.source.formatter.checks.XMLHBMFileCheck;
import com.liferay.source.formatter.checks.XMLLog4jFileCheck;
import com.liferay.source.formatter.checks.XMLLookAndFeelFileCheck;
import com.liferay.source.formatter.checks.XMLModelHintsFileCheck;
import com.liferay.source.formatter.checks.XMLPortletFileCheck;
import com.liferay.source.formatter.checks.XMLPortletPreferencesFileCheck;
import com.liferay.source.formatter.checks.XMLPoshiFileCheck;
import com.liferay.source.formatter.checks.XMLResourceActionsFileCheck;
import com.liferay.source.formatter.checks.XMLServiceFileCheck;
import com.liferay.source.formatter.checks.XMLSolrSchemaFileCheck;
import com.liferay.source.formatter.checks.XMLSpringFileCheck;
import com.liferay.source.formatter.checks.XMLStrutsConfigFileCheck;
import com.liferay.source.formatter.checks.XMLTagAttributesCheck;
import com.liferay.source.formatter.checks.XMLTestIgnorableErrorLinesFileCheck;
import com.liferay.source.formatter.checks.XMLTilesDefsFileCheck;
import com.liferay.source.formatter.checks.XMLToggleFileCheck;
import com.liferay.source.formatter.checks.XMLWebFileCheck;
import com.liferay.source.formatter.checks.XMLWhitespaceCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class XMLSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.testcase", "**/*.toggle", "**/*.xml"};
    private static final String _NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES = "numerical.portlet.name.element.excludes";
    private static final String _SERVICE_FINDER_COLUMN_SORT_EXCLUDES = "service.finder.column.sort.excludes";
    private final List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();

    @Override
    protected String doFormat(File file, String fileName, String absolutePath, String content) throws Exception {
        return content;
    }

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**", "**/javadocs-*.xml", "**/logs/**", "**/portal-impl/**/*.action", "**/portal-impl/**/*.function", "**/portal-impl/**/*.macro", "**/portal-impl/**/*.testcase", "**/src/test/**", "**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**", "**/tools/node**"};
        return this.getFileNames(excludes, this.getIncludes());
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected List<SourceCheck> getSourceChecks() {
        return this._sourceChecks;
    }

    @Override
    protected void populateSourceChecks() throws Exception {
        this._sourceChecks.add(new XMLBuildFileCheck(this.sourceFormatterArgs.getBaseDirName()));
        this._sourceChecks.add(new XMLCustomSQLFileCheck());
        this._sourceChecks.add(new XMLDDLStructuresFileCheck());
        this._sourceChecks.add(new XMLFriendlyURLRoutesFileCheck());
        this._sourceChecks.add(new XMLHBMFileCheck());
        this._sourceChecks.add(new XMLLog4jFileCheck());
        this._sourceChecks.add(new XMLLookAndFeelFileCheck());
        this._sourceChecks.add(new XMLModelHintsFileCheck());
        this._sourceChecks.add(new XMLPortletFileCheck(this.getExcludes(_NUMERICAL_PORTLET_NAME_ELEMENT_EXCLUDES), portalSource, subrepository));
        this._sourceChecks.add(new XMLPortletPreferencesFileCheck());
        this._sourceChecks.add(new XMLPoshiFileCheck());
        this._sourceChecks.add(new XMLResourceActionsFileCheck());
        this._sourceChecks.add(new XMLServiceFileCheck(this.getExcludes(_SERVICE_FINDER_COLUMN_SORT_EXCLUDES), portalSource, subrepository, this.getContent("sql/portal-tables.sql", 7), this.getPluginsInsideModulesDirectoryNames()));
        this._sourceChecks.add(new XMLSolrSchemaFileCheck());
        this._sourceChecks.add(new XMLSpringFileCheck());
        this._sourceChecks.add(new XMLToggleFileCheck());
        if (portalSource || subrepository) {
            this._sourceChecks.add(new XMLStrutsConfigFileCheck());
            this._sourceChecks.add(new XMLTestIgnorableErrorLinesFileCheck());
            this._sourceChecks.add(new XMLTilesDefsFileCheck());
            this._sourceChecks.add(new XMLWebFileCheck(this.sourceFormatterArgs.getBaseDirName()));
        }
        this._sourceChecks.add(new XMLWhitespaceCheck(this.sourceFormatterArgs.getBaseDirName()));
        this._sourceChecks.add(new XMLTagAttributesCheck());
        if (portalSource || subrepository) {
            this._sourceChecks.add(new XMLEmptyLinesCheck(this.sourceFormatterArgs.getBaseDirName()));
        }
    }
}

