/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.util.SourceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseSourceCheck
implements SourceCheck {
    private final Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessage(String fileName) {
        if (this._sourceFormatterMessagesMap.containsKey(fileName)) {
            return this._sourceFormatterMessagesMap.get(fileName);
        }
        return Collections.emptySet();
    }

    protected void addMessage(String fileName, String message) {
        this.addMessage(fileName, message, -1);
    }

    protected void addMessage(String fileName, String message, int lineCount) {
        this.addMessage(fileName, message, null, lineCount);
    }

    protected void addMessage(String fileName, String message, String markdownFileName) {
        this.addMessage(fileName, message, markdownFileName, -1);
    }

    protected void addMessage(String fileName, String message, String markdownFileName, int lineCount) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(new SourceFormatterMessage(fileName, message, markdownFileName, lineCount));
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void clearSourceFormatterMessages(String fileName) {
        this._sourceFormatterMessagesMap.remove(fileName);
    }

    protected int getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    protected int getLevel(String s) {
        return SourceUtil.getLevel(s);
    }

    protected int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return SourceUtil.getLevel(s, increaseLevelString, decreaseLevelString);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings);
    }

    protected int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        return SourceUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, startLevel);
    }

    protected int getLineCount(String content, int pos) {
        return StringUtil.count(content, 0, pos, '\n') + 1;
    }

    protected boolean isExcludedPath(List<String> excludes, String path) {
        return this.isExcludedPath(excludes, path, -1);
    }

    protected boolean isExcludedPath(List<String> excludes, String path, int lineCount) {
        return this.isExcludedPath(excludes, path, lineCount, null);
    }

    protected boolean isExcludedPath(List<String> excludes, String path, int lineCount, String parameter) {
        if (ListUtil.isEmpty(excludes)) {
            return false;
        }
        String pathWithParameter = null;
        if (Validator.isNotNull(parameter)) {
            pathWithParameter = path + "@" + parameter;
        }
        String pathWithLineCount = null;
        if (lineCount > 0) {
            pathWithLineCount = path + "@" + lineCount;
        }
        for (String exclude : excludes) {
            if (Validator.isNull(exclude)) continue;
            if (exclude.startsWith("**")) {
                exclude = exclude.substring(2);
            }
            if (!(exclude.endsWith("**") ? path.contains(exclude = exclude.substring(0, exclude.length() - 2)) : path.endsWith(exclude) || pathWithParameter != null && pathWithParameter.endsWith(exclude) || pathWithLineCount != null && pathWithLineCount.endsWith(exclude))) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcludedPath(List<String> excludes, String path, String parameter) {
        return this.isExcludedPath(excludes, path, -1, parameter);
    }

    protected boolean isModulesFile(String absolutePath, boolean subrepository) {
        return this.isModulesFile(absolutePath, subrepository, null);
    }

    protected boolean isModulesFile(String absolutePath, boolean subrepository, List<String> pluginsInsideModulesDirectoryNames) {
        if (subrepository) {
            return true;
        }
        if (pluginsInsideModulesDirectoryNames == null) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : pluginsInsideModulesDirectoryNames) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    protected String stripQuotes(String s) {
        return this.stripQuotes(s, '\'', '\"');
    }

    protected String stripQuotes(String s, char ... delimeters) {
        List<Character> delimetersList = ListUtil.toList(delimeters);
        char delimeter = ' ';
        boolean insideQuotes = false;
        StringBundler sb = new StringBundler();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (insideQuotes) {
                if (c != delimeter) continue;
                int precedingBackSlashCount = 0;
                for (int j = i - 1; j >= 0 && s.charAt(j) == '\\'; --j) {
                    ++precedingBackSlashCount;
                }
                if (precedingBackSlashCount != 0 && precedingBackSlashCount % 2 != 0) continue;
                insideQuotes = false;
                continue;
            }
            if (delimetersList.contains(Character.valueOf(c))) {
                delimeter = c;
                insideQuotes = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

