/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPLogFileNameCheck
extends BaseFileCheck {
    private final Pattern _logPattern = Pattern.compile("Log _log = LogFactoryUtil\\.getLog\\(\"(.*?)\"\\)");
    private final boolean _subrepository;

    public JSPLogFileNameCheck(boolean subrepository) {
        this._subrepository = subrepository;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (!this.isModulesFile(absolutePath, this._subrepository) && !absolutePath.contains("/portal-web/")) {
            content = this._formatLogFileName(absolutePath, content);
        }
        return content;
    }

    private String _formatLogFileName(String absolutePath, String content) {
        Matcher matcher = this._logPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String logFileName = StringUtil.replace(absolutePath, '.', '_');
        logFileName = StringUtil.replace(logFileName, '/', '.');
        int x = (logFileName = StringUtil.replace(logFileName, '-', '_')).lastIndexOf(".portal_web.");
        if (x != -1) {
            logFileName = logFileName.substring(x + 1);
        } else {
            x = logFileName.lastIndexOf(".docroot.");
            if (x == -1) {
                x = Math.max(logFileName.lastIndexOf(".src.main.resources.META_INF.resources."), logFileName.lastIndexOf(".src.META_INF.resources."));
            }
            if (x == -1) {
                return content;
            }
            x = logFileName.lastIndexOf(".", x - 1);
            logFileName = "com_liferay_" + logFileName.substring(x + 1);
            logFileName = StringUtil.replace(logFileName, new String[]{".docroot.", ".src.main.resources.META_INF.resources.", ".src.META_INF.resources."}, new String[]{".", ".", "."});
        }
        return StringUtil.replace(content, matcher.group(), "Log _log = LogFactoryUtil.getLog(\"" + logFileName + "\")");
    }
}

