/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JSPTaglibVariableCheck
extends BaseFileCheck {
    private final Pattern _taglibVariablePattern = Pattern.compile("(\n\t*String (taglib\\w+) = (.*);)\n\\s*%>\\s+(<[\\S\\s]*?>)\n");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatTaglibVariable(fileName, content);
        return content;
    }

    private String _formatTaglibVariable(String fileName, String content) {
        Matcher matcher = this._taglibVariablePattern.matcher(content);
        while (matcher.find()) {
            String taglibValue = matcher.group(3);
            if (taglibValue.contains("\\\"") || taglibValue.contains("'") && taglibValue.contains("\"")) continue;
            String taglibName = matcher.group(2);
            String nextTag = matcher.group(4);
            if (!nextTag.contains(taglibName)) {
                this.addMessage(fileName, "No need to specify taglib variable '" + taglibName + "'", this.getLineCount(content, matcher.start()));
                continue;
            }
            content = StringUtil.replaceFirst(content, taglibName, taglibValue, matcher.start(4));
            content = StringUtil.replaceFirst(content, matcher.group(1), "", matcher.start());
            return content;
        }
        return content;
    }
}

