/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDeserializationSecurityCheck
extends BaseFileCheck {
    private final Pattern[] _javaSerializationVulnerabilityPatterns = new Pattern[]{Pattern.compile(".*(new [a-z\\.\\s]*ObjectInputStream).*", 32), Pattern.compile(".*(extends [a-z\\.\\s]*ObjectInputStream).*", 32)};
    private final List<String> _runOutsidePortalExcludes;
    private final List<String> _secureDeserializationExcludes;

    public JavaDeserializationSecurityCheck(List<String> secureDeserializationExcludes, List<String> runOutsidePortalExcludes) {
        this._secureDeserializationExcludes = secureDeserializationExcludes;
        this._runOutsidePortalExcludes = runOutsidePortalExcludes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.contains("/test/") || fileName.contains("/testIntegration/") || this.isExcludedPath(this._secureDeserializationExcludes, absolutePath)) {
            return content;
        }
        this._checkDeserializationSecurity(fileName, content, absolutePath);
        return content;
    }

    private void _checkDeserializationSecurity(String fileName, String content, String absolutePath) {
        for (Pattern vulnerabilityPattern : this._javaSerializationVulnerabilityPatterns) {
            Matcher matcher = vulnerabilityPattern.matcher(content);
            if (!matcher.matches()) continue;
            StringBundler sb = new StringBundler(3);
            if (this.isExcludedPath(this._runOutsidePortalExcludes, absolutePath)) {
                sb.append("Possible Java Serialization Remote Code Execution ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use ProtectedObjectInputStream instead of ");
            }
            sb.append(matcher.group(1));
            this.addMessage(fileName, sb.toString());
        }
    }
}

