/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.IfStatementCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaIfStatementCheck
extends IfStatementCheck {
    private final Pattern _ifStatementCriteriaPattern = Pattern.compile(".*?( [|&^]+( |\\Z)|\\) \\{\\Z)");
    private final Pattern _ifStatementPattern = Pattern.compile("\t+(catch|(else )?if|while) \\(.*?(\\) \\{|;)\n", 32);
    private final int _maxLineLength;

    public JavaIfStatementCheck(int maxLineLength) {
        this._maxLineLength = maxLineLength;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        Matcher matcher = this._ifStatementPattern.matcher(content);
        while (matcher.find()) {
            String ifClause = matcher.group();
            if (ifClause.contains("{\t")) continue;
            String lineEnding = matcher.group(3);
            String type = matcher.group(1);
            if (!type.equals("while") && lineEnding.equals(";")) {
                this.addMessage(fileName, "Incorrect " + type + " statement", this.getLineCount(content, matcher.start()));
                continue;
            }
            String newIfClause = this._formatIfClause(ifClause, fileName, this.getLineCount(content, matcher.start()));
            if (ifClause.equals(newIfClause)) continue;
            return StringUtil.replace(content, ifClause, newIfClause);
        }
        return content;
    }

    private String _fixIfClause(String ifClause, String line, int delta) {
        if (StringUtil.count(ifClause, line) > 1) {
            return ifClause;
        }
        String newLine = line;
        String whitespace = "";
        int whitespaceLength = Math.abs(delta);
        while (whitespaceLength > 0) {
            if (whitespaceLength >= 4) {
                whitespace = whitespace + "\t";
                whitespaceLength -= 4;
                continue;
            }
            whitespace = whitespace + " ";
            --whitespaceLength;
        }
        if (delta > 0) {
            if (!line.contains("\t" + whitespace)) {
                newLine = StringUtil.replaceLast(newLine, '\t', "    ");
            }
            newLine = StringUtil.replaceLast(newLine, "\t" + whitespace, "\t");
        } else {
            newLine = StringUtil.replaceLast(newLine, '\t', "\t" + whitespace);
        }
        newLine = StringUtil.replaceLast(newLine, "    ", "\t");
        return StringUtil.replace(ifClause, line, newLine);
    }

    private String _formatIfClause(String ifClause) throws Exception {
        String strippedQuotesIfClause = this.stripQuotes(ifClause);
        if (strippedQuotesIfClause.contains("!(") || strippedQuotesIfClause.contains("//")) {
            return ifClause;
        }
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(ifClause));
        String line = null;
        String previousLine = null;
        int previousLineLength = 0;
        int previousLineLeadingWhitespace = 0;
        int previousLineLevel = 0;
        boolean previousLineIsStartCriteria = true;
        int baseLeadingWhitespace = 0;
        int insideMethodCallExpectedWhitespace = 0;
        int level = -1;
        while ((line = unsyncBufferedReader.readLine()) != null) {
            String originalLine = line;
            String trimmedLine = StringUtil.trimLeading(line);
            int x = this._getIncorrectLineBreakPos(line, previousLine);
            if (x != -1) {
                String leadingWhitespace = line.substring(0, line.indexOf(trimmedLine));
                return StringUtil.replace(ifClause, line, line.substring(0, x) + "\n" + leadingWhitespace + line.substring(x + 1));
            }
            if (previousLineLength > 0 && previousLineIsStartCriteria && previousLineLevel >= 0 && previousLine.matches(".*[|&^]")) {
                Matcher matcher = this._ifStatementCriteriaPattern.matcher(trimmedLine);
                while (matcher.find()) {
                    String linePart;
                    int linePartLevel;
                    if (ToolsUtil.isInsideQuotes(trimmedLine, matcher.end()) || (linePartLevel = this.getLevel(linePart = trimmedLine.substring(0, matcher.end()))) > 0 || previousLineLength + linePart.length() >= this._maxLineLength) continue;
                    if (linePart.equals(trimmedLine)) {
                        return StringUtil.replace(ifClause, previousLine + "\n" + originalLine, previousLine + " " + trimmedLine);
                    }
                    String newPreviousLine = previousLine + " " + linePart;
                    String newLine = StringUtil.replaceFirst(originalLine, linePart, "");
                    return StringUtil.replace(ifClause, previousLine + "\n" + originalLine, newPreviousLine + "\n" + newLine);
                }
            }
            line = StringUtil.replace(line, '\t', "    ");
            int leadingWhitespace = line.length() - trimmedLine.length();
            if (Validator.isNull(previousLine)) {
                baseLeadingWhitespace = line.indexOf(40) + 1;
            } else if (previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^")) {
                int expectedLeadingWhitespace = baseLeadingWhitespace + level;
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this._fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            } else {
                int expectedLeadingWhitespace = 0;
                if (previousLine.contains("\telse if (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 3;
                } else if (previousLine.contains("\tif (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 4;
                } else if (previousLine.contains("\twhile (")) {
                    expectedLeadingWhitespace = baseLeadingWhitespace + 5;
                }
                if (previousLine.endsWith(",") && insideMethodCallExpectedWhitespace > 0) {
                    if (previousLineLevel < 0) {
                        insideMethodCallExpectedWhitespace -= 4;
                    }
                    expectedLeadingWhitespace = insideMethodCallExpectedWhitespace;
                } else {
                    if (expectedLeadingWhitespace == 0) {
                        expectedLeadingWhitespace = previousLineLeadingWhitespace + 4;
                    }
                    if (previousLine.endsWith("(")) {
                        insideMethodCallExpectedWhitespace = expectedLeadingWhitespace;
                    }
                }
                if (leadingWhitespace != expectedLeadingWhitespace) {
                    return this._fixIfClause(ifClause, originalLine, leadingWhitespace - expectedLeadingWhitespace);
                }
            }
            if (line.endsWith(") {")) {
                return ifClause;
            }
            int lineLevel = this.getLevel(trimmedLine);
            level += lineLevel;
            if (Validator.isNotNull(previousLine)) {
                previousLineIsStartCriteria = previousLine.endsWith("|") || previousLine.endsWith("&") || previousLine.endsWith("^");
            }
            previousLine = originalLine;
            previousLineLength = line.length();
            previousLineLevel = lineLevel;
            previousLineLeadingWhitespace = leadingWhitespace;
        }
        return ifClause;
    }

    private String _formatIfClause(String ifClause, String fileName, int lineCount) throws Exception {
        String ifClauseSingleLine = StringUtil.replace(ifClause, new String[]{"\t ", "\t", "(\n", "\n"}, new String[]{"\t", "", "(", " "});
        this.checkIfClauseParentheses(ifClauseSingleLine, fileName, lineCount);
        return this._formatIfClause(ifClause);
    }

    private int _getIncorrectLineBreakPos(String line, String previousLine) {
        int x = line.length();
        while (true) {
            int z;
            int y;
            if ((x = Math.max(y = line.lastIndexOf(" || ", x - 1), z = line.lastIndexOf(" && ", x - 1))) == -1) {
                return x;
            }
            if (ToolsUtil.isInsideQuotes(line, x)) continue;
            if (Validator.isNotNull(previousLine) && (previousLine.endsWith(".") || this.getLevel(line.substring(0, x)) < 0)) {
                return x + 3;
            }
            if ((line.endsWith(" ||") || line.endsWith(" &&")) && this.getLevel(line.substring(x)) > 0) break;
        }
        return x + 3;
    }
}

