/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.List;

public class JavaIllegalImportsCheck
extends BaseFileCheck {
    private final List<String> _proxyExcludes;
    private final List<String> _runOutsidePortalExcludes;
    private final List<String> _secureRandomExcludes;

    public JavaIllegalImportsCheck(List<String> proxyExcludes, List<String> runOutsidePortalExcludes, List<String> secureRandomExcludes) {
        this._proxyExcludes = proxyExcludes;
        this._runOutsidePortalExcludes = runOutsidePortalExcludes;
        this._secureRandomExcludes = secureRandomExcludes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("JavaIllegalImportsCheck.java")) {
            return content;
        }
        content = StringUtil.replace(content, new String[]{"com.liferay.portal.PortalException", "com.liferay.portal.SystemException", "com.liferay.util.LocalizationUtil"}, new String[]{"com.liferay.portal.kernel.exception.PortalException", "com.liferay.portal.kernel.exception.SystemException", "com.liferay.portal.kernel.util.LocalizationUtil"});
        if (!this.isExcludedPath(this._runOutsidePortalExcludes, absolutePath) && !this.isExcludedPath(this._proxyExcludes, absolutePath) && content.contains("import java.lang.reflect.Proxy;")) {
            this.addMessage(fileName, "Use ProxyUtil instead of java.lang.reflect.Proxy");
        }
        if (content.contains("import edu.emory.mathcs.backport.java")) {
            this.addMessage(fileName, "Illegal import: edu.emory.mathcs.backport.java");
        }
        if (content.contains("import jodd.util.StringPool")) {
            this.addMessage(fileName, "Illegal import: jodd.util.StringPool");
        }
        if (content.contains("com.liferay.portal.kernel.util.UnmodifiableList")) {
            this.addMessage(fileName, "Use java.util.Collections.unmodifiableList instead of com.liferay.portal.kernel.util.UnmodifiableList, see LPS-45027");
        }
        if (!this.isExcludedPath(this._runOutsidePortalExcludes, absolutePath) && !this.isExcludedPath(this._secureRandomExcludes, absolutePath) && content.contains("java.security.SecureRandom") && !content.contains("javax.crypto.KeyGenerator")) {
            this.addMessage(fileName, "Use SecureRandomUtil or com.liferay.portal.kernel.security.SecureRandom instead of java.security.SecureRandom, see LPS-39058");
        }
        if (content.contains("org.testng.Assert")) {
            this.addMessage(fileName, "Use org.junit.Assert instead of org.testng.Assert, see LPS-55690");
        }
        if (content.contains(".supportsBatchUpdates()") && !fileName.endsWith("AutoBatchPreparedStatementUtil.java")) {
            this.addMessage(fileName, "Use AutoBatchPreparedStatementUtil instead of DatabaseMetaData.supportsBatchUpdates, see LPS-60473");
        }
        if (content.contains("Configurable.createConfigurable(") && !fileName.endsWith("ConfigurableUtil.java")) {
            this.addMessage(fileName, "Use ConfigurableUtil.createConfigurable instead of Configurable.createConfigurable, see LPS-64056");
        }
        if (fileName.endsWith("ResourceCommand.java") && content.contains("ServletResponseUtil.sendFile(")) {
            this.addMessage(fileName, "Use PortletResponseUtil.sendFile instead of ServletResponseUtil.sendFile, see LPS-65229");
        }
        if (!fileName.endsWith("AbstractExtender.java") && content.contains("org.apache.felix.utils.extender.AbstractExtender")) {
            StringBundler sb = new StringBundler(4);
            sb.append("Use com.liferay.osgi.felix.util.AbstractExtender ");
            sb.append("instead of ");
            sb.append("org.apache.felix.utils.extender.AbstractExtender, see ");
            sb.append("LPS-69494");
            this.addMessage(fileName, sb.toString());
        }
        if (content.contains("java.util.WeakHashMap")) {
            this.addMessage(fileName, "Do not use java.util.WeakHashMap because it is not thread-safe, see LPS-70963");
        }
        return content;
    }
}

