/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.BNDSettings;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaOSGiReferenceCheck
extends BaseFileCheck {
    private final Set<String> _bndFileNames = new CopyOnWriteArraySet<String>();
    private final Map<String, String> _moduleFileContentsMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> _moduleFileNamesMap;
    private final Pattern _referenceMethodContentPattern = Pattern.compile("^(\\w+) =\\s+\\w+;$");
    private final Pattern _referenceMethodPattern = Pattern.compile("\n\t@Reference([\\s\\S]*?)\\s+((protected|public) void (\\w+?))\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
    private final Pattern _serviceUtilImportPattern = Pattern.compile("\nimport ([A-Za-z1-9\\.]*)\\.([A-Za-z1-9]*ServiceUtil);");

    public JavaOSGiReferenceCheck(Map<String, String> moduleFileNamesMap) {
        this._moduleFileNamesMap = moduleFileNamesMap;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!content.contains("@Component")) {
            return content;
        }
        String packagePath = JavaSourceUtil.getPackagePath(content);
        if (!packagePath.startsWith("com.liferay")) {
            return content;
        }
        this._checkMissingReference(fileName, content);
        content = this._formatDuplicateReferenceMethods(fileName, content, packagePath);
        Matcher matcher = this._referenceMethodPattern.matcher(content);
        while (matcher.find()) {
            String methodName = matcher.group(4);
            if (!methodName.startsWith("set")) continue;
            String annotationParameters = matcher.group(1);
            String methodContent = matcher.group();
            content = this._formatMissingUnbindAnnotation(content, methodName, methodContent, annotationParameters);
            String methodBody = matcher.group(6);
            String typeName = matcher.group(5);
            content = this._formatVolatileReferenceVariable(content, methodBody, typeName);
        }
        return content;
    }

    private void _checkMissingReference(String fileName, String content) {
        String moduleServicePackagePath = null;
        Matcher matcher = this._serviceUtilImportPattern.matcher(content);
        while (matcher.find()) {
            String serviceUtilClassPackagePath;
            String serviceUtilClassName = matcher.group(2);
            if (moduleServicePackagePath == null) {
                moduleServicePackagePath = this._getModuleServicePackagePath(fileName);
            }
            if (Validator.isNotNull(moduleServicePackagePath) && (serviceUtilClassPackagePath = matcher.group(1)).startsWith(moduleServicePackagePath)) continue;
            this.addMessage(fileName, "Use @Reference instead of calling " + serviceUtilClassName + " directly, see LPS-59076");
        }
    }

    private String _formatDuplicateReferenceMethods(String fileName, String content, String packagePath) throws Exception {
        String className = JavaSourceUtil.getClassName(fileName);
        String moduleSuperClassContent = this._getModuleSuperClassContent(content, className, packagePath);
        if (Validator.isNull(moduleSuperClassContent) || !moduleSuperClassContent.contains("@Component") || !moduleSuperClassContent.contains("@Reference")) {
            return content;
        }
        Matcher matcher = this._referenceMethodPattern.matcher(moduleSuperClassContent);
        boolean bndInheritRequired = false;
        while (matcher.find()) {
            String referenceMethod = matcher.group();
            int pos = content.indexOf(referenceMethod);
            if (pos != -1) {
                String variableName;
                String referenceMethodContent = matcher.group(6);
                Matcher referenceMethodContentMatcher = this._referenceMethodContentPattern.matcher(referenceMethodContent);
                if (referenceMethodContentMatcher.find() && StringUtil.count(content, variableName = referenceMethodContentMatcher.group(1)) > 1) continue;
                int x = content.lastIndexOf("\n\n", pos);
                int y = pos + referenceMethod.length();
                String entireMethod = content.substring(x + 1, y);
                content = StringUtil.replace(content, entireMethod, "");
                bndInheritRequired = true;
                continue;
            }
            String referenceMethodModifierAndName = matcher.group(2);
            Pattern duplicateReferenceMethodPattern = Pattern.compile(referenceMethodModifierAndName + "\\(\\s*([ ,<>\\w]+)\\s+\\w+\\) \\{\\s+([\\s\\S]*?)\\s*?\n\t\\}\n");
            Matcher duplicateReferenceMethodMatcher = duplicateReferenceMethodPattern.matcher(content);
            if (!duplicateReferenceMethodMatcher.find()) {
                bndInheritRequired = true;
                continue;
            }
            String methodContent = duplicateReferenceMethodMatcher.group(2);
            String referenceMethodName = matcher.group(4);
            if (!methodContent.startsWith("super." + referenceMethodName)) continue;
            int x = content.lastIndexOf("\n\n", duplicateReferenceMethodMatcher.start());
            int y = duplicateReferenceMethodMatcher.end();
            String entireMethod = content.substring(x + 1, y);
            content = StringUtil.replace(content, entireMethod, "");
            bndInheritRequired = true;
        }
        if (bndInheritRequired) {
            BNDSettings bndSettings = this.getBNDSettings(fileName);
            String bndSettingsContent = bndSettings.getContent();
            String bndFileName = bndSettings.getFileLocation() + "bnd.bnd";
            if (!bndSettingsContent.contains("-dsannotations-options: inherit") && this._bndFileNames.add(bndFileName)) {
                this.addMessage(bndSettings.getFileLocation() + "bnd.bnd", "Add '-dsannotations-options: inherit'");
            }
        }
        return content;
    }

    private String _formatMissingUnbindAnnotation(String content, String methodName, String methodContent, String annotationParameters) {
        if (annotationParameters.contains("unbind =") || content.contains("un" + methodName + "(")) {
            return content;
        }
        if (Validator.isNull(annotationParameters)) {
            String newMethodContent = StringUtil.replaceFirst(methodContent, "@Reference", "@Reference(unbind = \"-\")");
            return StringUtil.replace(content, methodContent, newMethodContent);
        }
        if (!annotationParameters.contains("\n")) {
            String newAnnotationParameters = StringUtil.replaceLast(annotationParameters, ')', ", unbind = \"-\")");
            String newMethodContent = StringUtil.replaceFirst(methodContent, annotationParameters, newAnnotationParameters);
            return StringUtil.replace(content, methodContent, newMethodContent);
        }
        if (!annotationParameters.contains("\n\n")) {
            String newAnnotationParameters = StringUtil.replaceLast(annotationParameters, "\n", ",\n\t\tunbind = \"-\"\n");
            String newMethodContent = StringUtil.replaceFirst(methodContent, annotationParameters, newAnnotationParameters);
            return StringUtil.replace(content, methodContent, newMethodContent);
        }
        return content;
    }

    private String _formatVolatileReferenceVariable(String content, String methodBody, String typeName) {
        Matcher matcher = this._referenceMethodContentPattern.matcher(methodBody);
        if (!matcher.find()) {
            return content;
        }
        String variableName = matcher.group(1);
        StringBundler sb = new StringBundler(5);
        sb.append("private volatile ");
        sb.append(typeName);
        sb.append("\\s+");
        sb.append(variableName);
        sb.append(";");
        Pattern privateVarPattern = Pattern.compile(sb.toString());
        matcher = privateVarPattern.matcher(content);
        if (matcher.find()) {
            String match = matcher.group();
            String replacement = StringUtil.replace(match, "private volatile ", "private ");
            return StringUtil.replace(content, match, replacement);
        }
        return content;
    }

    private String _getModuleClassContent(String fullClassName) throws Exception {
        String classContent = this._moduleFileContentsMap.get(fullClassName);
        if (classContent != null) {
            return classContent;
        }
        String moduleFileName = this._moduleFileNamesMap.get(fullClassName);
        if (moduleFileName == null) {
            this._moduleFileContentsMap.put(fullClassName, "");
            return "";
        }
        File file = new File(moduleFileName);
        classContent = FileUtil.read(file);
        if (classContent != null) {
            this._moduleFileContentsMap.put(fullClassName, classContent);
        }
        return classContent;
    }

    private String _getModuleServicePackagePath(String fileName) {
        int pos;
        String serviceDirLocation = fileName;
        while (true) {
            if ((pos = serviceDirLocation.lastIndexOf("/")) == -1) {
                return "";
            }
            File file = new File((serviceDirLocation = serviceDirLocation.substring(0, pos + 1)) + "service");
            if (file.exists()) break;
            file = new File(serviceDirLocation + "liferay");
            if (file.exists()) {
                return "";
            }
            serviceDirLocation = StringUtil.replaceLast(serviceDirLocation, '/', "");
        }
        serviceDirLocation = serviceDirLocation + "service";
        serviceDirLocation = StringUtil.replace(serviceDirLocation, '/', '.');
        pos = serviceDirLocation.lastIndexOf(".com.");
        return serviceDirLocation.substring(pos + 1);
    }

    private String _getModuleSuperClassContent(String content, String className, String packagePath) throws Exception {
        Pattern pattern = Pattern.compile(" class " + className + "\\s+extends\\s+([\\w.]+) ");
        Matcher matcher = pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        String superClassName = matcher.group(1);
        if (superClassName.contains(".")) {
            if (!superClassName.startsWith("com.liferay")) {
                return null;
            }
            return this._getModuleClassContent(superClassName);
        }
        String superClassPackagePath = packagePath;
        pattern = Pattern.compile("\nimport (.+?)\\." + superClassName + ";");
        matcher = pattern.matcher(content);
        if (matcher.find()) {
            superClassPackagePath = matcher.group(1);
        }
        if (!superClassPackagePath.startsWith("com.liferay")) {
            return null;
        }
        String superClassFullClassName = superClassPackagePath + "." + superClassName;
        return this._getModuleClassContent(superClassFullClassName);
    }
}

