/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaConstructor;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaVariableTypeCheck
extends BaseJavaTermCheck {
    private final List<String> _annotationsExclusions;
    private final Map<String, String> _defaultPrimitiveValues;
    private final List<String> _excludes;
    private final Set<String> _immutableFieldTypes;

    public JavaVariableTypeCheck(List<String> excludes, List<String> annotationsExclusions, Map<String, String> defaultPrimitiveValues, Set<String> immutableFieldTypes) {
        this._excludes = excludes;
        this._annotationsExclusions = annotationsExclusions;
        this._defaultPrimitiveValues = defaultPrimitiveValues;
        this._immutableFieldTypes = immutableFieldTypes;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        if (this.isExcludedPath(this._excludes, absolutePath)) {
            return javaTerm.getContent();
        }
        JavaClass javaClass = (JavaClass)javaTerm;
        String classContent = javaClass.getContent();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            if (!(childJavaTerm instanceof JavaVariable)) continue;
            classContent = this._checkFieldType(javaClass, classContent, (JavaVariable)childJavaTerm);
        }
        return classContent;
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private String _checkFieldType(JavaClass javaClass, String classContent, JavaVariable javaVariable) {
        String accessModifier = javaVariable.getAccessModifier();
        if (accessModifier.equals("public")) {
            return classContent;
        }
        String fieldType = this._getFieldType(javaVariable);
        boolean isFinal = this._containsNonAccessModifier(javaVariable, "final");
        if (!isFinal) {
            classContent = this._formatDefaultValue(classContent, javaVariable, fieldType);
        }
        if (!accessModifier.equals("private")) {
            return classContent;
        }
        if (isFinal) {
            if (!javaVariable.isStatic() && this._immutableFieldTypes.contains(fieldType)) {
                classContent = this._formatStaticableFieldType(classContent, javaVariable.getContent());
            }
        } else if (!this._containsNonAccessModifier(javaVariable, "volatile")) {
            classContent = this._formatFinalableFieldType(classContent, javaClass, javaVariable, fieldType);
        }
        return classContent;
    }

    private boolean _containsNonAccessModifier(JavaVariable javaVariable, String modifier) {
        String nonAccessModifiers;
        Pattern pattern = Pattern.compile(javaVariable.getAccessModifier() + " (((final|static|synchronized|transient|volatile)(\n| ))*)");
        Matcher matcher = pattern.matcher(javaVariable.getContent());
        return matcher.find() && (nonAccessModifiers = matcher.group(1)).contains(modifier);
    }

    private String _formatDefaultValue(String classContent, JavaVariable javaVariable, String fieldType) {
        String defaultValue = null;
        defaultValue = StringUtil.isLowerCase(fieldType) ? this._defaultPrimitiveValues.get(fieldType) : "null";
        Pattern isDefaultValuePattern = Pattern.compile(" =\\s+" + defaultValue + ";(\\s+)$");
        Matcher matcher = isDefaultValuePattern.matcher(javaVariable.getContent());
        if (matcher.find()) {
            return StringUtil.replace(classContent, javaVariable.getContent(), matcher.replaceFirst(";$1"));
        }
        return classContent;
    }

    private String _formatFinalableFieldType(String classContent, JavaClass javaClass, JavaVariable javaVariable, String fieldType) {
        for (String annotation : this._annotationsExclusions) {
            if (!javaVariable.hasAnnotation(annotation)) continue;
            return classContent;
        }
        JavaClass parentJavaClass = javaClass;
        while (parentJavaClass.getParentJavaClass() != null) {
            parentJavaClass = parentJavaClass.getParentJavaClass();
        }
        List<JavaTerm> allChildJavaTerms = this._getAllChildJavaTerms(parentJavaClass);
        StringBundler sb = new StringBundler(6);
        sb.append("(((\\+\\+( ?))|(--( ?)))");
        sb.append(javaVariable.getName());
        sb.append(")|((\\b|\\.)");
        sb.append(javaVariable.getName());
        sb.append("((( )((=)|(\\+=)|(-=)|(\\*=)|(/=)|(%=)))");
        sb.append("|(\\+\\+)|(--)|(( )((\\|=)|(&=)|(^=)))))");
        Pattern pattern = Pattern.compile(sb.toString());
        if (!this._isFinalableField(javaClass, javaVariable, pattern, allChildJavaTerms)) {
            return classContent;
        }
        String javaVariableContent = javaVariable.getContent();
        String newJavaVariableContent = StringUtil.replaceFirst(javaVariableContent, fieldType, "final " + fieldType);
        return StringUtil.replace(classContent, javaVariableContent, newJavaVariableContent);
    }

    private String _formatStaticableFieldType(String classContent, String javaVariableContent) {
        if (!javaVariableContent.contains("=")) {
            return classContent;
        }
        String newJavaVariableContent = StringUtil.replaceFirst(javaVariableContent, "private final", "private static final");
        return StringUtil.replace(classContent, javaVariableContent, newJavaVariableContent);
    }

    private List<JavaTerm> _getAllChildJavaTerms(JavaClass javaClass) {
        ArrayList<JavaTerm> childJavaTerms = new ArrayList<JavaTerm>();
        for (JavaTerm childJavaTerm : javaClass.getChildJavaTerms()) {
            childJavaTerms.add(childJavaTerm);
            if (!(childJavaTerm instanceof JavaClass)) continue;
            JavaClass childJavaClass = (JavaClass)childJavaTerm;
            childJavaTerms.addAll(this._getAllChildJavaTerms(childJavaClass));
        }
        return childJavaTerms;
    }

    private String _getFieldType(JavaVariable javaVariable) {
        StringBundler sb = new StringBundler(4);
        sb.append(javaVariable.getAccessModifier());
        sb.append(" (((final|static|synchronized|transient|volatile)(\n| ))*)");
        sb.append("([\\s\\S]*?)");
        sb.append(javaVariable.getName());
        Pattern pattern = Pattern.compile(sb.toString());
        Matcher matcher = pattern.matcher(javaVariable.getContent());
        if (matcher.find()) {
            return matcher.group(5);
        }
        return null;
    }

    private boolean _isFinalableField(JavaClass javaClass, JavaVariable javaVariable, Pattern pattern, List<JavaTerm> allChildJavaTerms) {
        for (JavaTerm childJavaTerm : allChildJavaTerms) {
            String content = childJavaTerm.getContent();
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find() || !content.contains(javaVariable.getName())) continue;
            if (childJavaTerm instanceof JavaConstructor) {
                JavaClass constructorClass = childJavaTerm.getParentJavaClass();
                String constructorClassName = constructorClass.getName();
                if (constructorClassName.equals(javaClass.getName())) continue;
                return false;
            }
            if (childJavaTerm instanceof JavaMethod) {
                return false;
            }
            if (!(childJavaTerm instanceof JavaVariable) || !content.contains("{\n\n")) continue;
            return false;
        }
        return true;
    }
}

