/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TagAttributesCheck
extends BaseFileCheck {
    private static final Pattern _attributeNamePattern = Pattern.compile("[a-z]+[-_a-zA-Z0-9]*");

    protected String formatTagAttributes(String fileName, String line, String tag, int lineCount, boolean escapeQuotes) throws Exception {
        String s = tag;
        int y = s.indexOf(32);
        if (y == -1) {
            return line;
        }
        String tagName = s.substring(1, y);
        s = s.substring(y + 1);
        String previousAttribute = null;
        String previousAttributeAndValue = null;
        boolean wrongOrder = false;
        int x = 0;
        while ((x = s.indexOf(61)) != -1 && s.length() > x + 1) {
            String newLine;
            char delimeter;
            String attribute = s.substring(0, x);
            String trimmedAttribute = StringUtil.trim(attribute);
            if (!this._isAttributName(trimmedAttribute)) {
                return line;
            }
            if (!attribute.equals(trimmedAttribute)) {
                return StringUtil.replace(line, attribute + "=", trimmedAttribute + "=");
            }
            if (Validator.isNotNull(previousAttribute) && previousAttribute.compareToIgnoreCase(attribute) > 0) {
                wrongOrder = true;
            }
            if ((delimeter = (s = s.substring(x + 1)).charAt(0)) != '\'' && delimeter != '\"') {
                if (delimeter == ' ') {
                    return StringUtil.replace(line, attribute + "= ", attribute + "=");
                }
                if (delimeter != '&') {
                    this.addMessage(fileName, "Incorrect delimeter '" + delimeter + "'", lineCount);
                }
                return line;
            }
            s = s.substring(1);
            String value = null;
            y = -1;
            do {
                if ((y = s.indexOf(delimeter, y + 1)) != -1 && s.length() > y + 1) continue;
                return line;
            } while (!((value = s.substring(0, y)).startsWith("<%") ? this.getLevel(value, "<%", "%>") == 0 : this.getLevel(value, "<", ">") == 0));
            if (delimeter == '\'') {
                if (escapeQuotes) {
                    String newValue = StringUtil.replace(value, '\"', "&quot;");
                    return StringUtil.replace(line, "'" + value + "'", "\"" + newValue + "\"");
                }
                if (!value.contains("\"") || !tagName.contains(":")) {
                    return StringUtil.replace(line, "'" + value + "'", "\"" + value + "\"");
                }
            }
            if (delimeter == '\"' && value.contains("\"") && tagName.contains(":")) {
                return StringUtil.replace(line, "\"" + value + "\"", "'" + value + "'");
            }
            StringBundler sb = new StringBundler(5);
            sb.append(attribute);
            sb.append("=");
            sb.append(delimeter);
            sb.append(value);
            sb.append(delimeter);
            String currentAttributeAndValue = sb.toString();
            if (!tagName.contains(":") && !(newLine = this.sortHTMLTagAttributes(line, value, currentAttributeAndValue)).equals(line)) {
                return newLine;
            }
            newLine = this.formatTagAttributeType(line, tagName, currentAttributeAndValue);
            if (!newLine.equals(line)) {
                return newLine;
            }
            if (wrongOrder) {
                if (StringUtil.count(line, currentAttributeAndValue) == 1 && StringUtil.count(line, previousAttributeAndValue) == 1) {
                    line = StringUtil.replaceFirst(line, previousAttributeAndValue, currentAttributeAndValue);
                    return StringUtil.replaceLast(line, currentAttributeAndValue, previousAttributeAndValue);
                }
                return line;
            }
            if ((s = s.substring(y + 1)).startsWith(">")) {
                return line;
            }
            s = StringUtil.trimLeading(s);
            previousAttribute = attribute;
            previousAttributeAndValue = currentAttributeAndValue;
        }
        return line;
    }

    protected String formatTagAttributeType(String line, String tagName, String attributeAndValue) throws Exception {
        return line;
    }

    protected String sortHTMLTagAttributes(String line, String value, String attributeAndValue) {
        return line;
    }

    private boolean _isAttributName(String attributeName) {
        if (Validator.isNull(attributeName)) {
            return false;
        }
        Matcher matcher = _attributeNamePattern.matcher(attributeName);
        return matcher.matches();
    }
}

