/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import com.liferay.source.formatter.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLBuildFileCheck
extends BaseFileCheck {
    private final String _baseDirName;
    private final Pattern _importFilePattern = Pattern.compile("<import file=\"(.*)\"");
    private final Pattern _projectNamePattern = Pattern.compile("/(\\w*-(ext|hooks|layouttpl|portlet|theme|web))/build\\.xml$");

    public XMLBuildFileCheck(String baseDirName) {
        this._baseDirName = baseDirName;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.startsWith(this._baseDirName + "build") || fileName.contains("/build") && !fileName.contains("/tools/")) {
            this._checkBuildXML(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkBuildProjectName(String fileName, Document document) {
        Matcher matcher = this._projectNamePattern.matcher(fileName);
        if (!matcher.find()) {
            return;
        }
        String expectedProjectName = matcher.group(1);
        Element rootElement = document.getRootElement();
        String projectName = rootElement.attributeValue("name");
        if (!projectName.equals(expectedProjectName)) {
            this.addMessage(fileName, "Incorrect project name '" + projectName + "'");
        }
    }

    private void _checkBuildXML(String fileName, String absolutePath, String content) throws Exception {
        int z;
        Document document = SourceUtil.readXML(content);
        this._checkBuildProjectName(fileName, document);
        this.checkElementOrder(fileName, document.getRootElement(), "macrodef", null, new ElementComparator());
        this.checkElementOrder(fileName, document.getRootElement(), "target", null, new ElementComparator());
        int x = content.lastIndexOf("\n\t</macrodef>");
        int y = content.indexOf("\n\t<process-ivy");
        if (y != -1 && x > y) {
            this.addMessage(fileName, "Macrodefs go before process-ivy");
        }
        if ((z = content.indexOf("\n\t</target>")) != -1 && x > z) {
            this.addMessage(fileName, "Macrodefs go before targets");
        }
        this._checkImportFiles(fileName, content);
        this._checkTargetNames(fileName, absolutePath, content);
    }

    private void _checkImportFiles(String fileName, String content) {
        Matcher matcher = this._importFilePattern.matcher(content);
        while (matcher.find()) {
            String importFileName = fileName;
            int pos = importFileName.lastIndexOf("/");
            if (pos == -1) {
                return;
            }
            importFileName = importFileName.substring(0, pos + 1);
            File file = new File(importFileName = importFileName + matcher.group(1));
            if (file.exists()) continue;
            this.addMessage(fileName, "Incorrect import file '" + matcher.group(1) + "'");
        }
    }

    private void _checkTargetName(String targetName, String buildFileName, String fileName) throws Exception {
        List<String> targetNames = this._getTargetNames(buildFileName, fileName, null, false);
        if (targetNames == null || targetNames.contains(targetName)) {
            return;
        }
        int x = targetName.lastIndexOf(46);
        if (x != -1) {
            targetName = targetName.substring(x + 1);
        }
        if (!targetNames.contains(targetName)) {
            this.addMessage(fileName, "Target '" + targetName + "' does not exist");
        }
    }

    private void _checkTargetNames(String fileName, String absolutePath, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        List<Element> antCallElements = this._getElementsByName("antcall", rootElement, null);
        for (Element antCallElement : antCallElements) {
            String targetName = antCallElement.attributeValue("target");
            if (targetName == null || targetName.contains("{")) continue;
            this._checkTargetName(targetName, absolutePath, fileName);
        }
        String fileDirName = fileName.substring(0, fileName.lastIndexOf(47) + 1);
        List<Element> antElements = this._getElementsByName("ant", rootElement, null);
        for (Element antElement : antElements) {
            String antFileName;
            String targetName = antElement.attributeValue("target");
            if (targetName == null || targetName.contains("{")) continue;
            String fullDirName = fileDirName;
            String dirName = antElement.attributeValue("dir");
            if (dirName != null) {
                if (dirName.contains("{")) continue;
                fullDirName = fullDirName + dirName + "/";
            }
            if ((antFileName = antElement.attributeValue("antfile")) == null) {
                antFileName = "build.xml";
            }
            this._checkTargetName(targetName, fullDirName + antFileName, fileName);
        }
    }

    private List<Element> _getElementsByName(String name, Element element, List<Element> elements) {
        if (elements == null) {
            elements = new ArrayList<Element>();
        }
        List childElements = element.elements();
        for (Element childElement : childElements) {
            String elementName = childElement.getName();
            if (elementName.equals(name)) {
                elements.add(childElement);
            }
            elements = this._getElementsByName(name, childElement, elements);
        }
        return elements;
    }

    private List<String> _getTargetNames(String buildFileName, String fileName, List<String> targetNames, boolean importFile) throws Exception {
        if (buildFileName.contains("{")) {
            return null;
        }
        File file = new File(buildFileName);
        if (!file.exists()) {
            if (!importFile) {
                this.addMessage(fileName, "Ant element points to non-existing build file '" + buildFileName + "'");
            }
            return null;
        }
        Document document = SourceUtil.readXML(FileUtil.read(file));
        Element rootElement = document.getRootElement();
        if (targetNames == null) {
            targetNames = new ArrayList<String>();
        }
        List targetElements = rootElement.elements("target");
        for (Element targetElement : targetElements) {
            targetNames.add(targetElement.attributeValue("name"));
        }
        List importElements = rootElement.elements("import");
        for (Element importElement : importElements) {
            String buildDirName = buildFileName.substring(0, buildFileName.lastIndexOf(47) + 1);
            String importFileName = buildDirName + importElement.attributeValue("file");
            targetNames = this._getTargetNames(importFileName, fileName, targetNames, true);
        }
        return targetNames;
    }
}

