/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks.util;

import aQute.bnd.osgi.Constants;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDSourceUtil {
    public static Map<String, String> getDefinitionKeysMap() {
        return BNDSourceUtil._populateDefinitionKeysMap(ArrayUtil.append(Constants.BUNDLE_SPECIFIC_HEADERS, Constants.headers, Constants.options));
    }

    public static String getDefinitionValue(String content, String key) {
        Pattern pattern = Pattern.compile("^" + key + ": (.*)(\n|\\Z)", 8);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Map<String, Map<String, String>> getFileSpecificDefinitionKeysMap() {
        HashMap<String, Map<String, String>> fileSpecificDefinitionKeysMap = new HashMap<String, Map<String, String>>();
        fileSpecificDefinitionKeysMap.put("app.bnd", BNDSourceUtil._populateDefinitionKeysMap("Liferay-Releng-App-Description", "Liferay-Releng-App-Title", "Liferay-Releng-Bundle", "Liferay-Releng-Category", "Liferay-Releng-Demo-Url", "Liferay-Releng-Deprecated", "Liferay-Releng-Labs", "Liferay-Releng-Marketplace", "Liferay-Releng-Portal-Required", "Liferay-Releng-Public", "Liferay-Releng-Restart-Required", "Liferay-Releng-Support-Url", "Liferay-Releng-Supported"));
        fileSpecificDefinitionKeysMap.put("bnd.bnd", BNDSourceUtil._populateDefinitionKeysMap("-metatype-inherit", "Can-Redefine-Classes", "Can-Retransform-Classes", "Implementation-Version", "JPM-Command", "Liferay-Configuration-Path", "Liferay-Export-JS-Submodules", "Liferay-JS-Config", "Liferay-Releng-App-Description", "Liferay-Releng-Module-Group-Description", "Liferay-Releng-Module-Group-Title", "Liferay-Require-SchemaVersion", "Liferay-Service", "Liferay-Theme-Contributor-Type", "Liferay-Theme-Contributor-Weight", "Main-Class", "Premain-Class", "Web-ContextPath"));
        fileSpecificDefinitionKeysMap.put("common.bnd", BNDSourceUtil._populateDefinitionKeysMap("Git-Descriptor", "Git-SHA", "Javac-Compiler", "Javac-Debug", "Javac-Deprecation", "Javac-Encoding", "Liferay-Portal-Build-Date", "Liferay-Portal-Build-Number", "Liferay-Portal-Build-Time", "Liferay-Portal-Code-Name", "Liferay-Portal-Parent-Build-Number", "Liferay-Portal-Release-Info", "Liferay-Portal-Server-Info", "Liferay-Portal-Version"));
        return fileSpecificDefinitionKeysMap;
    }

    public static String getModuleName(String absolutePath) {
        int x = absolutePath.lastIndexOf("/");
        int y = absolutePath.lastIndexOf("/", x - 1);
        return absolutePath.substring(y + 1, x);
    }

    private static Map<String, String> _populateDefinitionKeysMap(String ... keys) {
        HashMap<String, String> definitionKeysMap = new HashMap<String, String>();
        for (String key : keys) {
            definitionKeysMap.put(StringUtil.toLowerCase(key), key);
        }
        return definitionKeysMap;
    }
}

