/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;

public class FilterStringWhitespaceCheck
extends AbstractCheck {
    public static final String MSG_INCORRECT_WHITESPACE = "whitespace.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{9};
    }

    public void visitToken(DetailAST detailAST) {
        this._checkMethod(detailAST, "ServiceTrackerFactory", "open");
        this._checkMethod(detailAST, "WaiterUtil", "waitForFilter");
    }

    private void _checkFilterStringAssign(DetailAST assignAST, String filterStringVariableName) {
        DetailAST nameAST = null;
        DetailAST parentAST = assignAST.getParent();
        nameAST = parentAST.getType() == 10 ? parentAST.findFirstToken(58) : assignAST.findFirstToken(58);
        String name = nameAST.getText();
        if (!name.equals(filterStringVariableName)) {
            return;
        }
        List<DetailAST> literalStringASTList = DetailASTUtil.getAllChildTokens(assignAST, true, 139);
        for (DetailAST literalStringAST : literalStringASTList) {
            String literalStringValue = literalStringAST.getText();
            if (!literalStringValue.contains(" = ")) continue;
            this.log(nameAST.getLineNo(), MSG_INCORRECT_WHITESPACE, new Object[]{name});
            return;
        }
    }

    private void _checkMethod(DetailAST detailAST, String className, String methodName) {
        List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(detailAST, className, methodName);
        for (DetailAST methodCallAST : methodCallASTList) {
            String filterStringVariableName = this._getFilterStringVariableName(methodCallAST);
            if (filterStringVariableName == null) continue;
            List<DetailAST> assignASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 80);
            for (DetailAST assignAST : assignASTList) {
                this._checkFilterStringAssign(assignAST, filterStringVariableName);
            }
        }
    }

    private String _getFilterStringVariableName(DetailAST methodCallAST) {
        DetailAST elistAST = methodCallAST.findFirstToken(34);
        List<DetailAST> exprASTList = DetailASTUtil.getAllChildTokens(elistAST, false, 28);
        if (exprASTList.size() < 2) {
            return null;
        }
        DetailAST secondParameterAST = exprASTList.get(1);
        DetailAST firstChildAST = secondParameterAST.getFirstChild();
        if (firstChildAST.getType() != 58) {
            return null;
        }
        return firstChildAST.getText();
    }
}

