/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.events;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcessUtil;
import java.sql.Connection;
import java.util.List;

public class StartupHelper {
    private static final Log _log = LogFactoryUtil.getLog(StartupHelper.class);
    private boolean _dbNew;
    private boolean _dropIndexes;
    private boolean _startupFinished;
    private boolean _upgraded;
    private boolean _upgrading;
    private boolean _verified;

    public boolean isDBNew() {
        return this._dbNew;
    }

    public boolean isStartupFinished() {
        return this._startupFinished;
    }

    public boolean isUpgraded() {
        return this._upgraded;
    }

    public boolean isUpgrading() {
        return this._upgrading;
    }

    public boolean isVerified() {
        return this._verified;
    }

    public void setDbNew(boolean dbNew) {
        this._dbNew = dbNew;
    }

    public void setDropIndexes(boolean dropIndexes) {
        this._dropIndexes = dropIndexes;
    }

    public void setStartupFinished(boolean startupFinished) {
        this._startupFinished = startupFinished;
    }

    public void updateIndexes() {
        this.updateIndexes(this._dropIndexes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndexes(boolean dropIndexes) {
        DB db = DBManagerUtil.getDB();
        Connection connection = null;
        try {
            connection = DataAccess.getConnection();
            this.updateIndexes(db, connection, dropIndexes);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e, (Throwable)e);
            }
        }
        finally {
            DataAccess.cleanUp((Connection)connection);
        }
    }

    public void updateIndexes(DB db, Connection connection, boolean dropIndexes) {
        block2: {
            try {
                ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
                String tablesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/portal-tables.sql");
                String indexesSQL = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/sql/dependencies/indexes.sql");
                db.updateIndexes(connection, tablesSQL, indexesSQL, dropIndexes);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upgradeProcess(int buildNumber) throws UpgradeException {
        this._upgrading = true;
        try {
            if (buildNumber == ReleaseInfo.getParentBuildNumber()) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Skipping upgrade process from " + buildNumber + " to " + ReleaseInfo.getParentBuildNumber()));
                }
                return;
            }
            String[] upgradeProcessClassNames = this.getUpgradeProcessClassNames("upgrade.processes");
            if (upgradeProcessClassNames.length == 0 && (upgradeProcessClassNames = this.getUpgradeProcessClassNames("upgrade.processes." + buildNumber)).length == 0) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Upgrading from " + buildNumber + " to " + ReleaseInfo.getParentBuildNumber() + " is not supported"));
                }
                System.exit(0);
            }
            List upgradeProcesses = UpgradeProcessUtil.initUpgradeProcesses((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String[])upgradeProcessClassNames);
            this._upgraded = UpgradeProcessUtil.upgradeProcess((int)buildNumber, (List)upgradeProcesses);
        }
        finally {
            this._upgrading = false;
        }
    }

    public void verifyProcess(boolean newBuildNumber, boolean verified) throws VerifyException {
        this._verified = VerifyProcessUtil.verifyProcess(this._upgraded, newBuildNumber, verified);
    }

    protected String[] getUpgradeProcessClassNames(String key) {
        return StringUtil.split((String)GetterUtil.getString((String)PropsUtil.get(key)));
    }
}

