/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.exportimport.kernel.configuration.ExportImportConfigurationSettingsMapFactory;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.MissingReferences;
import com.liferay.exportimport.kernel.model.ExportImportConfiguration;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutReference;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.service.base.LayoutServiceBaseImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.portlet.PortletPreferences;

public class LayoutServiceImpl
extends LayoutServiceBaseImpl {
    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, String typeSettings, boolean hidden, Map<Locale, String> friendlyURLMap, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, typeSettings, hidden, friendlyURLMap, serviceContext);
    }

    public Layout addLayout(long groupId, boolean privateLayout, long parentLayoutId, String name, String title, String description, String type, boolean hidden, String friendlyURL, ServiceContext serviceContext) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (parentLayoutId == 0L) {
            GroupPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (String)"ADD_LAYOUT");
        } else {
            LayoutPermissionUtil.check((PermissionChecker)permissionChecker, (long)groupId, (boolean)privateLayout, (long)parentLayoutId, (String)"ADD_LAYOUT");
        }
        return this.layoutLocalService.addLayout(this.getUserId(), groupId, privateLayout, parentLayoutId, name, title, description, type, hidden, friendlyURL, serviceContext);
    }

    public FileEntry addTempFileEntry(long groupId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.addTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName, (InputStream)inputStream, (String)mimeType);
    }

    public void deleteLayout(long groupId, boolean privateLayout, long layoutId, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"DELETE");
        this.layoutLocalService.deleteLayout(groupId, privateLayout, layoutId, serviceContext);
    }

    public void deleteLayout(long plid, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"DELETE");
        this.layoutLocalService.deleteLayout(plid, serviceContext);
    }

    public void deleteTempFileEntry(long groupId, String folderName, String fileName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        TempFileEntryUtil.deleteTempFileEntry((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}), (String)fileName);
    }

    @Deprecated
    public byte[] exportLayouts(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    @Deprecated
    public byte[] exportLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayouts(groupId, privateLayout, parameterMap, startDate, endDate);
    }

    @Deprecated
    public File exportLayoutsAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourceGroupId = MapUtil.getLong((Map)settingsMap, (String)"sourceGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFile(exportImportConfiguration);
    }

    @Deprecated
    public File exportLayoutsAsFile(long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFile(groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)exportImportConfiguration.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFileInBackground(this.getUserId(), exportImportConfiguration);
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(long exportImportConfigurationId) throws PortalException {
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.getExportImportConfiguration(exportImportConfigurationId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)exportImportConfiguration.getGroupId(), (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFileInBackground(this.getUserId(), exportImportConfigurationId);
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFileInBackground(this.getUserId(), taskName, groupId, privateLayout, layoutIds, parameterMap, startDate, endDate);
    }

    @Deprecated
    public long exportLayoutsAsFileInBackground(String taskName, long groupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.exportLayoutsAsFileInBackground(this.getUserId(), taskName, groupId, privateLayout, layoutIds, parameterMap, startDate, endDate, fileName);
    }

    @Deprecated
    public byte[] exportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfo(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    @Deprecated
    public byte[] exportPortletInfo(long companyId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        Group companyGroup = this.groupLocalService.getCompanyGroup(companyId);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfo(companyId, portletId, parameterMap, startDate, endDate);
    }

    @Deprecated
    public File exportPortletInfoAsFile(ExportImportConfiguration exportImportConfiguration) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long sourcePlid = MapUtil.getLong((Map)settingsMap, (String)"sourcePlid");
        Layout layout = this.layoutLocalService.getLayout(sourcePlid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFile(exportImportConfiguration);
    }

    @Deprecated
    public File exportPortletInfoAsFile(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFile(plid, groupId, portletId, parameterMap, startDate, endDate);
    }

    @Deprecated
    public File exportPortletInfoAsFile(String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFile(user.getCompanyId(), portletId, parameterMap, startDate, endDate);
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layout.getGroupId(), (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFileInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, startDate, endDate, fileName);
    }

    @Deprecated
    public long exportPortletInfoAsFileInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, Date startDate, Date endDate, String fileName) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.exportPortletInfoAsFileInBackground(this.getUserId(), taskName, portletId, parameterMap, startDate, endDate, fileName);
    }

    public List<Layout> getAncestorLayouts(long plid) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(plid);
        List ancestors = layout.getAncestors();
        return this.filterLayouts(ancestors);
    }

    public long getDefaultPlid(long groupId, long scopeGroupId, boolean privateLayout, String portletId) throws PortalException {
        if (groupId <= 0L) {
            return 0L;
        }
        PermissionChecker permissionChecker = this.getPermissionChecker();
        String scopeGroupLayoutUuid = null;
        Group scopeGroup = this.groupLocalService.getGroup(scopeGroupId);
        if (scopeGroup.isLayout()) {
            Layout scopeGroupLayout = this.layoutLocalService.getLayout(scopeGroup.getClassPK());
            scopeGroupLayoutUuid = scopeGroupLayout.getUuid();
        }
        Map jxPortletPreferencesMap = PortletPreferencesFactoryUtil.getPortletSetupMap((long)scopeGroup.getCompanyId(), (long)groupId, (long)0L, (int)3, (String)portletId, (boolean)privateLayout);
        for (Map.Entry entry : jxPortletPreferencesMap.entrySet()) {
            LayoutTypePortlet layoutTypePortlet;
            long plid = (Long)entry.getKey();
            Layout layout = null;
            try {
                layout = this.layoutLocalService.getLayout(plid);
            }
            catch (NoSuchLayoutException nsle) {
                continue;
            }
            if (!LayoutPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (String)"VIEW") || !layout.isTypePortlet() || !(layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType()).hasPortletId(portletId)) continue;
            PortletPreferences jxPortletPreferences = (PortletPreferences)entry.getValue();
            String scopeType = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeType", null));
            if (scopeGroup.isLayout()) {
                String scopeLayoutUuid = GetterUtil.getString((String)jxPortletPreferences.getValue("lfrScopeLayoutUuid", null));
                if (!Validator.isNotNull((String)scopeType) || !Validator.isNotNull((String)scopeLayoutUuid) || !scopeLayoutUuid.equals(scopeGroupLayoutUuid)) continue;
                return layout.getPlid();
            }
            if (!(scopeGroup.isCompany() ? Validator.isNotNull((String)scopeType) && scopeType.equals("company") : Validator.isNull((String)scopeType))) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    @ThreadLocalCachable
    public long getDefaultPlid(long groupId, long scopeGroupId, String portletId) throws PortalException {
        long plid = this.getDefaultPlid(groupId, scopeGroupId, false, portletId);
        if (plid == 0L) {
            plid = this.getDefaultPlid(groupId, scopeGroupId, true, portletId);
        }
        return plid;
    }

    public Layout getLayoutByUuidAndGroupId(String uuid, long groupId, boolean privateLayout) throws PortalException {
        Layout layout = this.layoutLocalService.getLayoutByUuidAndGroupId(uuid, groupId, privateLayout);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout;
    }

    public String getLayoutName(long groupId, boolean privateLayout, long layoutId, String languageId) throws PortalException {
        Layout layout = this.layoutLocalService.getLayout(groupId, privateLayout, layoutId);
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW");
        return layout.getName(languageId);
    }

    public LayoutReference[] getLayoutReferences(long companyId, String portletId, String preferencesKey, String preferencesValue) {
        LayoutReference[] layoutReferences = this.layoutLocalService.getLayouts(companyId, portletId, preferencesKey, preferencesValue);
        ArrayList<LayoutReference> filteredLayoutReferences = new ArrayList<LayoutReference>(layoutReferences.length);
        for (LayoutReference layoutReference : layoutReferences) {
            try {
                if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)layoutReference.getLayoutSoap().getPlid(), (String)"VIEW")) continue;
                filteredLayoutReferences.add(layoutReference);
            }
            catch (PortalException pe) {
                // empty catch block
            }
        }
        return filteredLayoutReferences.toArray(new LayoutReference[filteredLayoutReferences.size()]);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout) {
        return this.layoutPersistence.filterFindByG_P(groupId, privateLayout);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId) throws PortalException {
        List layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId);
        return this.filterLayouts(layouts);
    }

    public List<Layout> getLayouts(long groupId, boolean privateLayout, long parentLayoutId, boolean incomplete, int start, int end) throws PortalException {
        List layouts = this.layoutLocalService.getLayouts(groupId, privateLayout, parentLayoutId, incomplete, start, end);
        return this.filterLayouts(layouts);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId) {
        return this.layoutPersistence.filterCountByG_P_P(groupId, privateLayout, parentLayoutId);
    }

    public int getLayoutsCount(long groupId, boolean privateLayout, long parentLayoutId, int priority) {
        return this.layoutPersistence.filterCountByG_P_P_LtP(groupId, privateLayout, parentLayoutId, priority);
    }

    public String[] getTempFileNames(long groupId, String folderName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return TempFileEntryUtil.getTempFileNames((long)groupId, (long)this.getUserId(), (String)DigesterUtil.digestHex((String)"SHA-256", (String[])new String[]{folderName}));
    }

    @Deprecated
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(exportImportConfiguration, file);
    }

    @Deprecated
    public void importLayouts(ExportImportConfiguration exportImportConfiguration, InputStream is) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(exportImportConfiguration, is);
    }

    @Deprecated
    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, byte[] bytes) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, bytes);
    }

    @Deprecated
    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, file);
    }

    @Deprecated
    public void importLayouts(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        this.layoutLocalService.importLayouts(this.getUserId(), groupId, privateLayout, parameterMap, is);
    }

    @Deprecated
    public long importLayoutsInBackground(String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.importLayoutsInBackground(this.getUserId(), taskName, groupId, privateLayout, parameterMap, file);
    }

    @Deprecated
    public long importLayoutsInBackground(String taskName, long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.importLayoutsInBackground(this.getUserId(), taskName, groupId, privateLayout, parameterMap, inputStream);
    }

    @Deprecated
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(exportImportConfiguration, file);
    }

    @Deprecated
    public void importPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream is) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(exportImportConfiguration, is);
    }

    @Deprecated
    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, file);
    }

    @Deprecated
    public void importPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, is);
    }

    @Deprecated
    public void importPortletInfo(String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), portletId, parameterMap, file);
    }

    @Deprecated
    public void importPortletInfo(String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfo(this.getUserId(), portletId, parameterMap, is);
    }

    @Deprecated
    public long importPortletInfoInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, file);
    }

    @Deprecated
    public long importPortletInfoInBackground(String taskName, long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_PORTLET_INFO");
        return this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, plid, groupId, portletId, parameterMap, is);
    }

    @Deprecated
    public void importPortletInfoInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, portletId, parameterMap, file);
    }

    @Deprecated
    public void importPortletInfoInBackground(String taskName, String portletId, Map<String, String[]> parameterMap, InputStream is) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Group companyGroup = this.groupLocalService.getCompanyGroup(user.getCompanyId());
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (Group)companyGroup, (String)"EXPORT_IMPORT_PORTLET_INFO");
        this.layoutLocalService.importPortletInfoInBackground(this.getUserId(), taskName, portletId, parameterMap, is);
    }

    @Deprecated
    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        this.schedulePublishToLive(sourceGroupId, targetGroupId, privateLayout, layoutIds, parameterMap, groupName, cronText, schedulerStartDate, schedulerEndDate, description);
    }

    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, long[] layoutIds, Map<String, String[]> parameterMap, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)PortalUUIDUtil.generate(), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText);
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutLocalSettingsMap = ExportImportConfigurationSettingsMapFactory.buildPublishLayoutLocalSettingsMap((User)user, (long)sourceGroupId, (long)targetGroupId, (boolean)privateLayout, (long[])layoutIds, parameterMap);
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 3, publishLayoutLocalSettingsMap);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_local_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), (int)0);
    }

    @Deprecated
    public void schedulePublishToLive(long sourceGroupId, long targetGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String scope, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        this.schedulePublishToLive(sourceGroupId, targetGroupId, privateLayout, ExportImportHelperUtil.getLayoutIds(layoutIdMap, (long)targetGroupId), parameterMap, groupName, cronText, schedulerStartDate, schedulerEndDate, description);
    }

    public void schedulePublishToRemote(long sourceGroupId, boolean privateLayout, Map<Long, Boolean> layoutIdMap, Map<String, String[]> parameterMap, String remoteAddress, int remotePort, String remotePathContext, boolean secureConnection, long remoteGroupId, boolean remotePrivateLayout, Date startDate, Date endDate, String groupName, String cronText, Date schedulerStartDate, Date schedulerEndDate, String description) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)sourceGroupId, (String)"PUBLISH_STAGING");
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)PortalUUIDUtil.generate(), (String)groupName, (Date)schedulerStartDate, (Date)schedulerEndDate, (String)cronText);
        User user = this.userPersistence.findByPrimaryKey(this.getUserId());
        Map publishLayoutRemoteSettingsMap = ExportImportConfigurationSettingsMapFactory.buildPublishLayoutRemoteSettingsMap((long)this.getUserId(), (long)sourceGroupId, (boolean)privateLayout, layoutIdMap, parameterMap, (String)remoteAddress, (int)remotePort, (String)remotePathContext, (boolean)secureConnection, (long)remoteGroupId, (boolean)remotePrivateLayout, (Locale)user.getLocale(), (TimeZone)user.getTimeZone());
        ExportImportConfiguration exportImportConfiguration = this.exportImportConfigurationLocalService.addDraftExportImportConfiguration(this.getUserId(), description, 4, publishLayoutRemoteSettingsMap);
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, (String)description, (String)"liferay/layouts_remote_publisher", (Object)exportImportConfiguration.getExportImportConfigurationId(), (int)0);
    }

    public void setLayouts(long groupId, boolean privateLayout, long parentLayoutId, long[] layoutIds, ServiceContext serviceContext) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"UPDATE");
        this.layoutLocalService.setLayouts(groupId, privateLayout, parentLayoutId, layoutIds, serviceContext);
    }

    public void unschedulePublishToLive(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public void unschedulePublishToRemote(long groupId, String jobName, String groupName) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"PUBLISH_STAGING");
        SchedulerEngineHelperUtil.delete((String)jobName, (String)groupName, (StorageType)StorageType.PERSISTED);
    }

    public Layout updateIconImage(long plid, byte[] bytes) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateIconImage(plid, bytes);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, long parentLayoutId, Map<Locale, String> localeNamesMap, Map<Locale, String> localeTitlesMap, Map<Locale, String> descriptionMap, Map<Locale, String> keywordsMap, Map<Locale, String> robotsMap, String type, boolean hidden, Map<Locale, String> friendlyURLMap, boolean iconImage, byte[] iconBytes, ServiceContext serviceContext) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, parentLayoutId, localeNamesMap, localeTitlesMap, descriptionMap, keywordsMap, robotsMap, type, hidden, friendlyURLMap, iconImage, iconBytes, serviceContext);
    }

    public Layout updateLayout(long groupId, boolean privateLayout, long layoutId, String typeSettings) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateLayout(groupId, privateLayout, layoutId, typeSettings);
    }

    public Layout updateLookAndFeel(long groupId, boolean privateLayout, long layoutId, String themeId, String colorSchemeId, String css) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        if (Validator.isNotNull((String)themeId)) {
            this.pluginSettingLocalService.checkPermission(this.getUserId(), themeId, "theme");
        }
        return this.layoutLocalService.updateLookAndFeel(groupId, privateLayout, layoutId, themeId, colorSchemeId, css);
    }

    public Layout updateName(long groupId, boolean privateLayout, long layoutId, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateName(groupId, privateLayout, layoutId, name, languageId);
    }

    public Layout updateName(long plid, String name, String languageId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateName(plid, name, languageId);
    }

    public Layout updateParentLayoutId(long groupId, boolean privateLayout, long layoutId, long parentLayoutId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(groupId, privateLayout, layoutId, parentLayoutId);
    }

    public Layout updateParentLayoutId(long plid, long parentPlid) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutId(plid, parentPlid);
    }

    public Layout updateParentLayoutIdAndPriority(long plid, long parentPlid, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updateParentLayoutIdAndPriority(plid, parentPlid, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, priority);
    }

    public Layout updatePriority(long groupId, boolean privateLayout, long layoutId, long nextLayoutId, long previousLayoutId) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (boolean)privateLayout, (long)layoutId, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(groupId, privateLayout, layoutId, nextLayoutId, previousLayoutId);
    }

    public Layout updatePriority(long plid, int priority) throws PortalException {
        LayoutPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)"UPDATE");
        return this.layoutLocalService.updatePriority(plid, priority);
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(exportImportConfiguration, file);
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetGroupId = MapUtil.getLong((Map)settingsMap, (String)"targetGroupId");
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetGroupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(exportImportConfiguration, inputStream);
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, File file) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(this.getUserId(), groupId, privateLayout, parameterMap, file);
    }

    @Deprecated
    public MissingReferences validateImportLayoutsFile(long groupId, boolean privateLayout, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"EXPORT_IMPORT_LAYOUTS");
        return this.layoutLocalService.validateImportLayoutsFile(this.getUserId(), groupId, privateLayout, parameterMap, inputStream);
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, File file) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetPlid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(exportImportConfiguration, file);
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(ExportImportConfiguration exportImportConfiguration, InputStream inputStream) throws PortalException {
        Map settingsMap = exportImportConfiguration.getSettingsMap();
        long targetPlid = MapUtil.getLong((Map)settingsMap, (String)"targetPlid");
        String portletId = MapUtil.getString((Map)settingsMap, (String)"portletId");
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)targetPlid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(exportImportConfiguration, inputStream);
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, File file) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, file);
    }

    @Deprecated
    public MissingReferences validateImportPortletInfo(long plid, long groupId, String portletId, Map<String, String[]> parameterMap, InputStream inputStream) throws PortalException {
        PortletPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)plid, (String)portletId, (String)"CONFIGURATION");
        return this.layoutLocalService.validateImportPortletInfo(this.getUserId(), plid, groupId, portletId, parameterMap, inputStream);
    }

    protected List<Layout> filterLayouts(List<Layout> layouts) throws PortalException {
        ArrayList<Layout> filteredLayouts = new ArrayList<Layout>();
        for (Layout layout : layouts) {
            if (!LayoutPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (Layout)layout, (String)"VIEW")) continue;
            filteredLayouts.add(layout);
        }
        return filteredLayouts;
    }
}

