/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.servlet.ServletOutputStreamAdapter;
import com.liferay.portal.kernel.util.UnsyncPrintWriterPool;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.util.servlet.NullServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.ActionResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class PortletServletResponse
extends HttpServletResponseWrapper {
    private final boolean _include;
    private final String _lifecycle;
    private final PortletResponse _portletResponse;

    public PortletServletResponse(HttpServletResponse response, PortletResponse portletResponse, boolean include) {
        super(response);
        this._portletResponse = portletResponse;
        this._include = include;
        PortletResponseImpl portletResponseImpl = PortletResponseImpl.getPortletResponseImpl(portletResponse);
        this._lifecycle = portletResponseImpl.getLifecycle();
    }

    public void addCookie(Cookie cookie) {
        if (!this._include) {
            this._portletResponse.addProperty(cookie);
        }
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addHeader(String name, String value) {
        if (!this._include && (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE"))) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.setProperty(name, value);
        }
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public boolean containsHeader(String name) {
        return false;
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return null;
    }

    public String encodeRedirectURL(String url) {
        return null;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this._portletResponse.encodeURL(url);
    }

    public String encodeURL(String url) {
        return this._portletResponse.encodeURL(url);
    }

    public void flushBuffer() throws IOException {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.flushBuffer();
        }
    }

    public int getBufferSize() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.getBufferSize();
        }
        return 0;
    }

    public String getCharacterEncoding() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.getCharacterEncoding();
        }
        return null;
    }

    public String getContentType() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.getContentType();
        }
        return null;
    }

    public Locale getLocale() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.getLocale();
        }
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            OutputStream portletOutputStream = mimeResponse.getPortletOutputStream();
            ServletOutputStreamAdapter servletOutputStream = new ServletOutputStreamAdapter(portletOutputStream);
            return servletOutputStream;
        }
        return new NullServletOutputStream();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.getWriter();
        }
        return UnsyncPrintWriterPool.borrow((OutputStream)new NullServletOutputStream(), (String)this.getCharacterEncoding());
    }

    public boolean isCommitted() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            return mimeResponse.isCommitted();
        }
        return this._include;
    }

    public void reset() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.reset();
        }
    }

    public void resetBuffer() {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.resetBuffer();
        }
    }

    public void sendError(int status) {
    }

    public void sendError(int status, String message) {
    }

    public void sendRedirect(String location) throws IOException {
        if (!this._include && this._lifecycle.equals("ACTION_PHASE")) {
            ActionResponse actionResponse = this._getActionResponse();
            actionResponse.sendRedirect(location);
        }
    }

    public void setBufferSize(int bufferSize) {
        if (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE")) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.setBufferSize(bufferSize);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        if (!this._include && this._lifecycle.equals("RESOURCE_PHASE")) {
            ResourceResponse resourceResponse = this._getResourceResponse();
            resourceResponse.setCharacterEncoding(characterEncoding);
        }
    }

    public void setContentLength(int contentLength) {
        if (!this._include && this._lifecycle.equals("RESOURCE_PHASE")) {
            ResourceResponse resourceResponse = this._getResourceResponse();
            resourceResponse.setContentLength(contentLength);
        }
    }

    public void setContentType(String contentType) {
        if (!this._include && (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE"))) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.setContentType(contentType);
        }
    }

    public void setDateHeader(String name, long date) {
        this.setHeader(name, String.valueOf(date));
    }

    public void setHeader(String name, String value) {
        if (!this._include && (this._lifecycle.equals("RENDER_PHASE") || this._lifecycle.equals("RESOURCE_PHASE"))) {
            MimeResponse mimeResponse = this._getMimeResponse();
            mimeResponse.setProperty(name, value);
        }
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, String.valueOf(value));
    }

    public void setLocale(Locale locale) {
        if (!this._include && this._lifecycle.equals("RESOURCE_PHASE")) {
            ResourceResponse resourceResponse = this._getResourceResponse();
            resourceResponse.setLocale(locale);
        }
    }

    public void setStatus(int status) {
        if (!this._include && this._lifecycle.equals("RESOURCE_PHASE")) {
            ResourceResponse resourceResponse = this._getResourceResponse();
            resourceResponse.setProperty("portlet.http-status-code", String.valueOf(status));
        }
    }

    @Deprecated
    public void setStatus(int status, String message) {
        this.setStatus(status);
    }

    private ActionResponse _getActionResponse() {
        return (ActionResponse)this._portletResponse;
    }

    private MimeResponse _getMimeResponse() {
        return (MimeResponse)this._portletResponse;
    }

    private ResourceResponse _getResourceResponse() {
        return (ResourceResponse)this._portletResponse;
    }
}

