/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.JavaSourceProcessor;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.SourceMismatchException;
import com.liferay.source.formatter.SourceProcessor;
import com.liferay.source.formatter.checks.FileCheck;
import com.liferay.source.formatter.checks.JavaTermCheck;
import com.liferay.source.formatter.checks.SourceCheck;
import com.liferay.source.formatter.checks.configuration.ConfigurationLoader;
import com.liferay.source.formatter.checks.configuration.SourceCheckConfiguration;
import com.liferay.source.formatter.checks.configuration.SourceFormatterConfiguration;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaClassParser;
import com.liferay.source.formatter.parser.ParseException;
import com.liferay.source.formatter.util.FileUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public abstract class BaseSourceProcessor
implements SourceProcessor {
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;
    protected static Pattern javaSourceInsideJSPLinePattern = Pattern.compile("<%=(.+?)%>");
    protected static boolean portalSource;
    protected static boolean subrepository;
    protected SourceFormatterArgs sourceFormatterArgs;
    private static final String _DOCUMENTATION_URL = "https://github.com/liferay/liferay-portal/blob/master/modules/util/source-formatter/documentation/";
    private List<String> _allFileNames;
    private boolean _browserStarted;
    private String[] _excludes;
    private SourceMismatchException _firstSourceMismatchException;
    private final List<String> _modifiedFileNames = new CopyOnWriteArrayList<String>();
    private List<String> _pluginsInsideModulesDirectoryNames;
    private Properties _properties;
    private List<SourceCheck> _sourceChecks = new ArrayList<SourceCheck>();
    private Map<String, Set<SourceFormatterMessage>> _sourceFormatterMessagesMap = new ConcurrentHashMap<String, Set<SourceFormatterMessage>>();

    @Override
    public final void format() throws Exception {
        List<String> fileNames;
        if (this.sourceFormatterArgs.isShowDocumentation()) {
            System.setProperty("java.awt.headless", "false");
        }
        if ((fileNames = this.getFileNames()).isEmpty()) {
            return;
        }
        this._pluginsInsideModulesDirectoryNames = this.getPluginsInsideModulesDirectoryNames();
        this._sourceChecks = this._getSourceChecks(this._containsModuleFile(fileNames));
        ExecutorService executorService = Executors.newFixedThreadPool(this.sourceFormatterArgs.getProcessorThreadCount());
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(fileNames.size());
        for (final String string : fileNames) {
            Future<Void> future = executorService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    try {
                        BaseSourceProcessor.this._format(string);
                        return null;
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Unable to format " + string, e);
                    }
                }
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        this.postFormat();
    }

    public final List<String> getFileNames() throws Exception {
        List<String> fileNames = this.sourceFormatterArgs.getFileNames();
        if (fileNames != null) {
            return fileNames;
        }
        return this.doGetFileNames();
    }

    @Override
    public SourceMismatchException getFirstSourceMismatchException() {
        return this._firstSourceMismatchException;
    }

    @Override
    public String[] getIncludes() {
        return this.filterIncludes(this.doGetIncludes());
    }

    @Override
    public List<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    @Override
    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        TreeSet<SourceFormatterMessage> sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        for (Map.Entry<String, Set<SourceFormatterMessage>> entry : this._sourceFormatterMessagesMap.entrySet()) {
            sourceFormatterMessages.addAll((Collection<SourceFormatterMessage>)entry.getValue());
        }
        return sourceFormatterMessages;
    }

    @Override
    public void setAllFileNames(List<String> allFileNames) {
        this._allFileNames = allFileNames;
    }

    @Override
    public void setProperties(Properties properties) {
        this._properties = properties;
    }

    @Override
    public void setSourceFormatterArgs(SourceFormatterArgs sourceFormatterArgs) {
        this.sourceFormatterArgs = sourceFormatterArgs;
        this._init();
    }

    protected abstract List<String> doGetFileNames() throws Exception;

    protected abstract String[] doGetIncludes();

    protected String[] filterIncludes(String[] includes) {
        List<String> fileExtensions = this.sourceFormatterArgs.getFileExtensions();
        if (fileExtensions.isEmpty()) {
            return includes;
        }
        String[] filteredIncludes = new String[]{};
        for (String include : includes) {
            for (String fileExtension : fileExtensions) {
                if (!include.endsWith(fileExtension)) continue;
                filteredIncludes = ArrayUtil.append(filteredIncludes, include);
            }
        }
        return filteredIncludes;
    }

    protected File getFile(String fileName, int level) {
        return SourceFormatterUtil.getFile(this.sourceFormatterArgs.getBaseDirName(), fileName, level);
    }

    protected List<String> getFileNames(String basedir, String[] excludes, String[] includes) throws Exception {
        if (this._excludes != null) {
            excludes = ArrayUtil.append(excludes, this._excludes);
        }
        return SourceFormatterUtil.scanForFiles(basedir, excludes, includes, this.sourceFormatterArgs.isIncludeSubrepositories());
    }

    protected List<String> getFileNames(String[] excludes, String[] includes) throws Exception {
        return this.getFileNames(excludes, includes, false);
    }

    protected List<String> getFileNames(String[] excludes, String[] includes, boolean forceIncludeAllFiles) throws Exception {
        if (this._excludes != null) {
            excludes = ArrayUtil.append(excludes, this._excludes);
        }
        if (!forceIncludeAllFiles && this.sourceFormatterArgs.getRecentChangesFileNames() != null) {
            return SourceFormatterUtil.filterRecentChangesFileNames(this.sourceFormatterArgs.getBaseDirName(), this.sourceFormatterArgs.getRecentChangesFileNames(), excludes, includes, this.sourceFormatterArgs.isIncludeSubrepositories());
        }
        return SourceFormatterUtil.filterFileNames(this._allFileNames, excludes, includes);
    }

    protected List<String> getPluginsInsideModulesDirectoryNames() throws Exception {
        if (this._pluginsInsideModulesDirectoryNames != null) {
            return this._pluginsInsideModulesDirectoryNames;
        }
        ArrayList<String> pluginsInsideModulesDirectoryNames = new ArrayList<String>();
        List<String> pluginBuildFileNames = this.getFileNames(new String[0], new String[]{"**/modules/apps/**/build.xml", "**/modules/private/apps/**/build.xml"}, true);
        for (String pluginBuildFileName : pluginBuildFileNames) {
            String absolutePath = this._getAbsolutePath(pluginBuildFileName = StringUtil.replace(pluginBuildFileName, '\\', '/'));
            int x = absolutePath.indexOf("/modules/apps/");
            if (x == -1) {
                x = absolutePath.indexOf("/modules/private/apps/");
            }
            int y = absolutePath.lastIndexOf("/");
            pluginsInsideModulesDirectoryNames.add(absolutePath.substring(x, y + 1));
        }
        return pluginsInsideModulesDirectoryNames;
    }

    protected String getProperty(String key) {
        return this._properties.getProperty(key);
    }

    protected List<String> getPropertyList(String key) {
        return ListUtil.fromString(GetterUtil.getString(this.getProperty(key)), ",");
    }

    protected void postFormat() throws Exception {
    }

    protected void printError(String fileName, String message) {
        if (this.sourceFormatterArgs.isPrintErrors()) {
            SourceFormatterUtil.printError(fileName, message);
        }
    }

    protected void processFormattedFile(File file, String fileName, String content, String newContent) throws Exception {
        Set<SourceFormatterMessage> sourceFormatterMessages;
        if (!content.equals(newContent)) {
            if (this.sourceFormatterArgs.isPrintErrors()) {
                SourceFormatterUtil.printError(fileName, file);
            }
            if (this.sourceFormatterArgs.isAutoFix()) {
                FileUtil.write(file, newContent);
            } else if (this._firstSourceMismatchException == null) {
                this._firstSourceMismatchException = new SourceMismatchException(fileName, content, newContent);
            }
        }
        if (this.sourceFormatterArgs.isPrintErrors() && (sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName)) != null) {
            for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
                String markdownFileName;
                SourceFormatterUtil.printError(fileName, sourceFormatterMessage.toString());
                if (this._browserStarted || !this.sourceFormatterArgs.isShowDocumentation() || !Desktop.isDesktopSupported() || !Validator.isNotNull(markdownFileName = sourceFormatterMessage.getMarkdownFileName())) continue;
                Desktop desktop = Desktop.getDesktop();
                desktop.browse(new URI(_DOCUMENTATION_URL + markdownFileName));
                this._browserStarted = true;
            }
        }
        this._modifiedFileNames.add(file.getAbsolutePath());
    }

    protected void processMessage(String fileName, SourceFormatterMessage sourceFormatterMessage) {
        Set<SourceFormatterMessage> sourceFormatterMessages = this._sourceFormatterMessagesMap.get(fileName);
        if (sourceFormatterMessages == null) {
            sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
        }
        sourceFormatterMessages.add(sourceFormatterMessage);
        this._sourceFormatterMessagesMap.put(fileName, sourceFormatterMessages);
    }

    protected void processMessage(String fileName, String message) {
        this.processMessage(fileName, new SourceFormatterMessage(fileName, message, null, -1));
    }

    protected String processSourceChecks(File file, String fileName, String absolutePath, String content) throws Exception {
        if (ListUtil.isEmpty(this._sourceChecks)) {
            return content;
        }
        JavaClass javaClass = null;
        List<JavaClass> anonymousClasses = null;
        for (SourceCheck sourceCheck : this._sourceChecks) {
            if (sourceCheck.isModulesCheck() && !this._isModulesFile(absolutePath)) continue;
            String newContent = null;
            if (sourceCheck instanceof FileCheck) {
                newContent = this._processFileCheck((FileCheck)sourceCheck, fileName, absolutePath, content);
            } else if (sourceCheck instanceof JavaTermCheck && this instanceof JavaSourceProcessor) {
                if (javaClass == null) {
                    try {
                        anonymousClasses = JavaClassParser.parseAnonymousClasses(content);
                        javaClass = JavaClassParser.parseJavaClass(fileName, content);
                    }
                    catch (ParseException pe) {
                        this.processMessage(fileName, pe.getMessage());
                        continue;
                    }
                }
                newContent = this._processJavaTermCheck((JavaTermCheck)sourceCheck, javaClass, anonymousClasses, fileName, absolutePath, content);
            }
            if (newContent.equals(content)) continue;
            return newContent;
        }
        return content;
    }

    private void _checkUTF8(File file, String fileName) throws Exception {
        byte[] bytes = FileUtil.getBytes(file);
        try {
            CharsetDecoder charsetDecoder = CharsetDecoderUtil.getCharsetDecoder("UTF-8", CodingErrorAction.REPORT);
            charsetDecoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (Exception e) {
            this.processMessage(fileName, "UTF-8");
        }
    }

    private boolean _containsModuleFile(List<String> fileNames) {
        for (String fileName : fileNames) {
            String absolutePath;
            if (!this._isMatchPath(fileName) || !this._isModulesFile(absolutePath = this._getAbsolutePath(fileName), true)) continue;
            return true;
        }
        return false;
    }

    private final String _format(File file, String fileName, String absolutePath, String content) throws Exception {
        this._sourceFormatterMessagesMap.remove(fileName);
        this._checkUTF8(file, fileName);
        String newContent = this.processSourceChecks(file, fileName, absolutePath, content);
        if (content.equals(newContent)) {
            return content;
        }
        return this._format(file, fileName, absolutePath, newContent);
    }

    private final void _format(String fileName) throws Exception {
        if (!this._isMatchPath(fileName)) {
            return;
        }
        fileName = StringUtil.replace(fileName, '\\', '/');
        String absolutePath = this._getAbsolutePath(fileName);
        File file = new File(absolutePath);
        String content = FileUtil.read(file);
        String newContent = this._format(file, fileName, absolutePath, content);
        this.processFormattedFile(file, fileName, content, newContent);
    }

    private String _getAbsolutePath(String fileName) {
        Path filePath = Paths.get(fileName, new String[0]);
        filePath = filePath.toAbsolutePath();
        filePath = filePath.normalize();
        return StringUtil.replace(filePath.toString(), '\\', '/');
    }

    private String[] _getExcludes() {
        if (this.sourceFormatterArgs.getFileNames() != null) {
            return new String[0];
        }
        List<String> excludesList = ListUtil.fromString(GetterUtil.getString(System.getProperty("source.formatter.excludes")));
        excludesList.addAll(this.getPropertyList("source.formatter.excludes"));
        return excludesList.toArray(new String[excludesList.size()]);
    }

    private List<SourceCheck> _getSourceChecks(boolean includeModuleChecks) throws Exception {
        SourceFormatterConfiguration sourceFormatterConfiguration = ConfigurationLoader.loadConfiguration("sourcechecks.xml");
        Class<?> clazz = this.getClass();
        List<SourceCheck> sourceChecks = this._getSourceChecks(sourceFormatterConfiguration, clazz.getSimpleName(), includeModuleChecks);
        sourceChecks.addAll(this._getSourceChecks(sourceFormatterConfiguration, "all", includeModuleChecks));
        return sourceChecks;
    }

    private List<SourceCheck> _getSourceChecks(SourceFormatterConfiguration sourceFormatterConfiguration, String sourceProcessorName, boolean includeModuleChecks) throws Exception {
        ArrayList<SourceCheck> sourceChecks = new ArrayList<SourceCheck>();
        List<SourceCheckConfiguration> sourceCheckConfigurations = sourceFormatterConfiguration.getSourceCheckConfigurations(sourceProcessorName);
        if (sourceCheckConfigurations == null) {
            return sourceChecks;
        }
        for (SourceCheckConfiguration sourceCheckConfiguration : sourceCheckConfigurations) {
            String sourceCheckName = sourceCheckConfiguration.getName();
            if (!sourceCheckName.contains(".")) {
                sourceCheckName = "com.liferay.source.formatter.checks." + sourceCheckName;
            }
            Class<?> sourceCheckClass = null;
            try {
                sourceCheckClass = Class.forName(sourceCheckName);
            }
            catch (ClassNotFoundException cnfe) {
                SourceFormatterUtil.printError("sourcechecks.xml", "sourcechecks.xml: Class " + sourceCheckName + " cannot be found");
                continue;
            }
            Constructor<?> declaredConstructor = sourceCheckClass.getDeclaredConstructor(new Class[0]);
            Object instance = declaredConstructor.newInstance(new Object[0]);
            if (!(instance instanceof SourceCheck)) continue;
            SourceCheck sourceCheck = (SourceCheck)instance;
            if (!portalSource && !subrepository && sourceCheck.isPortalCheck() || !includeModuleChecks && sourceCheck.isModulesCheck()) continue;
            for (String attributeName : sourceCheckConfiguration.attributeNames()) {
                BeanUtils.setProperty((Object)sourceCheck, (String)attributeName, (Object)sourceCheckConfiguration.getAttributeValue(attributeName));
            }
            this._initSourceCheck(sourceCheck);
            sourceChecks.add(sourceCheck);
        }
        return sourceChecks;
    }

    private void _init() {
        try {
            portalSource = this._isPortalSource();
            subrepository = this._isSubrepository();
            this._sourceFormatterMessagesMap = new HashMap<String, Set<SourceFormatterMessage>>();
        }
        catch (Exception e) {
            ReflectionUtil.throwException(e);
        }
        this._excludes = this._getExcludes();
    }

    private void _initSourceCheck(SourceCheck sourceCheck) throws Exception {
        sourceCheck.setAllFileNames(this._allFileNames);
        sourceCheck.setBaseDirName(this.sourceFormatterArgs.getBaseDirName());
        sourceCheck.setExcludes(this._excludes);
        sourceCheck.setMaxLineLength(this.sourceFormatterArgs.getMaxLineLength());
        sourceCheck.setPluginsInsideModulesDirectoryNames(this._pluginsInsideModulesDirectoryNames);
        sourceCheck.setPortalSource(portalSource);
        sourceCheck.setProperties(this._properties);
        sourceCheck.setSubrepository(subrepository);
        sourceCheck.init();
    }

    private boolean _isMatchPath(String fileName) {
        for (String pattern : this.getIncludes()) {
            if (!SelectorUtils.matchPath((String)this._normalizePattern(pattern), (String)fileName)) continue;
            return true;
        }
        return false;
    }

    private boolean _isModulesFile(String absolutePath) {
        return this._isModulesFile(absolutePath, false);
    }

    private boolean _isModulesFile(String absolutePath, boolean includePlugins) {
        if (subrepository) {
            return true;
        }
        if (includePlugins) {
            return absolutePath.contains("/modules/");
        }
        try {
            for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
                if (!absolutePath.contains(directoryName)) continue;
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return absolutePath.contains("/modules/");
    }

    private boolean _isPortalSource() {
        return this.getFile("portal-impl", 7) != null;
    }

    private boolean _isSubrepository() {
        String baseDirAbsolutePath = this._getAbsolutePath(this.sourceFormatterArgs.getBaseDirName());
        int x = baseDirAbsolutePath.length();
        for (int i = 0; i < 2; ++i) {
            if ((x = baseDirAbsolutePath.lastIndexOf(47, x - 1)) == -1) {
                return false;
            }
            String dirName = baseDirAbsolutePath.substring(x + 1);
            if (!dirName.startsWith("com-liferay-")) continue;
            return true;
        }
        return false;
    }

    private String _normalizePattern(String originalPattern) {
        String pattern = originalPattern.replace('/', File.separatorChar);
        if ((pattern = pattern.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    private String _processFileCheck(FileCheck fileCheck, String fileName, String absolutePath, String content) throws Exception {
        content = fileCheck.process(fileName, absolutePath, content);
        for (SourceFormatterMessage sourceFormatterMessage : fileCheck.getSourceFormatterMessages(fileName)) {
            this.processMessage(fileName, sourceFormatterMessage);
        }
        return content;
    }

    private String _processJavaTermCheck(JavaTermCheck javaTermCheck, JavaClass javaClass, List<JavaClass> anonymousClasses, String fileName, String absolutePath, String content) throws Exception {
        content = javaTermCheck.process(fileName, absolutePath, javaClass, content);
        for (SourceFormatterMessage sourceFormatterMessage : javaTermCheck.getSourceFormatterMessages(fileName)) {
            this.processMessage(fileName, sourceFormatterMessage);
        }
        for (JavaClass anonymousClass : anonymousClasses) {
            content = javaTermCheck.process(fileName, absolutePath, anonymousClass, content);
            for (SourceFormatterMessage sourceFormatterMessage : javaTermCheck.getSourceFormatterMessages(fileName)) {
                this.processMessage(fileName, sourceFormatterMessage);
            }
        }
        return content;
    }
}

