/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checkstyle.util.CheckStyleUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;

public class JavaSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.java"};
    private final Set<File> _ungeneratedFiles = new CopyOnWriteArraySet<File>();

    @Override
    protected List<String> doGetFileNames() throws Exception {
        Object[] includes = this.getIncludes();
        if (ArrayUtil.isEmpty(includes)) {
            return new ArrayList<String>();
        }
        Collection<String> fileNames = null;
        fileNames = portalSource || subrepository ? this._getPortalJavaFiles((String[])includes) : this._getPluginJavaFiles((String[])includes);
        return new ArrayList<String>(fileNames);
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected void postFormat() throws Exception {
        this._processCheckStyle();
    }

    @Override
    protected String processSourceChecks(File file, String fileName, String absolutePath, String content) throws Exception {
        if (this._hasGeneratedTag(content)) {
            return content;
        }
        this._ungeneratedFiles.add(file);
        return super.processSourceChecks(file, fileName, absolutePath, content);
    }

    private String[] _getPluginExcludes(String pluginDirectoryName) {
        return new String[]{pluginDirectoryName + "**/model/*Clp.java", pluginDirectoryName + "**/model/impl/*BaseImpl.java", pluginDirectoryName + "**/model/impl/*Model.java", pluginDirectoryName + "**/model/impl/*ModelImpl.java", pluginDirectoryName + "**/service/**/service/*Service.java", pluginDirectoryName + "**/service/**/service/*ServiceClp.java", pluginDirectoryName + "**/service/**/service/*ServiceFactory.java", pluginDirectoryName + "**/service/**/service/*ServiceUtil.java", pluginDirectoryName + "**/service/**/service/*ServiceWrapper.java", pluginDirectoryName + "**/service/**/service/ClpSerializer.java", pluginDirectoryName + "**/service/**/service/messaging/*ClpMessageListener.java", pluginDirectoryName + "**/service/**/service/persistence/*Finder.java", pluginDirectoryName + "**/service/**/service/persistence/*Util.java", pluginDirectoryName + "**/service/base/*ServiceBaseImpl.java", pluginDirectoryName + "**/service/base/*ServiceClpInvoker.java", pluginDirectoryName + "**/service/http/*JSONSerializer.java", pluginDirectoryName + "**/service/http/*ServiceHttp.java", pluginDirectoryName + "**/service/http/*ServiceJSON.java", pluginDirectoryName + "**/service/http/*ServiceSoap.java", pluginDirectoryName + "**/tools/templates/**"};
    }

    private Collection<String> _getPluginJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = this._getPluginExcludes("");
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private Collection<String> _getPortalJavaFiles(String[] includes) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        String[] excludes = new String[]{"**/*_IW.java", "**/counter/service/**", "**/jsp/*", "**/model/impl/*Model.java", "**/model/impl/*ModelImpl.java", "**/portal/service/**", "**/portal-client/**", "**/portal-web/test/**/*Test.java", "**/test/*-generated/**"};
        for (String directoryName : this.getPluginsInsideModulesDirectoryNames()) {
            excludes = ArrayUtil.append(excludes, this._getPluginExcludes("**" + directoryName));
        }
        fileNames.addAll(this.getFileNames(excludes, includes));
        excludes = new String[]{"**/portal-client/**", "**/tools/ext_tmpl/**", "**/*_IW.java", "**/test/**/*PersistenceTest.java"};
        includes = new String[]{"**/com/liferay/portal/kernel/service/ServiceContext*.java", "**/model/BaseModel.java", "**/model/impl/BaseModelImpl.java", "**/portal-test/**/portal/service/**/*.java", "**/portal-test-integration/**/portal/service/**/*.java", "**/service/Base*.java", "**/service/PersistedModelLocalService*.java", "**/service/configuration/**/*.java", "**/service/http/*HttpTest.java", "**/service/http/*SoapTest.java", "**/service/http/TunnelUtil.java", "**/service/impl/*.java", "**/service/jms/*.java", "**/service/permission/*.java", "**/service/persistence/BasePersistence.java", "**/service/persistence/BatchSession*.java", "**/service/persistence/*FinderImpl.java", "**/service/persistence/*Query.java", "**/service/persistence/impl/*.java", "**/portal-impl/test/**/*.java", "**/util-bridges/**/*.java"};
        fileNames.addAll(this.getFileNames(excludes, includes));
        return fileNames;
    }

    private List<File> _getSuppressionsFiles() throws Exception {
        File suppressionsFile;
        String fileName = "checkstyle-suppressions.xml";
        ArrayList<File> suppressionsFiles = new ArrayList<File>();
        if (portalSource && (suppressionsFile = this.getFile("portal-impl/src/" + fileName, 7)) != null) {
            suppressionsFiles.add(suppressionsFile);
        }
        int maxDirLevel = 3;
        String parentDirName = this.sourceFormatterArgs.getBaseDirName();
        if (portalSource || subrepository) {
            maxDirLevel = 6;
            parentDirName = parentDirName + "../";
        }
        for (int i = 0; i < maxDirLevel; ++i) {
            File suppressionsFile2 = new File(parentDirName + fileName);
            if (suppressionsFile2.exists()) {
                suppressionsFiles.add(suppressionsFile2);
            }
            parentDirName = parentDirName + "../";
        }
        if (!portalSource && !subrepository) {
            return suppressionsFiles;
        }
        List<String> moduleSuppressionsFileNames = this.getFileNames(new String[0], new String[]{"**/modules/**/" + fileName}, true);
        for (String moduleSuppressionsFileName : moduleSuppressionsFileNames) {
            moduleSuppressionsFileName = StringUtil.replace(moduleSuppressionsFileName, '\\', '/');
            suppressionsFiles.add(new File(moduleSuppressionsFileName));
        }
        return suppressionsFiles;
    }

    private boolean _hasGeneratedTag(String content) {
        return (content.contains("* @generated") || content.contains("$ANTLR")) && !content.contains("hasGeneratedTag");
    }

    private void _processCheckStyle() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        Set<SourceFormatterMessage> sourceFormatterMessages = CheckStyleUtil.process(this._ungeneratedFiles, this._getSuppressionsFiles(), this.sourceFormatterArgs.getBaseDirName());
        for (SourceFormatterMessage sourceFormatterMessage : sourceFormatterMessages) {
            this.processMessage(sourceFormatterMessage.getFileName(), sourceFormatterMessage);
            this.printError(sourceFormatterMessage.getFileName(), sourceFormatterMessage.toString());
        }
    }
}

