/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.WhitespaceCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BNDWhitespaceCheck
extends WhitespaceCheck {
    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        int pos = fileName.lastIndexOf("/");
        String shortFileName = fileName.substring(pos + 1);
        content = this._formatWhitespace(shortFileName, content);
        return super.doProcess(fileName, absolutePath, content);
    }

    private String _formatWhitespace(String content, Map<String, String> definitionsKeysMap) {
        if (definitionsKeysMap == null) {
            return content;
        }
        for (Map.Entry<String, String> entry : definitionsKeysMap.entrySet()) {
            String definitionKey = entry.getValue();
            Pattern pattern = Pattern.compile("(\\A|\n)" + definitionKey + ":[^ \\\\\n]");
            Matcher matcher = pattern.matcher(content);
            if (!matcher.find()) continue;
            return StringUtil.insert(content, " ", matcher.end() - 1);
        }
        return content;
    }

    private String _formatWhitespace(String shortFileName, String content) {
        content = this._formatWhitespace(content, BNDSourceUtil.getDefinitionKeysMap());
        Map<String, Map<String, String>> fileSpecificDefinitionKeysMap = BNDSourceUtil.getFileSpecificDefinitionKeysMap();
        return this._formatWhitespace(content, fileSpecificDefinitionKeysMap.get(shortFileName));
    }
}

