/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmptyArrayCheck
extends BaseFileCheck {
    private final Pattern _emptyArrayPattern = Pattern.compile("((\\[\\])+) \\{\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatEmptyArray(content);
        return content;
    }

    private String _formatEmptyArray(String content) {
        Matcher matcher = this._emptyArrayPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.end(1))) continue;
            String replacement = StringUtil.replace(matcher.group(1), "[]", "[0]");
            return StringUtil.replaceFirst(content, matcher.group(), replacement, matcher.start());
        }
        return content;
    }
}

