/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLTagCheck
extends BaseFileCheck {
    private final Pattern _assignTagsBlockPattern = Pattern.compile("((\t*)<#assign[^<#/>]*=[^<#/>]*/>(\n|$)+){2,}", 8);
    private final Pattern _incorrectAssignTagPattern = Pattern.compile("(<#assign .*=.*[^/])>(\n|$)");
    private final Pattern _multiParameterTagPattern = Pattern.compile("\n(\t*)<@.+=.+=.+/>");
    private final Pattern _singleParameterTagPattern = Pattern.compile("(<@[\\w\\.]+ \\w+)( )?=([^=]+?)/>");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this._formatMultiParameterTags(content);
        content = this._formatSingleParameterTags(content);
        return this._formatAssignTags(content);
    }

    private String _formatAssignTags(String content) {
        Matcher matcher = this._incorrectAssignTagPattern.matcher(content);
        content = matcher.replaceAll("$1 />\n");
        matcher = this._assignTagsBlockPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            String tabs = matcher.group(2);
            String replacement = StringUtil.removeSubstrings(match, "<#assign ", "<#assign\n", " />", "\n/>", "\t/>");
            replacement = StringUtil.removeChar(replacement, '\t');
            String[] lines = StringUtil.splitLines(replacement);
            StringBundler sb = new StringBundler(3 * lines.length + 5);
            sb.append(tabs);
            sb.append("<#assign");
            for (String line : lines) {
                sb.append("\n\t");
                sb.append(tabs);
                sb.append(line);
            }
            sb.append("\n");
            sb.append(tabs);
            sb.append("/>\n\n");
            content = StringUtil.replace(content, match, sb.toString());
        }
        return content;
    }

    private String _formatMultiParameterTags(String content) {
        Matcher matcher = this._multiParameterTagPattern.matcher(content);
        while (matcher.find()) {
            String match = matcher.group();
            if (match.contains("><")) continue;
            String strippedMatch = this.stripQuotes(match, '\"');
            if (StringUtil.count(strippedMatch, '=') <= 1) continue;
            String replacement = match;
            String tabs = matcher.group(1);
            int x = -1;
            while ((x = replacement.indexOf("=", x + tabs.length() + 2)) != -1) {
                if (ToolsUtil.isInsideQuotes(replacement, x)) continue;
                int y = replacement.lastIndexOf(" ", x);
                if (y == -1) break;
                replacement = replacement.substring(0, y) + "\n" + tabs + "\t" + replacement.substring(y + 1);
            }
            if (match.equals(replacement)) continue;
            replacement = StringUtil.replaceLast(replacement, "/>", "\n" + tabs + "/>");
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }

    private String _formatSingleParameterTags(String content) {
        Matcher matcher = this._singleParameterTagPattern.matcher(content);
        while (matcher.find()) {
            String group3;
            String match;
            String replacement = match = matcher.group();
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            if (group2 != null) {
                replacement = StringUtil.replaceFirst(replacement, group1 + " ", group1);
            }
            if ((group3 = matcher.group(3)).startsWith(" ")) {
                replacement = StringUtil.replaceLast(replacement, group3, group3.substring(1));
            }
            content = StringUtil.replace(content, match, replacement);
        }
        return content;
    }
}

