/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleDependenciesCheck
extends BaseFileCheck {
    private final Pattern _dependenciesPattern = Pattern.compile("^dependencies \\{(.+?\n)\\}", 40);
    private final Pattern _incorrectWhitespacePattern = Pattern.compile(":[^ \n]");
    private String _projectPathPrefix;

    @Override
    public void init() throws Exception {
        this._projectPathPrefix = this.getProjectPathPrefix();
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        return this._formatDependencies(absolutePath, content);
    }

    private String _formatDependencies(String absolutePath, String content) {
        Matcher matcher = this._dependenciesPattern.matcher(content);
        if (!matcher.find()) {
            return content;
        }
        String dependencies = matcher.group(1);
        matcher = this._incorrectWhitespacePattern.matcher(dependencies);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(dependencies, matcher.start())) continue;
            String newDependencies = StringUtil.insert(dependencies, " ", matcher.end() - 1);
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        if (dependencies.contains("'")) {
            String newDependencies = StringUtil.replace(dependencies, '\'', '\"');
            return StringUtil.replace(content, dependencies, newDependencies);
        }
        TreeSet<String> uniqueDependencies = new TreeSet<String>();
        for (String dependency : StringUtil.splitLines(dependencies)) {
            if (Validator.isNull(dependency = dependency.trim())) continue;
            uniqueDependencies.add(dependency);
        }
        StringBundler sb = new StringBundler();
        String previousConfiguration = null;
        for (String dependency : uniqueDependencies) {
            int pos;
            String configuration = dependency.substring(0, pos = dependency.indexOf(" "));
            if (configuration.equals("compile") && this.isModulesApp(absolutePath, this._projectPathPrefix, false)) {
                dependency = StringUtil.replaceFirst(dependency, "compile", "provided");
            }
            if (previousConfiguration == null || !previousConfiguration.equals(configuration)) {
                previousConfiguration = configuration;
                sb.append("\n");
            }
            sb.append("\t");
            sb.append(dependency);
            sb.append("\n");
        }
        return StringUtil.replace(content, dependencies, sb.toString());
    }
}

