/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaMethod;
import com.liferay.source.formatter.parser.JavaTerm;
import com.liferay.source.formatter.parser.JavaVariable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaCleanUpMethodVariablesCheck
extends BaseJavaTermCheck {
    private static final Map<String, String> _defaultPrimitiveValues = MapUtil.fromArray("boolean", "false", "char", "'\\\\0'", "byte", "0", "double", "0\\.0", "float", "0\\.0", "int", "0", "long", "0", "short", "0");

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        JavaClass javaClass = (JavaClass)javaTerm;
        String className = javaClass.getName();
        if (!className.endsWith("Tag")) {
            return javaTerm.getContent();
        }
        String cleanUpMethodContent = this._getCleanUpMethodContent(javaClass);
        if (cleanUpMethodContent != null) {
            this._checkVariableValues(fileName, cleanUpMethodContent, javaClass);
        }
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_CLASS};
    }

    private void _checkVariableValues(String fileName, String cleanUpMethodContent, JavaClass javaClass) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            String setVariableCommandRegex;
            String modifierDefinition;
            String variableContent;
            Pattern pattern;
            Matcher matcher;
            String variableName;
            String accessModifier;
            if (!(javaTerm instanceof JavaVariable) || !(accessModifier = javaTerm.getAccessModifier()).equals("private") || !cleanUpMethodContent.contains((variableName = javaTerm.getName()) + " =") || !(matcher = (pattern = Pattern.compile("\t(private|protected|public)\\s+(((final|static|transient|volatile)( |\n))*)([\\s\\S]*?)" + variableName)).matcher(variableContent = javaTerm.getContent())).find() || (modifierDefinition = StringUtil.trim(variableContent.substring(matcher.start(1), matcher.start(6)))).contains("final")) continue;
            String javaFieldType = StringUtil.trim(matcher.group(6));
            pattern = Pattern.compile(javaTerm.getName() + " =\\s+[a-z]\\w*\\.");
            matcher = pattern.matcher(cleanUpMethodContent);
            if (matcher.find()) continue;
            int x = variableContent.indexOf(javaTerm.getName());
            String defaultValue = this._getDefaultValue(javaFieldType);
            String setVariableCommand = variableContent.substring(x);
            if (!setVariableCommand.contains(" =")) {
                setVariableCommand = StringUtil.replaceLast(setVariableCommand, ';', " = " + defaultValue + ";");
            }
            if ((matcher = (pattern = Pattern.compile(setVariableCommandRegex = StringUtil.replace(setVariableCommand = StringUtil.replace(setVariableCommand, new String[]{"\t", "\n"}, new String[]{"", " "}), new String[]{")", "(", " ", "0\\.0"}, new String[]{"\\)", "\\(", "\\s*", "0(\\.0)?"}))).matcher(cleanUpMethodContent)).find()) continue;
            this.addMessage(fileName, "Initial value for '" + variableName + "' differs from value in cleanUp method, see LPS-66242");
        }
    }

    private String _getCleanUpMethodContent(JavaClass javaClass) {
        for (JavaTerm javaTerm : javaClass.getChildJavaTerms()) {
            String javaTermName;
            if (!(javaTerm instanceof JavaMethod) || !(javaTermName = javaTerm.getName()).equals("cleanUp")) continue;
            return javaTerm.getContent();
        }
        return null;
    }

    private String _getDefaultValue(String type) {
        if (StringUtil.isLowerCase(type)) {
            return _defaultPrimitiveValues.get(type);
        }
        return "null";
    }
}

