/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaCombineLinesCheck
extends BaseFileCheck {
    private static final String _FIT_ON_SINGLE_LINE_EXCLUDES = "fit.on.single.line.excludes";
    private final Pattern _combinedLinesPattern1 = Pattern.compile("\n(\t*).+(=|\\]) (\\{)\n");
    private final Pattern _combinedLinesPattern2 = Pattern.compile("\n(\t*)@.+(\\()\n");
    private final Pattern _combinedLinesPattern3 = Pattern.compile("(\n\t*(private|protected|public) void)\n\t+(\\w+\\(\\)( \\{)?\n)");
    private final Pattern _combinedLinesPattern4 = Pattern.compile("(\n\t*(extends|implements))\n\t+([\\w.]+ \\{\n)");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                String combinedLinesContent;
                ++lineCount;
                if (line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*")) {
                    previousLine = line;
                    continue;
                }
                int lineLength = this.getLineLength(line);
                if (lineLength > this.getMaxLineLength()) {
                    previousLine = line;
                    continue;
                }
                int lineLeadingTabCount = this.getLeadingTabCount(line);
                int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
                String trimmedLine = StringUtil.trimLeading(line);
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    int x;
                    String strippedQuotesLine = this.stripQuotes(trimmedLine);
                    String indent = "";
                    if (!trimmedLine.startsWith("}") && strippedQuotesLine.contains("}") && this.getLevel(strippedQuotesLine, "{", "}") < 0 && lineLeadingTabCount > 0) {
                        for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                            indent = indent + "\t";
                        }
                        x = line.lastIndexOf(125);
                        String string = content = StringUtil.replace(content, "\n" + line + "\n", "\n" + line.substring(0, x) + "\n" + indent + line.substring(x) + "\n");
                        return string;
                    }
                    if (!previousLine.contains("\tthrows ") && !previousLine.contains(" throws ") && previousLineLeadingTabCount == lineLeadingTabCount - 1) {
                        x = -1;
                        while ((x = previousLine.indexOf(", ", x + 1)) != -1) {
                            if (ToolsUtil.isInsideQuotes(previousLine, x)) continue;
                            String linePart = previousLine.substring(0, x);
                            if (this.getLevel(linePart = this.stripQuotes(linePart), "(", ")") != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                            linePart = previousLine.substring(x);
                            if (this.getLevel(linePart = this.stripQuotes(linePart, '\"'), "(", ")") != 0 || this.getLevel(linePart, "<", ">") != 0) continue;
                            if (Validator.isNull(indent)) {
                                for (int i = 0; i < lineLeadingTabCount - 1; ++i) {
                                    indent = indent + "\t";
                                }
                            }
                            String string = content = StringUtil.replace(content, "\n" + previousLine + "\n", "\n" + previousLine.substring(0, x + 1) + "\n" + indent + previousLine.substring(x + 2) + "\n");
                            return string;
                        }
                    }
                }
                if ((combinedLinesContent = this._getCombinedLinesContent(content, fileName, absolutePath, line, trimmedLine, lineLength, lineCount, previousLine, lineLeadingTabCount, previousLineLeadingTabCount)) != null && !combinedLinesContent.equals(content)) {
                    String string = combinedLinesContent;
                    return string;
                }
                previousLine = line;
            }
        }
        content = this._getCombinedLinesContent(content);
        content = this._getCombinedLinesContent(content, this._combinedLinesPattern1);
        content = this._getCombinedLinesContent(content, this._combinedLinesPattern2);
        return content;
    }

    private String _getCombinedLinesContent(String content) {
        Matcher matcher = this._combinedLinesPattern3.matcher(content);
        content = matcher.replaceAll("$1 $3");
        matcher = this._combinedLinesPattern4.matcher(content);
        return matcher.replaceAll("$1 $3");
    }

    private String _getCombinedLinesContent(String content, Pattern pattern) {
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            String match;
            String tabs = matcher.group(1);
            int x = matcher.start(1);
            String openChar = matcher.group(matcher.groupCount());
            int y = -1;
            if (openChar.equals("{")) {
                y = content.indexOf("\n" + tabs + "}", x);
            } else if (openChar.equals("(")) {
                y = content.indexOf("\n" + tabs + ")", x);
            }
            y = content.indexOf(10, y + 1);
            if (y < x) {
                return content;
            }
            String replacement = match = content.substring(x, y);
            while (replacement.contains("\n\t")) {
                replacement = StringUtil.replace(replacement, "\n\t", "\n");
            }
            if (this.getLineLength(replacement = StringUtil.replace(replacement, new String[]{",\n", "\n"}, new String[]{", ", ""})) > this.getMaxLineLength()) continue;
            return this._getCombinedLinesContent(StringUtil.replace(content, match, replacement), pattern);
        }
        return content;
    }

    private String _getCombinedLinesContent(String content, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, String linePart, boolean addToPreviousLine, boolean extraSpace, int numNextLinesRemoveLeadingTab) {
        int previousLineStartPos = this.getLineStartPos(content, lineCount - 1);
        if (linePart == null) {
            String combinedLine = previousLine;
            if (extraSpace) {
                combinedLine = combinedLine + " ";
            }
            combinedLine = combinedLine + trimmedLine;
            String nextLine = this.getLine(content, lineCount + 1);
            if (nextLine == null) {
                return null;
            }
            if (numNextLinesRemoveLeadingTab > 0) {
                int nextLineStartPos = this.getLineStartPos(content, lineCount + 1);
                for (int i = 0; i < numNextLinesRemoveLeadingTab; ++i) {
                    content = StringUtil.replaceFirst(content, "\t", "", nextLineStartPos);
                    nextLineStartPos = content.indexOf(10, nextLineStartPos) + 1;
                }
            }
            return StringUtil.replaceFirst(content, previousLine + "\n" + line, combinedLine, previousLineStartPos);
        }
        String firstLine = previousLine;
        String secondLine = line;
        if (addToPreviousLine) {
            if (extraSpace) {
                firstLine = firstLine + " ";
            }
            firstLine = firstLine + linePart;
            secondLine = StringUtil.replaceFirst(line, linePart, "");
        } else if (linePart.length() + lineLength <= this.getMaxLineLength() && (line.endsWith("{") || line.endsWith(";"))) {
            firstLine = StringUtil.replaceLast(firstLine, StringUtil.trim(linePart), "");
            secondLine = extraSpace ? StringUtil.replaceLast(line, "\t", "\t" + linePart + " ") : StringUtil.replaceLast(line, "\t", "\t" + linePart);
        } else {
            return null;
        }
        firstLine = StringUtil.trimTrailing(firstLine);
        return StringUtil.replaceFirst(content, previousLine + "\n" + line, firstLine + "\n" + secondLine, previousLineStartPos);
    }

    private String _getCombinedLinesContent(String content, String fileName, String absolutePath, String line, String trimmedLine, int lineLength, int lineCount, String previousLine, int lineTabCount, int previousLineTabCount) {
        String filePart;
        char c;
        int pos;
        String nextLine;
        int nextLineTabCount;
        if (Validator.isNull(line) || Validator.isNull(previousLine) || this.isExcludedPath(_FIT_ON_SINGLE_LINE_EXCLUDES, absolutePath, lineCount)) {
            return null;
        }
        String trimmedPreviousLine = StringUtil.trimLeading(previousLine);
        String strippedQuotesLine = this.stripQuotes(line);
        String strippedQuotesPreviousLine = this.stripQuotes(previousLine);
        if (strippedQuotesLine.contains("// ") || strippedQuotesLine.contains("/*") || strippedQuotesLine.contains("*/") || strippedQuotesPreviousLine.contains("// ") || strippedQuotesPreviousLine.contains("/*") || strippedQuotesPreviousLine.contains("*/")) {
            return null;
        }
        if (!trimmedPreviousLine.equals("return") && previousLine.matches(".*\\w") && trimmedLine.startsWith("(")) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, "(", true, false, 0);
        }
        if (trimmedPreviousLine.matches("((else )?if|for|try|while) \\(")) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        if (previousLine.endsWith("= new")) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, "new", false, true, 0);
        }
        if (trimmedLine.startsWith("+ ") || trimmedLine.startsWith("- ") || trimmedLine.startsWith("|| ") || trimmedLine.startsWith("&& ")) {
            int pos2 = trimmedLine.indexOf(32);
            String linePart = trimmedLine.substring(0, pos2);
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
        }
        if (previousLine.endsWith("<") && !previousLine.endsWith(" <")) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, "<", false, false, 0);
        }
        int previousLineLength = this.getLineLength(previousLine);
        if (trimmedLine.length() + previousLineLength < this.getMaxLineLength()) {
            String beforePrevousLine;
            if (trimmedPreviousLine.startsWith("for ") && previousLine.endsWith(":") && line.endsWith("{")) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (!(!previousLine.endsWith(">") || trimmedPreviousLine.startsWith("<") || this.getLevel(previousLine, "<", ">") != 0 || trimmedLine.startsWith("extends") || trimmedLine.startsWith("implements") || (beforePrevousLine = this.getLine(content, lineCount - 2)).endsWith("."))) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (!(!line.endsWith(";") || previousLine.endsWith(":") || previousLine.endsWith("[") || previousLine.endsWith("{") || previousLine.endsWith("(") || previousLine.endsWith(".") || !previousLine.contains("[") && previousLine.contains("]") || lineTabCount != previousLineTabCount + 1)) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if ((trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("else ")) && (previousLine.endsWith("||") || previousLine.endsWith("&&")) && line.endsWith("{")) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (trimmedLine.startsWith("throws") && (line.endsWith("{") || line.endsWith(";")) && lineTabCount == previousLineTabCount + 1) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
            }
            if (previousLine.endsWith("=")) {
                if (line.endsWith("{")) {
                    this.addMessage(fileName, "'" + trimmedLine + "' should be added to previous line", lineCount);
                    return null;
                }
                if (previousLine.endsWith(" =") && line.endsWith("(")) {
                    int i = 0;
                    while (true) {
                        String nextLine2;
                        if (Validator.isNull(nextLine2 = this.getLine(content, lineCount + i + 1)) || nextLine2.endsWith(") {")) {
                            if (trimmedPreviousLine.startsWith("try (") && trimmedLine.startsWith("new ") && this.getLevel(nextLine2) == -1) {
                                return null;
                            }
                            this.addMessage(fileName, "'" + trimmedLine + "' should be added to previous line", lineCount);
                            return null;
                        }
                        if (nextLine2.endsWith(") +")) {
                            return null;
                        }
                        if (nextLine2.endsWith(";")) {
                            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                        }
                        ++i;
                    }
                }
            }
            if (trimmedPreviousLine.equals("return")) {
                int i = 0;
                while (true) {
                    String nextLine3;
                    if ((nextLine3 = this.getLine(content, lineCount + i + 1)).endsWith(";")) {
                        return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                    }
                    ++i;
                }
            }
        }
        if (trimmedLine.length() + previousLineLength <= this.getMaxLineLength()) {
            if (previousLine.endsWith("(") && line.endsWith(") {") && this.getLevel(line) < 0) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
            }
            if (previousLine.endsWith(".") && !line.endsWith("(") || (previousLine.endsWith("[") || previousLine.endsWith("(")) && line.endsWith(";")) {
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
            }
        }
        if (previousLine.endsWith("=") && line.endsWith(";")) {
            String tempLine = trimmedLine;
            int pos3 = 0;
            while (true) {
                if ((pos3 = tempLine.indexOf(45)) == -1) {
                    pos3 = tempLine.indexOf(43);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(47);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf(42);
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("||");
                }
                if (pos3 == -1) {
                    pos3 = tempLine.indexOf("&&");
                }
                if (pos3 == -1) break;
                String linePart = tempLine.substring(0, pos3);
                if (this.getLevel(linePart) == 0) {
                    return null;
                }
                tempLine = tempLine.substring(0, pos3) + tempLine.substring(pos3 + 1);
            }
            int x = trimmedLine.indexOf(40);
            if (x == 0) {
                x = trimmedLine.indexOf(40, 1);
            }
            if (x != -1) {
                char previousChar;
                int y = trimmedLine.indexOf(41, x);
                int z = trimmedLine.indexOf(34);
                if (x + 1 != y && (z == -1 || z > x) && (previousChar = trimmedLine.charAt(x - 1)) != ')' && previousChar != '(' && previousChar != ' ' && previousLineLength + 1 + x < this.getMaxLineLength()) {
                    String linePart = trimmedLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "{", "}") > 0) {
                        return null;
                    }
                    if (linePart.startsWith("(") && !linePart.contains(")")) {
                        return null;
                    }
                    return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
                }
            }
        }
        if (previousLine.endsWith("+") && lineTabCount == previousLineTabCount + 1) {
            int x = -1;
            while ((x = trimmedLine.indexOf(" +", x + 1)) != -1 && previousLineLength + 3 + x <= this.getMaxLineLength()) {
                String linePart;
                if (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart = trimmedLine.substring(0, x + 2)) != 0) continue;
                if (trimmedLine.equals(linePart)) {
                    this.addMessage(fileName, "Incorrect line break", lineCount);
                    return null;
                }
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, linePart + " ", true, true, 0);
            }
        }
        if (previousLine.endsWith(",") && previousLineTabCount == lineTabCount && !trimmedPreviousLine.equals("},") && (nextLineTabCount = this.getLeadingTabCount(nextLine = this.getLine(content, lineCount + 1))) != lineTabCount + 1) {
            String linePart;
            int x = -1;
            while ((x = trimmedLine.indexOf(44, x + 1)) != -1 && (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart = trimmedLine.substring(0, x), "(", ")") != 0 || this.getLevel(linePart, "{", "}") != 0 || this.getLevel(linePart, "<", ">") != 0)) {
            }
            if (x != -1) {
                while (previousLineLength + 1 + x < this.getMaxLineLength()) {
                    linePart = trimmedLine.substring(0, x + 1);
                    if (!ToolsUtil.isInsideQuotes(trimmedLine, x) && JavaSourceUtil.isValidJavaParameter(linePart)) {
                        if (trimmedLine.equals(linePart)) {
                            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                        }
                        return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, linePart + " ", true, true, 0);
                    }
                    String partAfterComma = trimmedLine.substring(x + 1);
                    int pos4 = partAfterComma.indexOf(44);
                    if (pos4 != -1) {
                        x = x + pos4 + 1;
                        continue;
                    }
                    break;
                }
            } else if (trimmedLine.length() + previousLineLength < this.getMaxLineLength()) {
                if (!trimmedLine.startsWith("new ") || !line.endsWith("{")) {
                    return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                }
                if (this.getLevel(line) != 0) {
                    return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, 0);
                }
            }
        }
        if (trimmedPreviousLine.matches("^[^<].*[\\w>]$") && previousLineTabCount == lineTabCount - 1 && this.getLevel(previousLine, "<", ">") == 0) {
            int x = trimmedLine.indexOf(" = ");
            if (x != -1 && !ToolsUtil.isInsideQuotes(trimmedLine, x) && previousLineLength + 2 + x < this.getMaxLineLength()) {
                String linePart = trimmedLine.substring(0, x + 3);
                return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, linePart, true, true, 0);
            }
            if (trimmedLine.endsWith(" =") && trimmedLine.length() + previousLineLength < this.getMaxLineLength()) {
                int i = 0;
                while (true) {
                    String nextLine4;
                    if ((nextLine4 = this.getLine(content, lineCount + i + 1)).endsWith(";")) {
                        return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, true, i + 1);
                    }
                    ++i;
                }
            }
        }
        if (!previousLine.endsWith("(")) {
            return null;
        }
        int x = -1;
        while ((x = trimmedLine.indexOf(") ", x + 1)) != -1) {
            int y;
            String linePart2;
            String linePart1 = trimmedLine.substring(0, x);
            if (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart1) != 0 || !(linePart2 = trimmedLine.substring(x + 2)).matches("[!=<>\\+\\-\\*]+ .*") || previousLineLength + (y = trimmedLine.indexOf(" ", x + 2)) > this.getMaxLineLength()) continue;
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, trimmedLine.substring(0, y), true, true, 0);
        }
        if (!(StringUtil.count(previousLine, '(') <= 1 || (pos = trimmedPreviousLine.lastIndexOf(40, trimmedPreviousLine.length() - 2)) <= 0 || (c = trimmedPreviousLine.charAt(pos - 1)) == '(' || Character.isWhitespace(c) || (filePart = trimmedPreviousLine.substring(pos + 1)).contains(")") || filePart.contains("\""))) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, filePart, false, false, 0);
        }
        if (trimmedLine.length() + previousLineLength > this.getMaxLineLength()) {
            return null;
        }
        if (this.getLevel(trimmedLine) < 0 && (line.matches(".*[|&^]") || line.endsWith(",") || trimmedPreviousLine.startsWith("new ") && line.endsWith(") {"))) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        if ((line.endsWith("{") && !trimmedLine.startsWith("new ") || line.endsWith(")")) && (trimmedPreviousLine.startsWith("else ") || trimmedPreviousLine.startsWith("if ") || trimmedPreviousLine.startsWith("private ") || trimmedPreviousLine.startsWith("protected ") || trimmedPreviousLine.startsWith("public "))) {
            return this._getCombinedLinesContent(content, line, trimmedLine, lineLength, lineCount, previousLine, null, false, false, 0);
        }
        return null;
    }
}

