/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaLineBreakCheck
extends BaseFileCheck {
    private final Pattern _arrayPattern = Pattern.compile("(\n\t*.* =) (new \\w*\\[\\] \\{)\n(\t*)(.+)\n\t*(\\};)\n");
    private final Pattern _classPattern = Pattern.compile("(\n(\t*)(private|protected|public) ((abstract|static) )*(class|enum|interface) ([\\s\\S]*?) \\{)\n(\\s*)(\\S)");
    private final Pattern _incorrectLineBreakPattern1 = Pattern.compile("\n(\t*)(.*\\) \\{)([\t ]*\\}\n)");
    private final Pattern _incorrectLineBreakPattern2 = Pattern.compile("\n(\t*).*\\}\n(\t*)\\);");
    private final Pattern _incorrectLineBreakPattern3 = Pattern.compile("\n(\t*)\\{.+(?<!\\}(,|;)?)\n");
    private final Pattern _incorrectLineBreakPattern4 = Pattern.compile("\n(\t+\\{)\n(.*[^;])\n\t+(\\},?)");
    private final Pattern _incorrectLineBreakPattern5 = Pattern.compile(", (new .*\\(.*\\) \\{)\n");
    private final Pattern _incorrectLineBreakPattern6 = Pattern.compile("^(((else )?if|for|try|while) \\()?\\(*(.*\\()$");
    private final Pattern _incorrectMultiLineCommentPattern = Pattern.compile("(\n\t*/\\*)\n\t*(.*?)\n\t*(\\*/\n)", 32);
    private final Pattern _lineStartingWithOpenParenthesisPattern = Pattern.compile("(.)\n+(\t+)\\)[^.].*\n");
    private final Pattern _redundantCommaPattern = Pattern.compile(",\n\t+\\}");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            String line = null;
            String previousLine = "";
            int lineCount = 0;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                ++lineCount;
                String trimmedLine = StringUtil.trimLeading(line);
                if (trimmedLine.startsWith(";")) {
                    this.addMessage(fileName, "Line should not start with ';'", lineCount);
                }
                if (!trimmedLine.startsWith("//") && !trimmedLine.startsWith("*")) {
                    if (trimmedLine.startsWith(".")) {
                        this.addMessage(fileName, "Line should not start with '.'", lineCount);
                    }
                    if (previousLine.endsWith("(") && trimmedLine.startsWith(")")) {
                        this.addMessage(fileName, "Line should not start with ')'", lineCount);
                    }
                }
                int lineLength = this.getLineLength(line);
                if (!(line.startsWith("import ") || line.startsWith("package ") || line.matches("\\s*\\*.*") || lineLength > this.getMaxLineLength())) {
                    this._checkLineBreaks(line, previousLine, fileName, lineCount);
                }
                previousLine = line;
            }
        }
        content = this._fixIncorrectLineBreaks(content, fileName);
        content = this._fixLineStartingWithCloseParenthesis(content, fileName);
        content = this._fixMultiLineComment(content);
        content = this._fixArrayLineBreaks(content);
        content = this._fixClassLineLineBreaks(content);
        return content;
    }

    private void _checkLineBreaks(String line, String previousLine, String fileName, int lineCount) {
        Matcher matcher;
        int y;
        int x;
        int x2;
        String trimmedLine = StringUtil.trimLeading(line);
        if (previousLine.contains("\t/*") || trimmedLine.startsWith("//") | trimmedLine.startsWith("/*") || trimmedLine.endsWith("*/")) {
            return;
        }
        if (trimmedLine.startsWith("},") && !trimmedLine.equals("},")) {
            this.addMessage(fileName, "There should be a line break after '},'", lineCount);
        }
        int lineLeadingTabCount = this.getLeadingTabCount(line);
        int previousLineLeadingTabCount = this.getLeadingTabCount(previousLine);
        if (previousLine.endsWith(",") && previousLine.contains("(") && !previousLine.contains("for (") && lineLeadingTabCount > previousLineLeadingTabCount) {
            this.addMessage(fileName, "There should be a line break after '('", lineCount - 1);
        }
        if (previousLine.endsWith(".") && (x2 = trimmedLine.indexOf(40)) != -1 && this.getLineLength(previousLine) + x2 < this.getMaxLineLength() && (trimmedLine.endsWith("(") || trimmedLine.charAt(x2 + 1) != ')')) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        String strippedQuotesLine = this.stripQuotes(trimmedLine);
        int strippedQuotesLineOpenParenthesisCount = StringUtil.count(strippedQuotesLine, '(');
        if (!trimmedLine.startsWith("(") && trimmedLine.endsWith(") {") && strippedQuotesLineOpenParenthesisCount > 0 && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        if (line.endsWith("(")) {
            String linePart;
            int pos;
            x = line.lastIndexOf(" && ");
            int z = Math.max(x, y = line.lastIndexOf(" || "));
            if (z != -1) {
                this.addMessage(fileName, "There should be a line break after '" + line.substring(z + 1, z + 3) + "'", lineCount);
            }
            if ((pos = strippedQuotesLine.indexOf(" + ")) != -1 && this.getLevel(linePart = strippedQuotesLine.substring(0, pos), "(", ")") == 0 && this.getLevel(linePart, "[", "]") == 0) {
                this.addMessage(fileName, "There should be a line break after '+'", lineCount);
            }
            x = trimmedLine.length() + 1;
            while ((x = trimmedLine.lastIndexOf(",", x - 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x) || this.getLevel(linePart = trimmedLine.substring(x)) != 1 || this.getLevel(linePart, "<", ">") != 0) continue;
                this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, x + 1) + "'", lineCount);
                break;
            }
        }
        if (trimmedLine.matches("\\)\\..*\\([^)].*")) {
            int pos = trimmedLine.indexOf("(");
            this.addMessage(fileName, "There should be a line break after '" + trimmedLine.substring(0, pos + 1) + "'", lineCount);
        }
        if (trimmedLine.matches("^[^(].*\\+$") && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "There should be a line break after '('", lineCount);
        }
        if (!trimmedLine.contains("\t//") && !line.endsWith("{") && strippedQuotesLine.contains("{") && !strippedQuotesLine.contains("}")) {
            this.addMessage(fileName, "There should be a line break after '{'", lineCount);
        }
        if (previousLine.endsWith("(") || previousLine.endsWith("+")) {
            x = -1;
            while ((x = trimmedLine.indexOf(", ", x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(trimmedLine, x)) continue;
                String linePart = trimmedLine.substring(0, x + 1);
                int level = this.getLevel(linePart);
                if ((!previousLine.endsWith("(") || level >= 0) && (!previousLine.endsWith("+") || level > 0)) continue;
                this.addMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
            }
        }
        if ((x = trimmedLine.indexOf(", ")) != -1) {
            String linePart;
            if (!ToolsUtil.isInsideQuotes(trimmedLine, x) && this.getLevel(linePart = trimmedLine.substring(0, x + 1)) < 0) {
                this.addMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
            }
        } else if (trimmedLine.endsWith(",") && !trimmedLine.startsWith("for (") && this.getLevel(trimmedLine) > 0) {
            this.addMessage(fileName, "Incorrect line break", lineCount);
        }
        if ((line.endsWith(" +") || line.endsWith(" -") || line.endsWith(" *") || line.endsWith(" /")) && (x = line.indexOf(" = ")) != -1 && ((y = line.indexOf(34)) == -1 || x < y)) {
            this.addMessage(fileName, "There should be a line break after '='", lineCount);
        }
        if (line.endsWith(" throws") || (previousLine.endsWith(",") || previousLine.endsWith("(")) && line.contains(" throws ") && (line.endsWith("{") || line.endsWith(";"))) {
            this.addMessage(fileName, "There should be a line break before 'throws'", lineCount);
        }
        if (line.endsWith(".") && line.contains("=")) {
            this.addMessage(fileName, "There should be a line break after '='", lineCount);
        }
        if (trimmedLine.matches("^\\} (catch|else|finally) .*")) {
            this.addMessage(fileName, "There should be a line break after '}'", lineCount);
        }
        if ((matcher = this._incorrectLineBreakPattern6.matcher(trimmedLine)).find() && this.getLevel(matcher.group(4)) > 1) {
            x = trimmedLine.indexOf("(", matcher.start(4));
            String linePart = trimmedLine.substring(0, x + 1);
            this.addMessage(fileName, "There should be a line break after '" + linePart + "'", lineCount);
        }
    }

    private String _fixArrayLineBreaks(String content) {
        Matcher matcher = this._arrayPattern.matcher(content);
        while (matcher.find()) {
            String newLine = matcher.group(3) + matcher.group(2) + matcher.group(4) + matcher.group(5);
            if (this.getLineLength(newLine) > this.getMaxLineLength()) continue;
            return StringUtil.replace(content, matcher.group(), matcher.group(1) + "\n" + newLine + "\n");
        }
        return content;
    }

    private String _fixClassLineLineBreaks(String content) {
        Matcher matcher = this._classPattern.matcher(content);
        while (matcher.find()) {
            String firstTrailingNonWhitespace = matcher.group(9);
            String match = matcher.group(1);
            String trailingWhitespace = matcher.group(8);
            if (!trailingWhitespace.contains("\n") && !firstTrailingNonWhitespace.equals("}")) {
                return StringUtil.replace(content, match, match + "\n");
            }
            String formattedClassLine = this._getFormattedClassLine(matcher.group(2), match);
            if (formattedClassLine == null) continue;
            content = StringUtil.replace(content, match, formattedClassLine);
        }
        return content;
    }

    private String _fixIncorrectLineBreaks(String content, String fileName) {
        Matcher matcher;
        while (true) {
            matcher = this._incorrectLineBreakPattern1.matcher(content);
            while (matcher.find()) {
                String matchingLine = matcher.group(2);
                if (matchingLine.startsWith("//") || matchingLine.startsWith("*")) continue;
                content = StringUtil.replaceFirst(content, matcher.group(3), "\n" + matcher.group(1) + "}\n", matcher.start(3) - 1);
                break;
            }
            matcher = this._incorrectLineBreakPattern2.matcher(content);
            while (matcher.find()) {
                String match;
                String tabs = matcher.group(2);
                Pattern pattern = Pattern.compile("\n" + tabs + "([^\t]{2})(?!.*\n" + tabs + "[^\t])", 32);
                Matcher matcher2 = pattern.matcher(content.substring(0, matcher.start(2)));
                if (!matcher2.find() || (match = matcher2.group(1)).equals(").")) continue;
                content = StringUtil.replaceFirst(content, "\n" + matcher.group(2), "", matcher.end(1));
                break;
            }
            if ((matcher = this._incorrectLineBreakPattern3.matcher(content)).find()) {
                content = StringUtil.replaceFirst(content, "{", "{\n" + matcher.group(1) + "\t", matcher.start());
            }
            matcher = this._incorrectLineBreakPattern4.matcher(content);
            while (matcher.find()) {
                String singleLine;
                if (content.charAt(matcher.end()) != '\n' || this.getLineLength(singleLine = matcher.group(1) + StringUtil.trimLeading(matcher.group(2)) + matcher.group(3)) > this.getMaxLineLength()) continue;
                content = StringUtil.replace(content, matcher.group(), "\n" + singleLine);
                break;
            }
            if (!(matcher = this._redundantCommaPattern.matcher(content)).find()) break;
            content = StringUtil.replaceFirst(content, ",", "", matcher.start());
        }
        matcher = this._incorrectLineBreakPattern5.matcher(content);
        while (matcher.find()) {
            if (this.getLevel(matcher.group()) != 0) continue;
            int lineCount = this.getLineCount(content, matcher.start());
            this.addMessage(fileName, "There should be a line break before '" + matcher.group(1) + "'", lineCount);
        }
        return content;
    }

    private String _fixLineStartingWithCloseParenthesis(String content, String fileName) {
        Matcher matcher = this._lineStartingWithOpenParenthesisPattern.matcher(content);
        while (matcher.find()) {
            String line;
            String tabs = matcher.group(2);
            int lineCount = this.getLineCount(content, matcher.start(2));
            String lastCharacterPreviousLine = matcher.group(1);
            if (lastCharacterPreviousLine.equals("(")) {
                this.addMessage(fileName, "Line should not start with ')'", this.getLineCount(content, matcher.start(1)));
                return content;
            }
            while (this.getLeadingTabCount(line = this.getLine(content, --lineCount)) != tabs.length()) {
            }
            String trimmedLine = StringUtil.trimLeading(line);
            if (trimmedLine.startsWith(").") || trimmedLine.startsWith("@")) continue;
            return StringUtil.replaceFirst(content, "\n" + tabs, "", matcher.start());
        }
        return content;
    }

    private String _fixMultiLineComment(String content) {
        Matcher matcher = this._incorrectMultiLineCommentPattern.matcher(content);
        return matcher.replaceAll("$1$2$3");
    }

    private String _getFormattedClassLine(String indent, String classLine) {
        ArrayList<String> lines;
        block15: {
            while (classLine.contains("\t ")) {
                classLine = StringUtil.replace(classLine, "\t ", "\t");
            }
            String classSingleLine = StringUtil.replace(classLine.substring(1), new String[]{"\t", "\n"}, new String[]{"", " "});
            classSingleLine = indent + classSingleLine;
            lines = new ArrayList<String>();
            if (this.getLineLength(classSingleLine) <= this.getMaxLineLength()) {
                lines.add(classSingleLine);
            } else {
                int y;
                String newIndent = indent;
                String newLine = classSingleLine;
                int x = -1;
                while ((x = (y = newLine.indexOf(" extends ", x + 1)) == -1 ? newLine.indexOf(" implements ", x + 1) : y) != -1) {
                    String linePart = newLine.substring(0, x);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    if (lines.isEmpty()) {
                        newIndent = newIndent + "\t";
                    }
                    lines.add(linePart);
                    newLine = newIndent + newLine.substring(x + 1);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break block15;
                    }
                    x = -1;
                }
                if (lines.isEmpty()) {
                    return null;
                }
                x = newLine.length();
                while (true) {
                    if ((x = newLine.lastIndexOf(", ", x - 1)) == -1) {
                        return null;
                    }
                    String linePart = newLine.substring(0, x + 1);
                    if (this.getLevel(linePart, "<", ">") != 0 || this.getLineLength(linePart) > this.getMaxLineLength()) continue;
                    lines.add(linePart);
                    if (linePart.contains("\textends")) {
                        newIndent = newIndent + "\t\t";
                    } else if (linePart.contains("\timplements")) {
                        newIndent = newIndent + "\t\t   ";
                    }
                    newLine = newIndent + newLine.substring(x + 2);
                    if (this.getLineLength(newLine) <= this.getMaxLineLength()) {
                        lines.add(newLine);
                        break;
                    }
                    x = newLine.length();
                }
            }
        }
        String formattedClassLine = null;
        for (String line : lines) {
            if (formattedClassLine == null) {
                formattedClassLine = "\n" + line;
                continue;
            }
            formattedClassLine = formattedClassLine + "\n" + line;
        }
        return formattedClassLine;
    }
}

