/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import java.util.List;

public class ChainingCheck
extends AbstractCheck {
    public static final String MSG_AVOID_CHAINING = "chaining.avoid";
    public static final String MSG_AVOID_CHAINING_MULTIPLE = "chaining.avoid.multiple";
    public static final String MSG_AVOID_TOO_MANY_CONCAT = "concat.avoid.too.many";
    private String _chainingAllowedFormat;

    public int[] getDefaultTokens() {
        return new int[]{8, 9};
    }

    public void setChainingAllowedFormat(String chainingAllowedFormat) {
        this._chainingAllowedFormat = chainingAllowedFormat;
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        if (fileName.contains("/test/")) {
            return;
        }
        List<DetailAST> methodCallASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 27);
        for (DetailAST methodCallAST : methodCallASTList) {
            String chainedMethodNames;
            List<DetailAST> childMethodCallASTList = DetailASTUtil.getAllChildTokens(methodCallAST, true, 27);
            if (!childMethodCallASTList.isEmpty() || !(chainedMethodNames = this._getChainedMethodNames(methodCallAST)).contains(".")) continue;
            this._checkMethodName(chainedMethodNames, "getClass", methodCallAST, detailAST);
            if (StringUtil.count(chainedMethodNames, ".") == 1) continue;
            if (chainedMethodNames.contains("concat.concat.concat")) {
                this.log(methodCallAST.getLineNo(), MSG_AVOID_TOO_MANY_CONCAT, new Object[0]);
                continue;
            }
            if (chainedMethodNames.contains("concat.concat") || chainedMethodNames.matches(this._chainingAllowedFormat)) continue;
            this.log(methodCallAST.getLineNo(), MSG_AVOID_CHAINING_MULTIPLE, new Object[]{DetailASTUtil.getMethodName(methodCallAST)});
        }
    }

    private void _checkMethodName(String chainedMethodNames, String methodName, DetailAST methodCallAST, DetailAST detailAST) {
        if (chainedMethodNames.matches(methodName + "\\..*") && !this._isInsideConstructorThisCall(methodCallAST, detailAST)) {
            this.log(methodCallAST.getLineNo(), MSG_AVOID_CHAINING, new Object[]{methodName});
        }
    }

    private String _getChainedMethodNames(DetailAST methodCallAST) {
        StringBundler sb = new StringBundler();
        sb.append(DetailASTUtil.getMethodName(methodCallAST));
        DetailAST parentAST;
        while ((parentAST = methodCallAST.getParent()).getType() == 59) {
            methodCallAST = parentAST.getParent();
            if (methodCallAST.getType() != 27) {
                return sb.toString();
            }
            sb.append(".");
            sb.append(DetailASTUtil.getMethodName(methodCallAST));
        }
        return sb.toString();
    }

    private boolean _isInsideConstructorThisCall(DetailAST methodCallAST, DetailAST detailAST) {
        if (detailAST.getType() != 8) {
            return false;
        }
        for (DetailAST parentAST = methodCallAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            String parentASTText = parentAST.getText();
            if (parentAST.getType() != 43 || !parentASTText.equals("this")) continue;
            return true;
        }
        return false;
    }
}

