/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.dao.orm;

import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.TableNameOrderByComparator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class QueryDefinition<T> {
    private Map<String, Serializable> _attributes;
    private int _end = -1;
    private boolean _excludeStatus;
    private boolean _includeOwner;
    private OrderByComparator<T> _orderByComparator;
    private long _ownerUserId;
    private int _start = -1;
    private int _status = -1;

    public QueryDefinition() {
    }

    public QueryDefinition(int status) {
        this(status, 0L, false);
    }

    public QueryDefinition(int status, boolean excludeStatus, int start, int end, OrderByComparator<T> orderByComparator) {
        this(status, excludeStatus, 0L, false, start, end, orderByComparator);
    }

    public QueryDefinition(int status, boolean excludeStatus, long ownerUserId, boolean includeOwner, int start, int end, OrderByComparator<T> orderByComparator) {
        this._status = status;
        this._excludeStatus = excludeStatus;
        this._ownerUserId = ownerUserId;
        this._includeOwner = includeOwner;
        this._start = start;
        this._end = end;
        this.setOrderByComparator(orderByComparator);
    }

    public QueryDefinition(int status, int start, int end, OrderByComparator<T> orderByComparator) {
        this(status, 0L, false, start, end, orderByComparator);
    }

    public QueryDefinition(int status, long ownerUserId, boolean includeOwner) {
        if (status == -1) {
            this.setStatus(8, true);
        } else {
            this.setStatus(status);
        }
        this._ownerUserId = ownerUserId;
        this._includeOwner = includeOwner;
    }

    public QueryDefinition(int status, long ownerUserId, boolean includeOwner, int start, int end, OrderByComparator<T> orderByComparator) {
        if (status == -1) {
            this.setStatus(8, true);
        } else {
            this.setStatus(status);
        }
        this._ownerUserId = ownerUserId;
        this._includeOwner = includeOwner;
        this._start = start;
        this._end = end;
        this.setOrderByComparator(orderByComparator);
    }

    public Serializable getAttribute(String name) {
        if (this._attributes == null) {
            return null;
        }
        return this._attributes.get(name);
    }

    public Map<String, Serializable> getAttributes() {
        return this._attributes;
    }

    public int getEnd() {
        return this._end;
    }

    public OrderByComparator<T> getOrderByComparator() {
        return this._orderByComparator;
    }

    public OrderByComparator<T> getOrderByComparator(String tableName) {
        if (this._orderByComparator == null) {
            return null;
        }
        return new TableNameOrderByComparator<T>(this._orderByComparator, tableName);
    }

    public long getOwnerUserId() {
        return this._ownerUserId;
    }

    public int getStart() {
        return this._start;
    }

    public int getStatus() {
        return this._status;
    }

    public boolean isExcludeStatus() {
        return this._excludeStatus;
    }

    public boolean isIncludeOwner() {
        return this._includeOwner;
    }

    public void setAttribute(String name, Serializable value) {
        if (this._attributes == null) {
            this._attributes = new HashMap<String, Serializable>();
        }
        this._attributes.put(name, value);
    }

    public void setAttributes(Map<String, Serializable> attributes) {
        this._attributes = attributes;
    }

    public void setEnd(int end) {
        this._end = end;
    }

    public void setIncludeOwner(boolean includeOwner) {
        this._includeOwner = includeOwner;
    }

    public void setOrderByComparator(OrderByComparator<T> orderByComparator) {
        this._orderByComparator = orderByComparator;
    }

    public void setOwnerUserId(long ownerUserId) {
        this._ownerUserId = ownerUserId;
    }

    public void setStart(int start) {
        this._start = start;
    }

    public void setStatus(int status) {
        this.setStatus(status, false);
    }

    public void setStatus(int status, boolean exclude) {
        this._excludeStatus = exclude;
        this._status = status;
    }
}

