/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PortletBagPool {
    private static final Map<String, PortletBag> _portletBagPool = new ConcurrentHashMap<String, PortletBag>();

    public static PortletBag get(String portletId) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        return _portletBagPool.get(portletId);
    }

    public static void put(String portletId, PortletBag portletBag) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        _portletBagPool.put(portletId, portletBag);
    }

    public static PortletBag remove(String portletId) {
        PortalRuntimePermission.checkPortletBagPool(portletId);
        return _portletBagPool.remove(portletId);
    }

    public static void reset() {
        PortalRuntimePermission.checkPortletBagPool("<<ALL PORTLETS>>");
        _portletBagPool.clear();
    }

    private PortletBagPool() {
    }
}

