/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.spring.osgi;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface OSGiBeanProperties {
    public boolean portalPropertiesRemovePrefix() default true;

    public String portalPropertyPrefix() default "";

    public String[] property() default {};

    public Class<?>[] service() default {};

    public static enum Type {
        BOOLEAN,
        BYTE,
        CHARACTER,
        DOUBLE,
        FLOAT,
        INTEGER,
        LONG,
        SHORT,
        STRING;


        private static Type _getType(String name) {
            name = StringUtil.toUpperCase(name);
            for (Type type : Type.values()) {
                if (!name.equals(type.name())) continue;
                return type;
            }
            return STRING;
        }

        private Object _convert(String value, Object previousValue) {
            if (previousValue == null) {
                return this._getTypedValue(value);
            }
            Class<?> clazz = previousValue.getClass();
            if (!clazz.isArray()) {
                Object array = Array.newInstance(this._getTypeClass(), 2);
                Array.set(array, 0, previousValue);
                Array.set(array, 1, this._getTypedValue(value));
                return array;
            }
            Object array = Array.newInstance(this._getTypeClass(), Array.getLength(previousValue) + 1);
            for (int i = 0; i < Array.getLength(previousValue); ++i) {
                Array.set(array, i, Array.get(previousValue, i));
            }
            Array.set(array, Array.getLength(previousValue), this._getTypedValue(value));
            return array;
        }

        private Class<?> _getTypeClass() {
            if (this == BOOLEAN) {
                return Boolean.class;
            }
            if (this == BYTE) {
                return Byte.class;
            }
            if (this == CHARACTER) {
                return Character.class;
            }
            if (this == DOUBLE) {
                return Double.class;
            }
            if (this == FLOAT) {
                return Float.class;
            }
            if (this == INTEGER) {
                return Integer.class;
            }
            if (this == LONG) {
                return Long.class;
            }
            if (this == SHORT) {
                return Short.class;
            }
            if (this == STRING) {
                return String.class;
            }
            return null;
        }

        private Object _getTypedValue(String value) {
            if (this == BOOLEAN) {
                return GetterUtil.getBoolean(value);
            }
            if (this == BYTE) {
                return (byte)new Byte(value);
            }
            if (this == CHARACTER) {
                return Character.valueOf(value.charAt(0));
            }
            if (this == DOUBLE) {
                return GetterUtil.getDouble(value);
            }
            if (this == FLOAT) {
                return Float.valueOf(GetterUtil.getFloat(value));
            }
            if (this == INTEGER) {
                return GetterUtil.getInteger(value);
            }
            if (this == LONG) {
                return GetterUtil.getLong(value);
            }
            if (this == SHORT) {
                return GetterUtil.getShort(value);
            }
            return value;
        }
    }

    public static class Service {
        public static Set<Class<?>> interfaces(Object object) {
            Class<?> clazz = object.getClass();
            OSGiBeanProperties osgiBeanProperties = clazz.getAnnotation(OSGiBeanProperties.class);
            if (osgiBeanProperties == null) {
                return Service._getInterfaceClasses(clazz, new HashSet());
            }
            Class<?>[] serviceClasses = osgiBeanProperties.service();
            if (serviceClasses.length == 0) {
                return Service._getInterfaceClasses(clazz, new HashSet());
            }
            for (Class<?> serviceClazz : serviceClasses) {
                serviceClazz.cast(object);
            }
            return new HashSet(Arrays.asList(osgiBeanProperties.service()));
        }

        private static Set<Class<?>> _getInterfaceClasses(Class<?> clazz, Set<Class<?>> interfaceClasses) {
            if (clazz.isInterface()) {
                interfaceClasses.add(clazz);
            }
            for (Class<?> interfaceClass : clazz.getInterfaces()) {
                Service._getInterfaceClasses(interfaceClass, interfaceClasses);
            }
            if ((clazz = clazz.getSuperclass()) != null) {
                Service._getInterfaceClasses(clazz, interfaceClasses);
            }
            return interfaceClasses;
        }
    }

    public static class Convert {
        public static Map<String, Object> fromObject(Object object) {
            Class<?> clazz = object.getClass();
            OSGiBeanProperties osgiBeanProperties = clazz.getAnnotation(OSGiBeanProperties.class);
            if (osgiBeanProperties == null) {
                return null;
            }
            return Convert.toMap(osgiBeanProperties);
        }

        public static Map<String, Object> toMap(OSGiBeanProperties osgiBeanProperties) {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            for (String property : osgiBeanProperties.property()) {
                String[] parts = property.split("=", 2);
                if (parts.length <= 1) continue;
                String key = parts[0];
                String className = String.class.getSimpleName();
                if (key.indexOf(":") != -1) {
                    String[] keyParts = StringUtil.split(key, ":");
                    key = keyParts[0];
                    className = keyParts[1];
                }
                String value = parts[1];
                Convert._put(key, value, className, properties);
            }
            String portalPropertyPrefix = osgiBeanProperties.portalPropertyPrefix();
            if (Validator.isNotNull(portalPropertyPrefix)) {
                Properties portalProperties = PropsUtil.getProperties(portalPropertyPrefix, osgiBeanProperties.portalPropertiesRemovePrefix());
                properties.putAll(PropertiesUtil.toMap(portalProperties));
            }
            return properties;
        }

        private static void _put(String key, String value, String className, Map<String, Object> properties) {
            Type type = Type._getType(className);
            Object previousValue = properties.get(key);
            properties.put(key, type._convert(value, previousValue));
        }
    }
}

