/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.backgroundtask;

import com.liferay.portal.kernel.backgroundtask.BackgroundTask;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskResult;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskThreadLocalManager;
import com.liferay.portal.kernel.backgroundtask.DelegatingBackgroundTaskExecutor;
import java.io.Serializable;
import java.util.Map;

public class ThreadLocalAwareBackgroundTaskExecutor
extends DelegatingBackgroundTaskExecutor {
    private final BackgroundTaskThreadLocalManager _backgroundTaskThreadLocalManager;

    public ThreadLocalAwareBackgroundTaskExecutor(BackgroundTaskExecutor backgroundTaskExecutor, BackgroundTaskThreadLocalManager backgroundTaskThreadLocalManager) {
        super(backgroundTaskExecutor);
        this._backgroundTaskThreadLocalManager = backgroundTaskThreadLocalManager;
    }

    @Override
    public BackgroundTaskExecutor clone() {
        ThreadLocalAwareBackgroundTaskExecutor backgroundTaskExecutor = new ThreadLocalAwareBackgroundTaskExecutor(this.getBackgroundTaskExecutor(), this._backgroundTaskThreadLocalManager);
        return backgroundTaskExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackgroundTaskResult execute(BackgroundTask backgroundTask) throws Exception {
        Map<String, Serializable> threadLocalValues = this._backgroundTaskThreadLocalManager.getThreadLocalValues();
        try {
            this._backgroundTaskThreadLocalManager.deserializeThreadLocals(backgroundTask.getTaskContextMap());
            BackgroundTaskResult backgroundTaskResult = super.execute(backgroundTask);
            return backgroundTaskResult;
        }
        finally {
            this._backgroundTaskThreadLocalManager.setThreadLocalValues(threadLocalValues);
        }
    }
}

