/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.display.context;

import com.liferay.portal.kernel.display.context.DisplayContextFactory;
import com.liferay.portal.kernel.display.context.DisplayContextFactoryReference;
import com.liferay.portal.kernel.display.context.DisplayContextProvider;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class BaseDisplayContextProvider<T extends DisplayContextFactory>
implements DisplayContextProvider {
    private final SortedSet<DisplayContextFactoryReference<T>> _displayContextFactoryReferences = new ConcurrentSkipListSet<DisplayContextFactoryReference<T>>();
    private final ConcurrentMap<T, DisplayContextFactoryReference<T>> _displayContextFactoryReferencesMap = new ConcurrentHashMap<T, DisplayContextFactoryReference<T>>();
    private final ServiceTracker<T, T> _serviceTracker;

    public BaseDisplayContextProvider(Class<T> displayContextFactoryClass) {
        Registry registry = RegistryUtil.getRegistry();
        Filter filter = registry.getFilter("(objectClass=" + displayContextFactoryClass.getName() + ")");
        this._serviceTracker = registry.trackServices(filter, (ServiceTrackerCustomizer)new DisplayContextFactoryServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    public void destroy() {
        this._serviceTracker.close();
    }

    public Iterable<T> getDisplayContextFactories() {
        return new DisplayContextFactoriesIterable<T>(this._displayContextFactoryReferences);
    }

    private class DisplayContextFactoryServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<T, T> {
        private DisplayContextFactoryServiceTrackerCustomizer() {
        }

        public T addingService(ServiceReference<T> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            DisplayContextFactory displayContextFactory = (DisplayContextFactory)registry.getService(serviceReference);
            DisplayContextFactoryReference<DisplayContextFactory> displayContextFactoryReference = new DisplayContextFactoryReference<DisplayContextFactory>(displayContextFactory, serviceReference);
            BaseDisplayContextProvider.this._displayContextFactoryReferences.add(displayContextFactoryReference);
            BaseDisplayContextProvider.this._displayContextFactoryReferencesMap.put(displayContextFactory, displayContextFactoryReference);
            return displayContextFactory;
        }

        public void modifiedService(ServiceReference<T> serviceReference, T displayContextFactory) {
            DisplayContextFactoryReference displayContextFactoryReference = (DisplayContextFactoryReference)BaseDisplayContextProvider.this._displayContextFactoryReferencesMap.get(displayContextFactory);
            this.removedService((ServiceReference<T>)displayContextFactoryReference.getServiceReference(), (T)displayContextFactoryReference.getDisplayContextFactory());
            this.addingService(serviceReference);
        }

        public void removedService(ServiceReference<T> serviceReference, T displayContextFactory) {
            DisplayContextFactoryReference displayContextFactoryReference = (DisplayContextFactoryReference)BaseDisplayContextProvider.this._displayContextFactoryReferencesMap.remove(displayContextFactory);
            BaseDisplayContextProvider.this._displayContextFactoryReferences.remove(displayContextFactoryReference);
        }
    }

    private static class DisplayContextFactoriesIterable<T extends DisplayContextFactory>
    implements Iterable<T>,
    Iterator<T> {
        private final Iterator<DisplayContextFactoryReference<T>> _iterator;

        public DisplayContextFactoriesIterable(Iterable<DisplayContextFactoryReference<T>> iterable) {
            this._iterator = iterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._iterator.hasNext();
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public T next() {
            DisplayContextFactoryReference<T> displayContextFactoryReference = this._iterator.next();
            return displayContextFactoryReference.getDisplayContextFactory();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator is read-only");
        }
    }
}

