/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.BNDSourceUtil;

public class BNDWebContextPathCheck
extends BaseFileCheck {
    @Override
    public boolean isModulesCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.endsWith("/bnd.bnd") && !absolutePath.contains("/testIntegration/") && !absolutePath.contains("/third-party/")) {
            this._checkWebContextPath(fileName, absolutePath, content);
        }
        return content;
    }

    private void _checkWebContextPath(String fileName, String absolutePath, String content) {
        String moduleName = BNDSourceUtil.getModuleName(absolutePath);
        if (moduleName.contains("-import-") || moduleName.contains("-private-")) {
            return;
        }
        String webContextPath = BNDSourceUtil.getDefinitionValue(content, "Web-ContextPath");
        if (webContextPath != null && !webContextPath.equals("/" + moduleName)) {
            this.addMessage(fileName, "Incorrect Web-ContextPath '" + webContextPath + "'");
        }
    }
}

