/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaDeserializationSecurityCheck
extends BaseFileCheck {
    private static final String _SECURE_DESERIALIZATION_EXCLUDES = "secure.deserialization.excludes";
    private final Pattern[] _javaSerializationVulnerabilityPatterns = new Pattern[]{Pattern.compile(".*(new [a-z\\.\\s]*ObjectInputStream).*", 32), Pattern.compile(".*(extends [a-z\\.\\s]*ObjectInputStream).*", 32)};

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (fileName.contains("/test/") || fileName.contains("/testIntegration/") || this.isExcludedPath(_SECURE_DESERIALIZATION_EXCLUDES, absolutePath)) {
            return content;
        }
        this._checkDeserializationSecurity(fileName, content, absolutePath);
        return content;
    }

    private void _checkDeserializationSecurity(String fileName, String content, String absolutePath) {
        for (Pattern vulnerabilityPattern : this._javaSerializationVulnerabilityPatterns) {
            Matcher matcher = vulnerabilityPattern.matcher(content);
            if (!matcher.matches()) continue;
            StringBundler sb = new StringBundler(3);
            if (this.isExcludedPath("run.outside.portal.excludes", absolutePath)) {
                sb.append("Possible Java Serialization Remote Code Execution ");
                sb.append("vulnerability using ");
            } else {
                sb.append("Use ProtectedObjectInputStream instead of ");
            }
            sb.append(matcher.group(1));
            this.addMessage(fileName, sb.toString());
        }
    }
}

