/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseJavaTermCheck;
import com.liferay.source.formatter.parser.JavaClass;
import com.liferay.source.formatter.parser.JavaTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaTestMethodAnnotationsCheck
extends BaseJavaTermCheck {
    private static final String _TEST_ANNOTATIONS_EXCLUDES = "test.annotations.excludes";

    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, JavaTerm javaTerm, String fileContent) {
        if (!fileName.endsWith("Test.java") || this.isExcludedPath(_TEST_ANNOTATIONS_EXCLUDES, absolutePath)) {
            return javaTerm.getContent();
        }
        String accessModifier = javaTerm.getAccessModifier();
        if (!accessModifier.equals("public")) {
            return javaTerm.getContent();
        }
        JavaClass parentJavaClass = javaTerm.getParentJavaClass();
        if (parentJavaClass.getParentJavaClass() != null) {
            return javaTerm.getContent();
        }
        this._checkAnnotationForMethod(fileName, javaTerm, "After", "\\btearDown(?!Class)", false);
        this._checkAnnotationForMethod(fileName, javaTerm, "AfterClass", "\\btearDownClass", true);
        this._checkAnnotationForMethod(fileName, javaTerm, "Before", "\\bsetUp(?!Class)", false);
        this._checkAnnotationForMethod(fileName, javaTerm, "BeforeClass", "\\bsetUpClass", true);
        this._checkAnnotationForMethod(fileName, javaTerm, "Test", "^.*test", false);
        return javaTerm.getContent();
    }

    @Override
    protected String[] getCheckableJavaTermNames() {
        return new String[]{JAVA_METHOD};
    }

    private void _checkAnnotationForMethod(String fileName, JavaTerm javaTerm, String annotation, String requiredMethodNameRegex, boolean staticRequired) {
        String methodName = javaTerm.getName();
        Pattern pattern = Pattern.compile(requiredMethodNameRegex);
        Matcher matcher = pattern.matcher(methodName);
        if (javaTerm.hasAnnotation(annotation)) {
            if (!matcher.find()) {
                this.addMessage(fileName, "Incorrect method name '" + methodName + "', see LPS-36303");
            } else if (javaTerm.isStatic() != staticRequired) {
                this.addMessage(fileName, "Incorrect method type for '" + methodName + "', see LPS-36303");
            }
        } else if (matcher.find() && !javaTerm.hasAnnotation("Override")) {
            this.addMessage(fileName, "Annotation @" + annotation + " required for '" + methodName + "', see LPS-36303");
        }
    }
}

