/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

public class JavaVerifyUpgradeConnectionCheck
extends BaseFileCheck {
    private static final String _UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES = "upgrade.data.access.connection.excludes";

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        if (this.isExcludedPath(_UPGRADE_DATA_ACCESS_CONNECTION_EXCLUDES, absolutePath) || fileName.endsWith("Test.java") || fileName.endsWith("UpgradeTableListener.java") || content.contains("ThrowableAwareRunnable")) {
            return content;
        }
        String className = JavaSourceUtil.getClassName(fileName);
        if (!className.contains("Upgrade") && !className.contains("Verify")) {
            return content;
        }
        int x = -1;
        while ((x = content.indexOf("DataAccess.getUpgradeOptimizedConnection", x + 1)) != -1) {
            this.addMessage(fileName, "Use existing connection field instead of DataAccess.getUpgradeOptimizedConnection", this.getLineCount(content, x));
        }
        return content;
    }
}

