/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import com.liferay.source.formatter.checkstyle.checks.SinceJava;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.liferay.source.formatter.util.ThreadSafeClassLibrary;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.ClassLibrary;
import com.thoughtworks.qdox.model.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.DocletTagFactory;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.annotation.AnnotationValue;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MissingOverrideCheck
extends AbstractCheck {
    public static final String MSG_MISSING_OVERRIDE = "override.missing";
    private static final String[] _EXCLUDES = new String[]{"**/.git/**", "**/.gradle/**", "**/bin/**", "**/build/**", "**/classes/**", "**/node_modules/**", "**/npm-shrinkwrap.json", "**/test-classes/**", "**/test-coverage/**", "**/test-results/**", "**/tmp/**"};
    private static final double _LOWEST_SUPPORTED_JAVA_VERSION = 1.7;
    private JavaDocBuilder _javaDocBuilder;

    public int[] getDefaultTokens() {
        return new int[]{16};
    }

    public void visitToken(DetailAST detailAST) {
        FileContents fileContents = this.getFileContents();
        String fileName = StringUtil.replace(fileContents.getFileName(), '\\', '/');
        JavaDocBuilder javaDocBuilder = null;
        try {
            javaDocBuilder = this._getJavaDocBuilder(fileName);
        }
        catch (Exception e) {
            return;
        }
        if (javaDocBuilder == null) {
            return;
        }
        JavaClass javaClass = javaDocBuilder.getClassByName(this._getPackagePath(detailAST) + "." + this._getClassName(fileName));
        List<Tuple> ancestorJavaClassTuples = this._addAncestorJavaClassTuples(javaClass, fileName, javaDocBuilder, new ArrayList<Tuple>());
        for (JavaMethod javaMethod : javaClass.getMethods()) {
            if (javaMethod.getLineNumber() == 0 || this._hasAnnotation((AbstractBaseJavaEntity)javaMethod, "Override") || !this._isOverrideMethod(javaClass, javaMethod, ancestorJavaClassTuples)) continue;
            this.log(javaMethod.getLineNumber(), MSG_MISSING_OVERRIDE, new Object[0]);
        }
    }

    private List<Tuple> _addAncestorJavaClassTuples(JavaClass javaClass, String fileName, JavaDocBuilder javaDocBuilder, List<Tuple> ancestorJavaClassTuples) {
        Type[] implementz;
        JavaClass superJavaClass = this._fixJavaClass(javaClass.getSuperJavaClass(), javaClass.getPackageName(), fileName, javaDocBuilder);
        if (superJavaClass != null) {
            ancestorJavaClassTuples.add(new Tuple(superJavaClass));
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(superJavaClass, null, javaDocBuilder, ancestorJavaClassTuples);
        }
        for (Type implement : implementz = javaClass.getImplements()) {
            Type[] actualTypeArguments = implement.getActualTypeArguments();
            JavaClass implementedInterface = this._fixJavaClass(implement.getJavaClass(), javaClass.getPackageName(), fileName, javaDocBuilder);
            if (actualTypeArguments == null) {
                ancestorJavaClassTuples.add(new Tuple(implementedInterface));
            } else {
                ancestorJavaClassTuples.add(new Tuple(implementedInterface, actualTypeArguments));
            }
            ancestorJavaClassTuples = this._addAncestorJavaClassTuples(implementedInterface, null, javaDocBuilder, ancestorJavaClassTuples);
        }
        return ancestorJavaClassTuples;
    }

    private JavaClass _fixJavaClass(JavaClass javaClass, String packageName, String fileName, JavaDocBuilder javaDocBuilder) {
        if (javaClass == null || fileName == null) {
            return javaClass;
        }
        String fullyQualifiedName = javaClass.getFullyQualifiedName();
        if (fullyQualifiedName.contains(".")) {
            return javaClass;
        }
        int pos = fileName.lastIndexOf("/");
        File file = new File(fileName.substring(0, pos + 1) + fullyQualifiedName + ".java");
        try {
            javaDocBuilder.addSource(file);
        }
        catch (Exception e) {
            return javaClass;
        }
        return javaDocBuilder.getClassByName(packageName + "." + fullyQualifiedName);
    }

    private String _getClassName(String fileName) {
        int pos = fileName.lastIndexOf(47);
        return fileName.substring(pos + 1, fileName.length() - 5);
    }

    private JavaDocBuilder _getJavaDocBuilder(String fileName) throws Exception {
        int x;
        File file;
        if (this._javaDocBuilder != null) {
            return this._javaDocBuilder;
        }
        JavaDocBuilder javaDocBuilder = new JavaDocBuilder((DocletTagFactory)new DefaultDocletTagFactory(), (ClassLibrary)new ThreadSafeClassLibrary());
        String absolutePath = JavaSourceUtil.getAbsolutePath(fileName);
        do {
            if ((x = absolutePath.lastIndexOf("/")) != -1) continue;
            return null;
        } while (!(file = new File((absolutePath = absolutePath.substring(0, x)) + "/portal-impl")).exists());
        List<String> fileNames = SourceFormatterUtil.scanForFiles(absolutePath + "/", _EXCLUDES, new String[]{"**/*.java"}, true);
        for (String curFileName : fileNames) {
            curFileName = StringUtil.replace(curFileName, '\\', '/');
            try {
                javaDocBuilder.addSource(new File(JavaSourceUtil.getAbsolutePath(curFileName)));
            }
            catch (Exception exception) {}
        }
        this._javaDocBuilder = javaDocBuilder;
        return this._javaDocBuilder;
    }

    private String _getPackagePath(DetailAST packageDefAST) {
        DetailAST dotAST = packageDefAST.findFirstToken(59);
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotAST);
        return fullIdent.getText();
    }

    private boolean _hasAnnotation(AbstractBaseJavaEntity abstractBaseJavaEntity, String annotationName) {
        Annotation[] annotations = abstractBaseJavaEntity.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (int i = 0; i < annotations.length; ++i) {
            Type type = annotations[i].getType();
            JavaClass javaClass = type.getJavaClass();
            if (!annotationName.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean _isOverrideMethod(JavaClass javaClass, JavaMethod javaMethod, Collection<Tuple> ancestorJavaClassTuples) {
        if (javaMethod.isConstructor() || javaMethod.isPrivate() || javaMethod.isStatic() || this._overridesHigherJavaAPIVersion(javaMethod)) {
            return false;
        }
        String methodName = javaMethod.getName();
        JavaParameter[] javaParameters = javaMethod.getParameters();
        Type[] types = new Type[javaParameters.length];
        for (int i = 0; i < javaParameters.length; ++i) {
            types[i] = javaParameters[i].getType();
        }
        for (Tuple ancestorJavaClassTuple : ancestorJavaClassTuples) {
            JavaClass ancestorJavaClass = (JavaClass)ancestorJavaClassTuple.getObject(0);
            JavaMethod ancestorJavaMethod = null;
            String ancestorJavaClassName = ancestorJavaClass.getFullyQualifiedName();
            if (ancestorJavaClassTuple.getSize() == 1 || ancestorJavaClassName.equals("java.util.Map") && methodName.equals("get")) {
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, types);
            } else {
                Type[] ancestorActualTypeArguments = (Type[])ancestorJavaClassTuple.getObject(1);
                Type[] genericTypes = new Type[types.length];
                for (int i = 0; i < types.length; ++i) {
                    Type type = types[i];
                    String typeValue = type.getValue();
                    boolean useGenericType = false;
                    for (int j = 0; j < ancestorActualTypeArguments.length; ++j) {
                        if (!typeValue.equals(ancestorActualTypeArguments[j].getValue())) continue;
                        useGenericType = true;
                        break;
                    }
                    genericTypes[i] = useGenericType ? new Type("java.lang.Object") : type;
                }
                ancestorJavaMethod = ancestorJavaClass.getMethodBySignature(methodName, genericTypes);
            }
            if (ancestorJavaMethod == null) continue;
            boolean samePackage = false;
            JavaPackage ancestorJavaPackage = ancestorJavaClass.getPackage();
            if (ancestorJavaPackage != null) {
                samePackage = ancestorJavaPackage.equals((Object)javaClass.getPackage());
            }
            if (samePackage) {
                return !ancestorJavaMethod.isPrivate();
            }
            return ancestorJavaMethod.isProtected() || ancestorJavaMethod.isPublic();
        }
        return false;
    }

    private boolean _overridesHigherJavaAPIVersion(JavaMethod javaMethod) {
        Annotation[] annotations = javaMethod.getAnnotations();
        if (annotations == null) {
            return false;
        }
        for (Annotation annotation : annotations) {
            AnnotationValue annotationValue;
            double sinceJava;
            Type type = annotation.getType();
            JavaClass javaClass = type.getJavaClass();
            String javaClassName = javaClass.getFullyQualifiedName();
            if (!javaClassName.equals(SinceJava.class.getName()) || !((sinceJava = GetterUtil.getDouble((annotationValue = annotation.getProperty("value")).getParameterValue())) > 1.7)) continue;
            return true;
        }
        return false;
    }
}

