/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.thread.local;

import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCachable;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import org.aopalliance.intercept.MethodInvocation;

public class ThreadLocalCacheAdvice
extends AnnotationChainableMethodAdvice<ThreadLocalCachable> {
    private static final ThreadLocalCachable _nullThreadLocalCacheable = new ThreadLocalCachable(){

        public Class<? extends Annotation> annotationType() {
            return ThreadLocalCachable.class;
        }

        public Lifecycle scope() {
            return null;
        }
    };

    @Override
    public ThreadLocalCachable getNullAnnotation() {
        return _nullThreadLocalCacheable;
    }

    @Override
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        String cacheKey;
        ThreadLocalCachable threadLocalCachable = (ThreadLocalCachable)this.findAnnotation(methodInvocation);
        if (threadLocalCachable == _nullThreadLocalCacheable) {
            return methodInvocation.proceed();
        }
        ThreadLocalCache threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache((Lifecycle)threadLocalCachable.scope(), (Object)methodInvocation.getMethod());
        Object value = threadLocalCache.get(cacheKey = this._getCacheKey(methodInvocation.getArguments()));
        if (value != null) {
            if (value == this.nullResult) {
                return null;
            }
            return value;
        }
        Object result = methodInvocation.proceed();
        if (result == null) {
            threadLocalCache.put(cacheKey, this.nullResult);
        } else {
            threadLocalCache.put(cacheKey, result);
        }
        return result;
    }

    private String _getCacheKey(Object[] arguments) {
        if (arguments.length == 1) {
            return StringUtil.toHexString((Object)arguments[0]);
        }
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        for (int i = 0; i < arguments.length; ++i) {
            sb.append(StringUtil.toHexString((Object)arguments[i]));
            if (i + 1 >= arguments.length) continue;
            sb.append("#");
        }
        return sb.toString();
    }
}

