/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.comment.display.context;

import com.liferay.portal.comment.display.context.BaseCommentDisplayContext;
import com.liferay.portal.comment.display.context.util.DiscussionRequestHelper;
import com.liferay.portal.comment.display.context.util.DiscussionTaglibHelper;
import com.liferay.portal.kernel.comment.CommentConstants;
import com.liferay.portal.kernel.comment.DiscussionComment;
import com.liferay.portal.kernel.comment.DiscussionPermission;
import com.liferay.portal.kernel.comment.WorkflowableComment;
import com.liferay.portal.kernel.comment.display.context.CommentTreeDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.trash.kernel.util.TrashUtil;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class DefaultCommentTreeDisplayContext
extends BaseCommentDisplayContext
implements CommentTreeDisplayContext {
    private final DiscussionComment _discussionComment;
    private final DiscussionPermission _discussionPermission;
    private final DiscussionRequestHelper _discussionRequestHelper;
    private final DiscussionTaglibHelper _discussionTaglibHelper;

    public DefaultCommentTreeDisplayContext(DiscussionRequestHelper discussionRequestHelper, DiscussionTaglibHelper discussionTaglibHelper, DiscussionPermission discussionPermission, DiscussionComment discussionComment) {
        this._discussionRequestHelper = discussionRequestHelper;
        this._discussionTaglibHelper = discussionTaglibHelper;
        this._discussionPermission = discussionPermission;
        this._discussionComment = discussionComment;
    }

    public String getPublishButtonLabel(Locale locale) {
        String publishButtonLabel = LanguageUtil.get((HttpServletRequest)this._discussionRequestHelper.getRequest(), (String)"publish");
        if (WorkflowDefinitionLinkLocalServiceUtil.hasWorkflowDefinitionLink((long)this._discussionRequestHelper.getCompanyId(), (long)this._discussionRequestHelper.getScopeGroupId(), (String)CommentConstants.getDiscussionClassName())) {
            publishButtonLabel = this.isCommentPending() ? "save" : LanguageUtil.get((HttpServletRequest)this._discussionRequestHelper.getRequest(), (String)"submit-for-publication");
        }
        return publishButtonLabel;
    }

    public boolean isActionControlsVisible() throws PortalException {
        if (this._discussionComment == null || this._discussionTaglibHelper.isHideControls()) {
            return false;
        }
        return !this._discussionComment.isInTrash();
    }

    public boolean isDeleteActionControlVisible() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasDeletePermission(this._discussionComment.getCommentId());
    }

    public boolean isDiscussionVisible() throws PortalException {
        if (!(this.isCommentApproved() || this.isCommentAuthor() || this.isGroupAdmin())) {
            return false;
        }
        return this.hasViewPermission();
    }

    public boolean isEditActionControlVisible() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasUpdatePermission(this._discussionComment.getCommentId());
    }

    public boolean isEditControlsVisible() throws PortalException {
        if (this._discussionTaglibHelper.isHideControls()) {
            return false;
        }
        return this.hasUpdatePermission();
    }

    public boolean isRatingsVisible() throws PortalException {
        if (this._discussionComment == null || !this._discussionTaglibHelper.isRatingsEnabled()) {
            return false;
        }
        return !TrashUtil.isInTrash((String)this._discussionComment.getModelClassName(), (long)this._discussionComment.getCommentId());
    }

    public boolean isReplyActionControlVisible() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasAddPermission(this._discussionRequestHelper.getCompanyId(), this._discussionRequestHelper.getScopeGroupId(), this._discussionTaglibHelper.getClassName(), this._discussionTaglibHelper.getClassPK());
    }

    public boolean isWorkflowStatusVisible() {
        return this._discussionComment != null && !this.isCommentApproved();
    }

    @Override
    protected ThemeDisplay getThemeDisplay() {
        return this._discussionRequestHelper.getThemeDisplay();
    }

    protected User getUser() {
        ThemeDisplay themeDisplay = this._discussionRequestHelper.getThemeDisplay();
        return themeDisplay.getUser();
    }

    protected boolean hasUpdatePermission() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasUpdatePermission(this._discussionComment.getCommentId());
    }

    protected boolean hasViewPermission() throws PortalException {
        if (this._discussionPermission == null) {
            return false;
        }
        return this._discussionPermission.hasViewPermission(this._discussionRequestHelper.getCompanyId(), this._discussionRequestHelper.getScopeGroupId(), this._discussionTaglibHelper.getClassName(), this._discussionTaglibHelper.getClassPK());
    }

    protected boolean isCommentApproved() {
        boolean approved = true;
        if (this._discussionComment instanceof WorkflowableComment) {
            WorkflowableComment workflowableComment = (WorkflowableComment)this._discussionComment;
            approved = workflowableComment.getStatus() == 0;
        }
        return approved;
    }

    protected boolean isCommentAuthor() {
        User user = this.getUser();
        return this._discussionComment != null && this._discussionComment.getUserId() == user.getUserId() && !user.isDefaultUser();
    }

    protected boolean isCommentPending() {
        boolean pending = false;
        if (this._discussionComment instanceof WorkflowableComment) {
            WorkflowableComment workflowableComment = (WorkflowableComment)this._discussionComment;
            pending = workflowableComment.getStatus() == 1;
        }
        return pending;
    }

    protected boolean isGroupAdmin() {
        PermissionChecker permissionChecker = this._discussionRequestHelper.getPermissionChecker();
        return permissionChecker.isGroupAdmin(this._discussionRequestHelper.getScopeGroupId());
    }
}

