/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryChecker;
import com.liferay.portal.repository.capabilities.util.RepositoryEntryConverter;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;

public class LiferayThumbnailCapability
implements ThumbnailCapability {
    private final RepositoryEntryChecker _repositoryEntryChecker;
    private final RepositoryEntryConverter _repositoryEntryConverter;

    public LiferayThumbnailCapability(RepositoryEntryConverter repositoryEntryConverter, RepositoryEntryChecker repositoryEntryChecker) {
        this._repositoryEntryConverter = repositoryEntryConverter;
        this._repositoryEntryChecker = repositoryEntryChecker;
    }

    public FileEntry fetchImageFileEntry(long imageId) {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByAnyImageId((long)imageId);
        if (dlFileEntry == null) {
            return null;
        }
        this._repositoryEntryChecker.checkDLFileEntry(dlFileEntry);
        return new LiferayFileEntry(dlFileEntry);
    }

    public long getCustom1ImageId(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry);
        return dlFileEntry.getCustom1ImageId();
    }

    public long getCustom2ImageId(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry);
        return dlFileEntry.getCustom2ImageId();
    }

    public long getLargeImageId(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry);
        return dlFileEntry.getLargeImageId();
    }

    public long getSmallImageId(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry);
        return dlFileEntry.getSmallImageId();
    }

    public FileEntry setCustom1ImageId(FileEntry fileEntry, long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry.getFileEntryId());
        dlFileEntry.setCustom1ImageId(imageId);
        return this.updateDLFileEntry(dlFileEntry);
    }

    public FileEntry setCustom2ImageId(FileEntry fileEntry, long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry.getFileEntryId());
        dlFileEntry.setCustom2ImageId(imageId);
        return this.updateDLFileEntry(dlFileEntry);
    }

    public FileEntry setLargeImageId(FileEntry fileEntry, long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry.getFileEntryId());
        dlFileEntry.setLargeImageId(imageId);
        return this.updateDLFileEntry(dlFileEntry);
    }

    public FileEntry setSmallImageId(FileEntry fileEntry, long imageId) throws PortalException {
        DLFileEntry dlFileEntry = this.getDLFileEntry(fileEntry.getFileEntryId());
        dlFileEntry.setSmallImageId(imageId);
        return this.updateDLFileEntry(dlFileEntry);
    }

    protected DLFileEntry getDLFileEntry(FileEntry fileEntry) {
        this._repositoryEntryChecker.checkFileEntry(fileEntry);
        return this._repositoryEntryConverter.getDLFileEntry(fileEntry);
    }

    protected DLFileEntry getDLFileEntry(long fileEntryId) throws PortalException {
        DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.getDLFileEntry((long)fileEntryId);
        this._repositoryEntryChecker.checkDLFileEntry(dlFileEntry);
        return dlFileEntry;
    }

    protected FileEntry updateDLFileEntry(DLFileEntry dlFileEntry) {
        return new LiferayFileEntry(DLFileEntryLocalServiceUtil.updateDLFileEntry((DLFileEntry)dlFileEntry));
    }
}

