/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.liferayrepository;

import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.capabilities.WorkflowSupport;
import com.liferay.portal.repository.util.RepositoryWrapper;
import java.io.File;
import java.io.InputStream;

public class LiferayWorkflowRepositoryWrapper
extends RepositoryWrapper {
    private final WorkflowSupport _workflowSupport;

    public LiferayWorkflowRepositoryWrapper(Repository repository, WorkflowSupport workflowSupport) {
        super(repository);
        this._workflowSupport = workflowSupport;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (long[])serviceContext.getAssetCategoryIds(), (String[])serviceContext.getAssetTagNames(), (long[])serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (long[])serviceContext.getAssetCategoryIds(), (String[])serviceContext.getAssetTagNames(), (long[])serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, majorVersion, changeLog, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.checkInFileEntry(userId, fileEntry, majorVersion, serviceContext);
    }

    @Override
    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        super.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.checkInFileEntry(userId, fileEntry, false, serviceContext);
    }

    @Override
    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
        DLAppHelperLocalServiceUtil.updateAsset((long)userId, (FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), (long[])serviceContext.getAssetCategoryIds(), (String[])serviceContext.getAssetTagNames(), (long[])serviceContext.getAssetLinkEntryIds());
        this._workflowSupport.addFileEntry(userId, fileEntry, serviceContext);
        return fileEntry;
    }

    @Override
    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        super.revertFileEntry(userId, fileEntryId, version, serviceContext);
        FileEntry fileEntry = super.getFileEntry(fileEntryId);
        this._workflowSupport.revertFileEntry(userId, fileEntry, serviceContext);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, file, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, majorVersion, serviceContext);
        return super.getFileEntry(fileEntryId);
    }

    @Override
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        FileEntry fileEntry = super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, majorVersion, is, size, serviceContext);
        this._workflowSupport.updateFileEntry(userId, fileEntry, majorVersion, serviceContext);
        return super.getFileEntry(fileEntryId);
    }
}

