/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.auth.session;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserTracker;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.AuthenticatedUserUUIDStoreUtil;
import com.liferay.portal.kernel.security.auth.session.AuthenticatedSessionManager;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.liveusers.LiveUsers;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.security.Key;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@DoPrivileged
public class AuthenticatedSessionManagerImpl
implements AuthenticatedSessionManager {
    private static final Log _log = LogFactoryUtil.getLog(AuthenticatedSessionManagerImpl.class);

    public long getAuthenticatedUserId(HttpServletRequest request, String login, String password, String authType) throws PortalException {
        User user = this._getAuthenticatedUser(request, login, password, authType);
        return user.getUserId();
    }

    public void login(HttpServletRequest request, HttpServletResponse response, String login, String password, boolean rememberMe, String authType) throws Exception {
        Boolean httpsInitial;
        String domain;
        String queryString = (request = PortalUtil.getOriginalServletRequest((HttpServletRequest)request)).getQueryString();
        if (queryString.contains("password=")) {
            int index;
            String passwordParameterName = "password=";
            String portletId = PortalUtil.getPortletId((HttpServletRequest)request);
            if (portletId != null) {
                passwordParameterName = PortalUtil.getPortletNamespace((String)portletId) + passwordParameterName;
            }
            if ((index = queryString.indexOf(passwordParameterName)) == 0 || index > 0 && queryString.charAt(index - 1) == '&') {
                if (_log.isWarnEnabled()) {
                    String referer = request.getHeader("Referer");
                    StringBundler sb = new StringBundler(4);
                    sb.append("Ignoring login attempt because the password ");
                    sb.append("parameter was found for the request with the ");
                    sb.append("referer header: ");
                    sb.append(referer);
                    _log.warn((Object)sb.toString());
                }
                return;
            }
        }
        CookieKeys.validateSupportCookie((HttpServletRequest)request);
        HttpSession session = request.getSession();
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        User user = this._getAuthenticatedUser(request, login, password, authType);
        if (!PropsValues.AUTH_SIMULTANEOUS_LOGINS) {
            this.signOutSimultaneousLogins(user.getUserId());
        }
        if (PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            session = this.renewSession(request, session);
        }
        if (Validator.isNull((String)(domain = CookieKeys.getDomain((HttpServletRequest)request)))) {
            domain = null;
        }
        String userIdString = String.valueOf(user.getUserId());
        session.setAttribute("j_username", (Object)userIdString);
        if (PropsValues.PORTAL_JAAS_PLAIN_PASSWORD) {
            session.setAttribute("j_password", (Object)password);
        } else {
            session.setAttribute("j_password", (Object)user.getPassword());
        }
        session.setAttribute("j_remoteuser", (Object)userIdString);
        if (PropsValues.SESSION_STORE_PASSWORD) {
            session.setAttribute("USER_PASSWORD", (Object)password);
        }
        Cookie companyIdCookie = new Cookie("COMPANY_ID", String.valueOf(company.getCompanyId()));
        if (domain != null) {
            companyIdCookie.setDomain(domain);
        }
        companyIdCookie.setPath("/");
        Cookie idCookie = new Cookie("ID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userIdString));
        if (domain != null) {
            idCookie.setDomain(domain);
        }
        idCookie.setPath("/");
        int loginMaxAge = PropsValues.COMPANY_SECURITY_AUTO_LOGIN_MAX_AGE;
        if (PropsValues.SESSION_DISABLED) {
            rememberMe = true;
        }
        if (rememberMe) {
            companyIdCookie.setMaxAge(loginMaxAge);
            idCookie.setMaxAge(loginMaxAge);
        } else {
            companyIdCookie.setMaxAge(-1);
            idCookie.setMaxAge(-1);
        }
        boolean secure = request.isSecure();
        if (!(!secure || PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || StringUtil.equalsIgnoreCase((String)"https", (String)PropsValues.WEB_SERVER_PROTOCOL) || (httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL")) != null && httpsInitial.booleanValue())) {
            secure = false;
        }
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)companyIdCookie, (boolean)secure);
        CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)idCookie, (boolean)secure);
        if (rememberMe) {
            Cookie loginCookie = new Cookie("LOGIN", login);
            if (domain != null) {
                loginCookie.setDomain(domain);
            }
            loginCookie.setMaxAge(loginMaxAge);
            loginCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)loginCookie, (boolean)secure);
            Cookie passwordCookie = new Cookie("PASSWORD", Encryptor.encrypt((Key)company.getKeyObj(), (String)password));
            if (domain != null) {
                passwordCookie.setDomain(domain);
            }
            passwordCookie.setMaxAge(loginMaxAge);
            passwordCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)passwordCookie, (boolean)secure);
            Cookie rememberMeCookie = new Cookie("REMEMBER_ME", Boolean.TRUE.toString());
            if (domain != null) {
                rememberMeCookie.setDomain(domain);
            }
            rememberMeCookie.setMaxAge(loginMaxAge);
            rememberMeCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)rememberMeCookie, (boolean)secure);
            Cookie screenNameCookie = new Cookie("SCREEN_NAME", Encryptor.encrypt((Key)company.getKeyObj(), (String)user.getScreenName()));
            if (domain != null) {
                screenNameCookie.setDomain(domain);
            }
            screenNameCookie.setMaxAge(loginMaxAge);
            screenNameCookie.setPath("/");
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)screenNameCookie, (boolean)secure);
        }
        if (PropsValues.AUTH_USER_UUID_STORE_ENABLED) {
            String userUUID = userIdString.concat(".").concat(String.valueOf(System.nanoTime()));
            Cookie userUUIDCookie = new Cookie("USER_UUID", Encryptor.encrypt((Key)company.getKeyObj(), (String)userUUID));
            userUUIDCookie.setPath("/");
            session.setAttribute("USER_UUID", (Object)userUUID);
            if (rememberMe) {
                userUUIDCookie.setMaxAge(loginMaxAge);
            } else {
                userUUIDCookie.setMaxAge(-1);
            }
            CookieKeys.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)userUUIDCookie, (boolean)secure);
            AuthenticatedUserUUIDStoreUtil.register((String)userUUID);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        EventsProcessorUtil.process("logout.events.pre", PropsValues.LOGOUT_EVENTS_PRE, request, response);
        String domain = CookieKeys.getDomain((HttpServletRequest)request);
        if (Validator.isNull((String)domain)) {
            domain = null;
        }
        boolean rememberMe = GetterUtil.getBoolean((String)CookieKeys.getCookie((HttpServletRequest)request, (String)"REMEMBER_ME", (boolean)false));
        CookieKeys.deleteCookies((HttpServletRequest)request, (HttpServletResponse)response, (String)domain, (String[])new String[]{"COMPANY_ID", "GUEST_LANGUAGE_ID", "ID", "PASSWORD", "REMEMBER_ME"});
        if (!rememberMe) {
            CookieKeys.deleteCookies((HttpServletRequest)request, (HttpServletResponse)response, (String)domain, (String[])new String[]{"LOGIN"});
        }
        try {
            session.invalidate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        EventsProcessorUtil.process("logout.events.post", PropsValues.LOGOUT_EVENTS_POST, request, response);
    }

    public HttpSession renewSession(HttpServletRequest request, HttpSession session) throws Exception {
        Object protectedAttributeValue;
        String[] protectedAttributeNames = PropsValues.SESSION_PHISHING_PROTECTED_ATTRIBUTES;
        HashMap<String, Object> protectedAttributes = new HashMap<String, Object>();
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = session.getAttribute(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            protectedAttributes.put(protectedAttributeName, protectedAttributeValue);
        }
        session.invalidate();
        session = request.getSession(true);
        for (String protectedAttributeName : protectedAttributeNames) {
            protectedAttributeValue = protectedAttributes.get(protectedAttributeName);
            if (protectedAttributeValue == null) continue;
            session.setAttribute(protectedAttributeName, protectedAttributeValue);
        }
        return session;
    }

    public void signOutSimultaneousLogins(long userId) throws Exception {
        long companyId = CompanyLocalServiceUtil.getCompanyIdByUserId((long)userId);
        Map<String, UserTracker> sessionUsers = LiveUsers.getSessionUsers(companyId);
        ArrayList<UserTracker> userTrackers = new ArrayList<UserTracker>(sessionUsers.values());
        for (UserTracker userTracker : userTrackers) {
            if (userId != userTracker.getUserId()) continue;
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            ClusterNode clusterNode = ClusterExecutorUtil.getLocalClusterNode();
            if (clusterNode != null) {
                jsonObject.put("clusterNodeId", clusterNode.getClusterNodeId());
            }
            jsonObject.put("command", "signOut");
            jsonObject.put("companyId", companyId);
            jsonObject.put("sessionId", userTracker.getSessionId());
            jsonObject.put("userId", userId);
            MessageBusUtil.sendMessage((String)"liferay/live_users", (Object)jsonObject.toString());
        }
    }

    private User _getAuthenticatedUser(HttpServletRequest request, String login, String password, String authType) throws PortalException {
        String contextPath;
        long userId = GetterUtil.getLong((String)login);
        Company company = PortalUtil.getCompany((HttpServletRequest)request);
        String requestURI = request.getRequestURI();
        if (requestURI.startsWith((contextPath = PortalUtil.getPathContext()).concat("/api/liferay"))) {
            throw new AuthException();
        }
        HashMap<String, String[]> headerMap = new HashMap<String, String[]>();
        Enumeration enu1 = request.getHeaderNames();
        while (enu1.hasMoreElements()) {
            String name = (String)enu1.nextElement();
            Enumeration enu2 = request.getHeaders(name);
            ArrayList<String> headers = new ArrayList<String>();
            while (enu2.hasMoreElements()) {
                String value = (String)enu2.nextElement();
                headers.add(value);
            }
            headerMap.put(name, headers.toArray(new String[headers.size()]));
        }
        Map parameterMap = request.getParameterMap();
        HashMap resultsMap = new HashMap();
        if (Validator.isNull((String)authType)) {
            authType = company.getAuthType();
        }
        int authResult = -1;
        if (authType.equals("emailAddress")) {
            authResult = UserLocalServiceUtil.authenticateByEmailAddress((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("screenName")) {
            authResult = UserLocalServiceUtil.authenticateByScreenName((long)company.getCompanyId(), (String)login, (String)password, headerMap, (Map)parameterMap, resultsMap);
        } else if (authType.equals("userId")) {
            authResult = UserLocalServiceUtil.authenticateByUserId((long)company.getCompanyId(), (long)userId, (String)password, headerMap, (Map)parameterMap, resultsMap);
        }
        User user = (User)resultsMap.get("user");
        if (authResult != 1) {
            if (user != null) {
                user = UserLocalServiceUtil.fetchUser((long)user.getUserId());
            }
            if (user != null) {
                UserLocalServiceUtil.checkLockout((User)user);
            }
            throw new AuthException();
        }
        return user;
    }
}

