/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.SessionMessages;
import com.liferay.portal.kernel.struts.LastPath;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Deprecated
public class FriendlyURLServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(FriendlyURLServlet.class);
    private String _friendlyURLPathPrefix;
    private int _pathInfoOffset;
    private boolean _private;
    private boolean _user;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._private = GetterUtil.getBoolean((String)servletConfig.getInitParameter("private"));
        String proxyPath = PortalUtil.getPathProxy();
        this._user = GetterUtil.getBoolean((String)servletConfig.getInitParameter("user"));
        this._friendlyURLPathPrefix = this._private ? (this._user ? PortalUtil.getPathFriendlyURLPrivateUser() : PortalUtil.getPathFriendlyURLPrivateGroup()) : PortalUtil.getPathFriendlyURLPublic();
        this._pathInfoOffset = this._friendlyURLPathPrefix.length() - proxyPath.length();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Redirect redirect;
        block11: {
            String pathInfo = this.getPathInfo(request);
            redirect = null;
            try {
                redirect = this.getRedirect(request, pathInfo);
                if (request.getAttribute("LAST_PATH") == null) {
                    request.setAttribute("LAST_PATH", (Object)this.getLastPath(request, pathInfo));
                }
            }
            catch (PortalException pe) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)pe);
                }
                if (!(pe instanceof NoSuchGroupException) && !(pe instanceof NoSuchLayoutException)) break block11;
                PortalUtil.sendError((int)404, (Exception)((Object)pe), (HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
        }
        if (redirect == null) {
            redirect = new Redirect();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Redirect " + redirect.getPath()));
        }
        if (redirect.isValidForward()) {
            ServletContext servletContext = this.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect.getPath());
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
        } else if (redirect.isPermanent()) {
            response.setHeader("Location", redirect.getPath());
            response.setStatus(301);
        } else {
            response.sendRedirect(redirect.getPath());
        }
    }

    @Deprecated
    protected String getFriendlyURL(String pathInfo) {
        String friendlyURL = this._friendlyURLPathPrefix;
        if (Validator.isNotNull((String)pathInfo)) {
            friendlyURL = friendlyURL.concat(pathInfo);
        }
        return friendlyURL;
    }

    protected LastPath getLastPath(HttpServletRequest request, String pathInfo) {
        String lifecycle = ParamUtil.getString((HttpServletRequest)request, (String)"p_p_lifecycle");
        if (lifecycle.equals("1")) {
            return new LastPath(this._friendlyURLPathPrefix, pathInfo);
        }
        return new LastPath(this._friendlyURLPathPrefix, pathInfo, HttpUtil.parameterMapToString((Map)request.getParameterMap()));
    }

    protected String getPathInfo(HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        int pos = requestURI.indexOf(";jsessionid=");
        if (pos == -1) {
            return requestURI.substring(this._pathInfoOffset);
        }
        return requestURI.substring(this._pathInfoOffset, pos);
    }

    protected Redirect getRedirect(HttpServletRequest request, String path) throws PortalException {
        long companyId;
        Group group;
        if (path.length() <= 1) {
            return new Redirect();
        }
        String friendlyURL = path;
        int pos = path.indexOf(47, 1);
        if (pos != -1) {
            friendlyURL = path.substring(0, pos);
        }
        if ((group = GroupLocalServiceUtil.fetchFriendlyURLGroup((long)(companyId = PortalInstances.getCompanyId(request)), (String)friendlyURL)) == null) {
            String screenName = friendlyURL.substring(1);
            if (this._user || !Validator.isNumber((String)screenName)) {
                User user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName);
                if (user != null) {
                    group = user.getGroup();
                } else if (_log.isWarnEnabled()) {
                    _log.warn((Object)("No user exists with friendly URL " + screenName));
                }
            } else {
                long groupId = GetterUtil.getLong((String)screenName);
                group = GroupLocalServiceUtil.fetchGroup((long)groupId);
                if (group == null) {
                    User user;
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("No group exists with friendly URL " + groupId + ". Try fetching by screen name instead."));
                    }
                    if ((user = UserLocalServiceUtil.fetchUserByScreenName((long)companyId, (String)screenName)) != null) {
                        group = user.getGroup();
                    } else if (_log.isWarnEnabled()) {
                        _log.warn((Object)("No user or group exists with friendly URL " + groupId));
                    }
                }
            }
        }
        if (group == null) {
            StringBundler sb = new StringBundler(5);
            sb.append("{companyId=");
            sb.append(companyId);
            sb.append(", friendlyURL=");
            sb.append(friendlyURL);
            sb.append("}");
            throw new NoSuchGroupException(sb.toString());
        }
        friendlyURL = null;
        if (pos != -1 && pos + 1 != path.length()) {
            friendlyURL = path.substring(pos);
        } else {
            request.setAttribute("REDIRECT_TO_DEFAULT_LAYOUT", (Object)Boolean.TRUE);
        }
        HashMap<String, HttpServletRequest> requestContext = new HashMap<String, HttpServletRequest>();
        requestContext.put("request", request);
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = ServiceContextFactory.getInstance((HttpServletRequest)request);
            ServiceContextThreadLocal.pushServiceContext((ServiceContext)serviceContext);
        }
        Map params = request.getParameterMap();
        try {
            LayoutFriendlyURLComposite layoutFriendlyURLComposite = PortalUtil.getLayoutFriendlyURLComposite((long)group.getGroupId(), (boolean)this._private, (String)friendlyURL, (Map)params, requestContext);
            Layout layout = layoutFriendlyURLComposite.getLayout();
            request.setAttribute("LAYOUT", (Object)layout);
            Locale locale = PortalUtil.getLocale((HttpServletRequest)request);
            String layoutFriendlyURLCompositeFriendlyURL = layoutFriendlyURLComposite.getFriendlyURL();
            if (Validator.isNull((String)layoutFriendlyURLCompositeFriendlyURL)) {
                layoutFriendlyURLCompositeFriendlyURL = layout.getFriendlyURL(locale);
            }
            if ((pos = layoutFriendlyURLCompositeFriendlyURL.indexOf("/-/")) != 0) {
                String i18nLanguageId;
                if (pos != -1) {
                    layoutFriendlyURLCompositeFriendlyURL = layoutFriendlyURLCompositeFriendlyURL.substring(0, pos);
                }
                if (Validator.isNotNull((String)(i18nLanguageId = (String)request.getAttribute("I18N_LANGUAGE_ID"))) && !LanguageUtil.isAvailableLocale((long)group.getGroupId(), (String)i18nLanguageId) || !StringUtil.equalsIgnoreCase((String)layoutFriendlyURLCompositeFriendlyURL, (String)layout.getFriendlyURL(locale))) {
                    Locale originalLocale = this.setAlternativeLayoutFriendlyURL(request, layout, layoutFriendlyURLCompositeFriendlyURL);
                    String redirect = PortalUtil.getLocalizedFriendlyURL((HttpServletRequest)request, (Layout)layout, (Locale)locale, (Locale)originalLocale);
                    Boolean forcePermanentRedirect = Boolean.TRUE;
                    if (Validator.isNull((String)i18nLanguageId)) {
                        forcePermanentRedirect = Boolean.FALSE;
                    }
                    return new Redirect(redirect, Boolean.TRUE, forcePermanentRedirect);
                }
            }
        }
        catch (NoSuchLayoutException nsle) {
            List layouts = LayoutLocalServiceUtil.getLayouts((long)group.getGroupId(), (boolean)this._private, (long)0L);
            for (Layout layout : layouts) {
                if (!layout.matches(request, friendlyURL)) continue;
                String redirect = PortalUtil.getLayoutActualURL((Layout)layout, (String)"/c");
                return new Redirect(redirect);
            }
            throw nsle;
        }
        String actualURL = PortalUtil.getActualURL((long)group.getGroupId(), (boolean)this._private, (String)"/c", (String)friendlyURL, (Map)params, requestContext);
        return new Redirect(actualURL);
    }

    @Deprecated
    protected Object[] getRedirect(HttpServletRequest request, String path, String mainPath, Map<String, String[]> params) throws Exception {
        Redirect redirect = this.getRedirect(request, path);
        return new Object[]{redirect.getPath(), redirect.isForce()};
    }

    protected Locale setAlternativeLayoutFriendlyURL(HttpServletRequest request, Layout layout, String friendlyURL) {
        List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid(), (String)friendlyURL, (int)0, (int)1);
        if (layoutFriendlyURLs.isEmpty()) {
            return null;
        }
        LayoutFriendlyURL layoutFriendlyURL = (LayoutFriendlyURL)layoutFriendlyURLs.get(0);
        Locale locale = LocaleUtil.fromLanguageId((String)layoutFriendlyURL.getLanguageId());
        String alternativeLayoutFriendlyURL = PortalUtil.getLocalizedFriendlyURL((HttpServletRequest)request, (Layout)layout, (Locale)locale, (Locale)locale);
        SessionMessages.add((HttpServletRequest)request, (String)"alternativeLayoutFriendlyURL", (Object)alternativeLayoutFriendlyURL);
        PortalMessages.add((HttpServletRequest)request, (String)"jspPath", (Object)"/html/common/themes/layout_friendly_url_redirect.jsp");
        return locale;
    }

    protected static class Redirect {
        private final boolean _force;
        private final String _path;
        private final boolean _permanent;

        public Redirect() {
            this("/c");
        }

        public Redirect(String path) {
            this(path, false, false);
        }

        public Redirect(String path, boolean force, boolean permanent) {
            this._path = path;
            this._force = force;
            this._permanent = permanent;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Redirect)) {
                return false;
            }
            Redirect redirect = (Redirect)obj;
            return Objects.equals(this.getPath(), redirect.getPath()) && this.isForce() == redirect.isForce() && this.isPermanent() == redirect.isPermanent();
        }

        public String getPath() {
            if (Validator.isNull((String)this._path)) {
                return "/c";
            }
            return this._path;
        }

        public int hashCode() {
            int hash = HashUtil.hash((int)0, (Object)this._path);
            hash = HashUtil.hash((int)hash, (boolean)this._force);
            hash = HashUtil.hash((int)hash, (boolean)this._permanent);
            return hash;
        }

        public boolean isForce() {
            return this._force;
        }

        public boolean isPermanent() {
            return this._permanent;
        }

        public boolean isValidForward() {
            String path = this.getPath();
            if (path.charAt(0) != '/') {
                return false;
            }
            return !this.isForce();
        }
    }
}

