/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet;

import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.events.StartupAction;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.deploy.hot.HotDeployUtil;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PortletFilter;
import com.liferay.portal.kernel.model.PortletURLListener;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.patcher.PatchInconsistencyException;
import com.liferay.portal.kernel.patcher.PatcherUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutTemplateLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceActionLocalServiceUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.servlet.I18nServlet;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsResponse;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.setup.SetupWizardSampleDataUtil;
import com.liferay.portal.struts.PortletRequestProcessor;
import com.liferay.portal.struts.StrutsUtil;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.ShutdownUtil;
import com.liferay.portlet.PortletBagFactory;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletURLListenerFactory;
import com.liferay.registry.Filter;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.liferay.registry.dependency.ServiceDependencyListener;
import com.liferay.registry.dependency.ServiceDependencyManager;
import com.liferay.social.kernel.util.SocialConfigurationUtil;
import com.liferay.util.servlet.EncryptedServletRequest;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.RequestProcessor;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ModuleConfig;

public class MainServlet
extends ActionServlet {
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)ReleaseInfo.getName());
    private static final boolean _HTTP_HEADER_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase((String)PropsValues.HTTP_HEADER_VERSION_VERBOSITY, (String)"partial");
    private static final String _LIFERAY_PORTAL_REQUEST_HEADER = "Liferay-Portal";
    private static final Log _log = LogFactoryUtil.getLog(MainServlet.class);
    private static volatile InactiveRequestHandler _inactiveRequesthandler = (InactiveRequestHandler)ServiceProxyFactory.newServiceTrackedInstance(InactiveRequestHandler.class, MainServlet.class, (String)"_inactiveRequesthandler", (boolean)false);
    private ServiceRegistration<ModuleServiceLifecycle> _moduleServiceLifecycleServiceRegistration;
    private ServiceRegistration<ServletContext> _servletContextServiceRegistration;

    public void destroy() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy plugins");
        }
        this._moduleServiceLifecycleServiceRegistration.unregister();
        this._servletContextServiceRegistration.unregister();
        PortalLifecycleUtil.flushDestroys();
        List portlets = PortletLocalServiceUtil.getPortlets();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy portlets");
        }
        try {
            this.destroyPortlets(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy companies");
        }
        try {
            this.destroyCompanies();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global shutdown events");
        }
        try {
            this.processGlobalShutdownEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Destroy");
        }
        this.callParentDestroy();
    }

    public void init() throws ServletException {
        ServletContext servletContext;
        block49: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Initialize");
            }
            servletContext = this.getServletContext();
            servletContext.setAttribute(MainServlet.class.getName(), (Object)Boolean.TRUE);
            this.callParentInit();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Verify patch levels");
            }
            try {
                PatcherUtil.verifyPatchLevels();
            }
            catch (PatchInconsistencyException pie) {
                if (PropsValues.VERIFY_PATCH_LEVELS_DISABLED) break block49;
                _log.error((Object)"Stopping the server due to the inconsistent patch levels");
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"Set the property \"verify.patch.levels.disabled\" to override stopping the server due to the inconsistent patch levels", (Throwable)pie);
                }
                System.exit(0);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Verify JVM configuration");
        }
        if (_log.isWarnEnabled()) {
            String userTimeZone;
            if (!StringPool.DEFAULT_CHARSET_NAME.startsWith("UTF-")) {
                StringBundler sb = new StringBundler(4);
                sb.append("The default JVM character set \"");
                sb.append(StringPool.DEFAULT_CHARSET_NAME);
                sb.append("\" is not UTF. Please review the JVM property ");
                sb.append("\"file.encoding\".");
                _log.warn((Object)sb.toString());
            }
            if (!Objects.equals("UTC", userTimeZone = System.getProperty("user.timezone")) && !Objects.equals("GMT", userTimeZone)) {
                StringBundler sb = new StringBundler(4);
                sb.append("The default JVM time zone \"");
                sb.append(userTimeZone);
                sb.append("\" is not UTC or GMT. Please review the JVM ");
                sb.append("property \"user.timezone\".");
                _log.warn((Object)sb.toString());
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process startup events");
        }
        try {
            this.processStartupEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            System.out.println("Stopping the server due to unexpected startup errors");
            System.exit(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize server detector");
        }
        try {
            this.initServerDetector();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugin package");
        }
        PluginPackage pluginPackage = null;
        try {
            pluginPackage = this.initPluginPackage();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize portlets");
        }
        ArrayList<Portlet> portlets = new ArrayList<Portlet>();
        try {
            portlets.addAll(this.initPortlets(pluginPackage));
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            this.initLayoutTemplates(pluginPackage);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize social");
        }
        try {
            this.initSocial(pluginPackage);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize themes");
        }
        try {
            this.initThemes(pluginPackage, portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize web settings");
        }
        try {
            this.initWebSettings();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize extension environment");
        }
        try {
            this.initExt();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process global startup events");
        }
        try {
            this.processGlobalStartupEvents();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize resource actions");
        }
        try {
            this.initResourceActions(portlets);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        try {
            this.initCompanies();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (StartupHelperUtil.isDBNew() && PropsValues.SETUP_WIZARD_ADD_SAMPLE_DATA) {
            try {
                SetupWizardSampleDataUtil.addSampleData(PortalInstances.getDefaultCompanyId());
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize plugins");
        }
        try {
            this.initPlugins();
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        servletContext.setAttribute("STARTUP_FINISHED", (Object)Boolean.TRUE);
        StartupHelperUtil.setStartupFinished(true);
        this.registerPortalInitialized();
        ThreadLocalCacheManager.clearAll((Lifecycle)Lifecycle.REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        long companyId;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service request");
        }
        if (this.processShutdownRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed shutdown request");
            }
            return;
        }
        if (this.processMaintenanceRequest(request, response)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed maintenance request");
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Get company id");
        }
        if (this.processCompanyInactiveRequest(request, response, companyId = this.getCompanyId(request))) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processed company inactive request");
            }
            return;
        }
        try {
            if (this.processGroupInactiveRequest(request, response)) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Processed site inactive request");
                }
                return;
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchLayoutException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)e, (Throwable)e);
                }
            }
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set portal port");
        }
        this.setPortalInetSocketAddresses(request);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Check variables");
        }
        this.checkServletContext(request);
        this.checkPortletRequestProcessor(request);
        this.checkTilesDefinitionsFactory();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Handle non-serializable request");
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Encrypt request");
        }
        request = this.encryptRequest(request, companyId);
        long userId = this.getUserId(request);
        String remoteUser = this.getRemoteUser(request, userId);
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticate user id " + userId + " and remote user " + remoteUser));
            }
            userId = this.loginUser(request, response, companyId, userId, remoteUser);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Authenticated user id " + userId));
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Set session thread local");
        }
        PortalSessionThreadLocal.setHttpSession((HttpSession)request.getSession());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process service pre events");
        }
        if (this.processServicePre(request, response, userId)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Processing service pre events has errors");
            }
            return;
        }
        if (this.hasAbsoluteRedirect(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " has absolute redirect"));
            }
            return;
        }
        if (!this.hasThemeDisplay(request)) {
            if (_log.isDebugEnabled()) {
                String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
                _log.debug((Object)("Current URL " + currentURL + " does not have a theme display"));
            }
            return;
        }
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Call parent service");
            }
            this.callParentService(request, response);
        }
        finally {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Process service post events");
            }
            this.processServicePost(request, response);
        }
    }

    protected void callParentDestroy() {
        super.destroy();
    }

    protected void callParentInit() throws ServletException {
        super.init();
    }

    protected void callParentService(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        super.service(request, response);
    }

    protected void checkPortletRequestProcessor(HttpServletRequest request) throws ServletException {
        ServletContext servletContext = this.getServletContext();
        PortletRequestProcessor portletReqProcessor = (PortletRequestProcessor)((Object)servletContext.getAttribute("PORTLET_STRUTS_PROCESSOR"));
        if (portletReqProcessor == null) {
            ModuleConfig moduleConfig = this.getModuleConfig(request);
            portletReqProcessor = PortletRequestProcessor.getInstance(this, moduleConfig);
            servletContext.setAttribute("PORTLET_STRUTS_PROCESSOR", (Object)portletReqProcessor);
        }
    }

    protected void checkServletContext(HttpServletRequest request) {
        ServletContext servletContext = this.getServletContext();
        request.setAttribute("CTX", (Object)servletContext);
    }

    protected void checkTilesDefinitionsFactory() {
        ServletContext servletContext = this.getServletContext();
        if (servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY") != null) {
            return;
        }
        servletContext.setAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY", servletContext.getAttribute("org.apache.struts.tiles.DEFINITIONS_FACTORY"));
    }

    protected void checkWebSettings(String xml) throws DocumentException {
        Document doc = UnsecureSAXReaderUtil.read((String)xml);
        Element root = doc.getRootElement();
        int timeout = PropsValues.SESSION_TIMEOUT;
        Element sessionConfig = root.element("session-config");
        if (sessionConfig != null) {
            String sessionTimeout = sessionConfig.elementText("session-timeout");
            timeout = GetterUtil.getInteger((String)sessionTimeout, (int)timeout);
        }
        PropsUtil.set("session.timeout", String.valueOf(timeout));
        PropsValues.SESSION_TIMEOUT = timeout;
        I18nServlet.setLanguageIds(root);
        I18nFilter.setLanguageIds(I18nServlet.getLanguageIds());
    }

    protected void destroyCompanies() throws Exception {
        long[] companyIds;
        for (long companyId : companyIds = PortalInstances.getCompanyIds()) {
            this.destroyCompany(companyId);
        }
    }

    protected void destroyCompany(long companyId) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Process shutdown events");
        }
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void destroyPortlets(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            PortletInstanceFactoryUtil.destroy((Portlet)portlet);
            Map portletFilters = portlet.getPortletFilters();
            for (PortletFilter portletFilter : portletFilters.values()) {
                PortletFilterFactory.destroy(portletFilter);
            }
        }
    }

    protected HttpServletRequest encryptRequest(HttpServletRequest request, long companyId) {
        boolean encryptRequest = ParamUtil.getBoolean((HttpServletRequest)request, (String)"shuo");
        if (!encryptRequest) {
            return request;
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById((long)companyId);
            request = new EncryptedServletRequest(request, company.getKeyObj());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return request;
    }

    protected long getCompanyId(HttpServletRequest request) {
        return PortalInstances.getCompanyId(request);
    }

    protected String getRemoteUser(HttpServletRequest request, long userId) {
        HttpSession session;
        String jRemoteUser;
        String remoteUser = request.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)(session = request.getSession()).getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        return remoteUser;
    }

    protected synchronized RequestProcessor getRequestProcessor(ModuleConfig moduleConfig) throws ServletException {
        String key;
        ServletContext servletContext = this.getServletContext();
        RequestProcessor requestProcessor = (RequestProcessor)servletContext.getAttribute(key = "org.apache.struts.action.REQUEST_PROCESSOR" + moduleConfig.getPrefix());
        if (requestProcessor == null) {
            ControllerConfig controllerConfig = moduleConfig.getControllerConfig();
            try {
                requestProcessor = (RequestProcessor)InstanceFactory.newInstance((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)controllerConfig.getProcessorClass());
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            requestProcessor.init((ActionServlet)this, moduleConfig);
            servletContext.setAttribute(key, (Object)requestProcessor);
        }
        return requestProcessor;
    }

    protected long getUserId(HttpServletRequest request) {
        return PortalUtil.getUserId((HttpServletRequest)request);
    }

    protected boolean hasAbsoluteRedirect(HttpServletRequest request) {
        return request.getAttribute(AbsoluteRedirectsResponse.class.getName()) != null;
    }

    protected boolean hasThemeDisplay(HttpServletRequest request) {
        return request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCompanies() throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Initialize companies");
        }
        ServletContext servletContext = this.getServletContext();
        try {
            String[] webIds;
            for (String webId : webIds = PortalInstances.getWebIds()) {
                PortalInstances.initCompany(servletContext, webId);
            }
        }
        finally {
            CompanyThreadLocal.setCompanyId((Long)PortalInstances.getDefaultCompanyId());
        }
    }

    protected void initExt() throws Exception {
        ServletContext servletContext = this.getServletContext();
        ExtRegistry.registerPortal(servletContext);
    }

    protected void initLayoutTemplates(final PluginPackage pluginPackage) {
        ServiceDependencyManager serviceDependencyManager = new ServiceDependencyManager();
        serviceDependencyManager.addServiceDependencyListener(new ServiceDependencyListener(){

            public void dependenciesFulfilled() {
                try {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)"Initialize layout templates");
                    }
                    ServletContext servletContext = MainServlet.this.getServletContext();
                    String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-layout-templates-ext.xml"))};
                    List layoutTemplates = LayoutTemplateLocalServiceUtil.init((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
                    servletContext.setAttribute("PLUGIN_LAYOUT_TEMPLATES", (Object)layoutTemplates);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                }
            }

            public void destroy() {
            }
        });
        Registry registry = RegistryUtil.getRegistry();
        Filter freeMarkerFilter = registry.getFilter("(&(language.type=ftl)(objectClass=" + TemplateManager.class.getName() + "))");
        Filter velocityFilter = registry.getFilter("(&(language.type=vm)(objectClass=" + TemplateManager.class.getName() + "))");
        serviceDependencyManager.registerDependencies(new Filter[]{freeMarkerFilter, velocityFilter});
    }

    protected PluginPackage initPluginPackage() throws Exception {
        ServletContext servletContext = this.getServletContext();
        return PluginPackageUtil.readPluginPackageServletContext(servletContext);
    }

    protected void initPlugins() throws Exception {
        HotDeployUtil.setCapturePrematureEvents((boolean)false);
        PortalLifecycleUtil.flushInits();
    }

    protected void initPortletApp(Portlet portlet, ServletContext servletContext) throws PortletException {
        PortletApp portletApp = portlet.getPortletApp();
        PortletConfig portletConfig = PortletConfigFactoryUtil.create((Portlet)portlet, (ServletContext)servletContext);
        PortletContext portletContext = portletConfig.getPortletContext();
        Set portletFilters = portletApp.getPortletFilters();
        for (PortletFilter portletFilter : portletFilters) {
            PortletFilterFactory.create(portletFilter, portletContext);
        }
        Set portletURLListeners = portletApp.getPortletURLListeners();
        for (PortletURLListener portletURLListener : portletURLListeners) {
            PortletURLListenerFactory.create(portletURLListener);
        }
    }

    protected List<Portlet> initPortlets(PluginPackage pluginPackage) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[PropsValues.PORTLET_CONFIGS.length];
        for (int i = 0; i < PropsValues.PORTLET_CONFIGS.length; ++i) {
            xmls[i] = HttpUtil.URLtoString((URL)servletContext.getResource(PropsValues.PORTLET_CONFIGS[i]));
        }
        PortletLocalServiceUtil.initEAR((ServletContext)servletContext, (String[])xmls, (PluginPackage)pluginPackage);
        PortletBagFactory portletBagFactory = new PortletBagFactory();
        portletBagFactory.setClassLoader(ClassLoaderUtil.getPortalClassLoader());
        portletBagFactory.setServletContext(servletContext);
        portletBagFactory.setWARFile(false);
        List portlets = PortletLocalServiceUtil.getPortlets();
        for (int i = 0; i < portlets.size(); ++i) {
            Portlet portlet = (Portlet)portlets.get(i);
            portletBagFactory.create(portlet);
            if (i != 0) continue;
            this.initPortletApp(portlet, servletContext);
        }
        servletContext.setAttribute("PLUGIN_PORTLETS", (Object)portlets);
        return portlets;
    }

    protected void initResourceActions(List<Portlet> portlets) throws Exception {
        for (Portlet portlet : portlets) {
            List portletActions = ResourceActionsUtil.getPortletResourceActions((Portlet)portlet);
            ResourceActionLocalServiceUtil.checkResourceActions((String)portlet.getPortletId(), (List)portletActions);
            List modelNames = ResourceActionsUtil.getPortletModelResources((String)portlet.getPortletId());
            for (String modelName : modelNames) {
                List modelActions = ResourceActionsUtil.getModelResourceActions((String)modelName);
                ResourceActionLocalServiceUtil.checkResourceActions((String)modelName, (List)modelActions);
            }
        }
    }

    @Deprecated
    protected void initServerDetector() throws Exception {
    }

    protected void initSocial(PluginPackage pluginPackage) throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-social.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-social-ext.xml"))};
        SocialConfigurationUtil.read((ClassLoader)classLoader, (String[])xmls);
    }

    protected void initThemes(PluginPackage pluginPackage, List<Portlet> portlets) throws Exception {
        ServletContext servletContext = this.getServletContext();
        String[] xmls = new String[]{HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel.xml")), HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/liferay-look-and-feel-ext.xml"))};
        List themes = ThemeLocalServiceUtil.init((ServletContext)servletContext, null, (boolean)true, (String[])xmls, (PluginPackage)pluginPackage);
        servletContext.setAttribute("PLUGIN_THEMES", (Object)themes);
    }

    protected void initWebSettings() throws Exception {
        ServletContext servletContext = this.getServletContext();
        String xml = HttpUtil.URLtoString((URL)servletContext.getResource("/WEB-INF/web.xml"));
        this.checkWebSettings(xml);
    }

    protected long loginUser(HttpServletRequest request, HttpServletResponse response, long companyId, long userId, String remoteUser) throws PortalException {
        if (userId > 0L || remoteUser == null) {
            return userId;
        }
        userId = GetterUtil.getLong((String)remoteUser);
        User user = UserLocalServiceUtil.getUserById((long)userId);
        if (!user.isDefaultUser()) {
            EventsProcessorUtil.process("login.events.pre", PropsValues.LOGIN_EVENTS_PRE, request, response);
            if (PropsValues.USERS_UPDATE_LAST_LOGIN || user.getLastLoginDate() == null) {
                user = UserLocalServiceUtil.updateLastLogin((long)userId, (String)request.getRemoteAddr());
            }
        }
        if (request.getAttribute("USER") != null) {
            request.setAttribute("USER", (Object)user);
            request.setAttribute("USER_ID", (Object)userId);
        }
        HttpSession session = request.getSession();
        session.setAttribute("org.apache.struts.action.LOCALE", (Object)user.getLocale());
        session.setAttribute("USER", (Object)user);
        session.setAttribute("USER_ID", (Object)userId);
        session.removeAttribute("j_remoteuser");
        if (!user.isDefaultUser()) {
            EventsProcessorUtil.process("login.events.post", PropsValues.LOGIN_EVENTS_POST, request, response);
        }
        return userId;
    }

    protected boolean processCompanyInactiveRequest(HttpServletRequest request, HttpServletResponse response, long companyId) throws IOException {
        if (PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        _inactiveRequesthandler.processInactiveRequest(request, response, "this-instance-is-inactive-please-contact-the-administrator");
        return true;
    }

    protected void processGlobalShutdownEvents() throws Exception {
        EventsProcessorUtil.process("global.shutdown.events", PropsValues.GLOBAL_SHUTDOWN_EVENTS);
        super.destroy();
    }

    protected void processGlobalStartupEvents() throws Exception {
        EventsProcessorUtil.process("global.startup.events", PropsValues.GLOBAL_STARTUP_EVENTS);
    }

    protected boolean processGroupInactiveRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, PortalException {
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid <= 0L) {
            return false;
        }
        Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
        Group group = layout.getGroup();
        if (GroupLocalServiceUtil.isLiveGroupActive((Group)group)) {
            return false;
        }
        _inactiveRequesthandler.processInactiveRequest(request, response, "this-site-is-inactive-please-contact-the-administrator");
        return true;
    }

    @Deprecated
    protected void processInactiveRequest(HttpServletRequest request, HttpServletResponse response, String messageKey) throws IOException {
    }

    protected boolean processMaintenanceRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!MaintenanceUtil.isMaintaining()) {
            return false;
        }
        RequestDispatcher requestDispatcher = request.getRequestDispatcher("/html/portal/maintenance.jsp");
        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        return true;
    }

    protected void processServicePost(HttpServletRequest request, HttpServletResponse response) {
        try {
            EventsProcessorUtil.process("servlet.service.events.post", PropsValues.SERVLET_SERVICE_EVENTS_POST, request, response);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected boolean processServicePre(HttpServletRequest request, HttpServletResponse response, long userId) throws IOException, ServletException {
        try {
            EventsProcessorUtil.process("servlet.service.events.pre", PropsValues.SERVLET_SERVICE_EVENTS_PRE, request, response);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchLayoutException) {
                this.sendError(404, cause, request, response);
                return true;
            }
            if (cause instanceof PrincipalException) {
                this.processServicePrePrincipalException(cause, userId, request, response);
                return true;
            }
            _log.error((Object)e, (Throwable)e);
            request.setAttribute("javax.servlet.jsp.jspException", (Object)e);
            ServletContext servletContext = this.getServletContext();
            StrutsUtil.forward(PropsValues.SERVLET_SERVICE_EVENTS_PRE_ERROR_PAGE, servletContext, request, response);
            return true;
        }
        if (!_HTTP_HEADER_VERSION_VERBOSITY_DEFAULT) {
            if (_HTTP_HEADER_VERSION_VERBOSITY_PARTIAL) {
                response.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getName());
            } else {
                response.addHeader(_LIFERAY_PORTAL_REQUEST_HEADER, ReleaseInfo.getReleaseInfo());
            }
        }
        return false;
    }

    protected void processServicePrePrincipalException(Throwable t, long userId, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (userId > 0L) {
            this.sendError(401, t, request, response);
            return;
        }
        String redirect = PortalUtil.getPathMain().concat("/portal/login");
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        long plid = ParamUtil.getLong((HttpServletRequest)request, (String)"p_l_id");
        if (plid > 0L) {
            try {
                redirect = HttpUtil.addParameter((String)redirect, (String)"refererPlid", (long)plid);
                Layout layout = LayoutLocalServiceUtil.getLayout((long)plid);
                Group group = layout.getGroup();
                plid = group.getDefaultPublicPlid();
                if (plid == 0L || group.isStagingGroup()) {
                    Group guestGroup = GroupLocalServiceUtil.getGroup((long)layout.getCompanyId(), (String)"Guest");
                    plid = guestGroup.getDefaultPublicPlid();
                }
                redirect = HttpUtil.addParameter((String)redirect, (String)"p_l_id", (long)plid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        response.sendRedirect(redirect);
    }

    protected boolean processShutdownRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!ShutdownUtil.isShutdown()) {
            return false;
        }
        String messageKey = ShutdownUtil.getMessage();
        if (Validator.isNull((String)messageKey)) {
            messageKey = "the-system-is-shutdown-please-try-again-later";
        }
        _inactiveRequesthandler.processInactiveRequest(request, response, messageKey);
        return true;
    }

    protected void processStartupEvents() throws Exception {
        StartupAction startupAction = new StartupAction();
        startupAction.run(null);
    }

    protected void registerPortalInitialized() {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("module.service.lifecycle", "portal.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        this._moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, (Object)new ModuleServiceLifecycle(){}, properties);
        ServletContext servletContext = this.getServletContext();
        properties = new HashMap();
        Object serverContainer = servletContext.getAttribute("javax.websocket.server.ServerContainer");
        if (serverContainer != null) {
            properties.put("websocket.active", Boolean.TRUE);
        } else if (_log.isInfoEnabled()) {
            _log.info((Object)"A WebSocket server container is not registered");
        }
        properties.put("bean.id", ServletContext.class.getName());
        properties.put("original.bean", Boolean.TRUE);
        properties.put("service.vendor", ReleaseInfo.getVendor());
        this._servletContextServiceRegistration = registry.registerService(ServletContext.class, (Object)servletContext, properties);
    }

    protected void sendError(int status, Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DynamicServletRequest dynamicRequest = new DynamicServletRequest(request);
        dynamicRequest.setParameter("p_l_id", "");
        dynamicRequest.setParameter("groupId", "");
        dynamicRequest.setParameter("layoutId", "");
        dynamicRequest.setParameter("privateLayout", "");
        PortalUtil.sendError((int)status, (Exception)((Exception)t), (HttpServletRequest)dynamicRequest, (HttpServletResponse)response);
    }

    protected void setPortalInetSocketAddresses(HttpServletRequest request) {
        PortalUtil.setPortalInetSocketAddresses((HttpServletRequest)request);
    }
}

