/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.ToolsUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;

public class InstanceWrapperBuilder {
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        new InstanceWrapperBuilder(args[0]);
    }

    public InstanceWrapperBuilder(String xml) {
        try {
            File file = new File(xml);
            Document document = UnsecureSAXReaderUtil.read((File)file);
            Element rootElement = document.getRootElement();
            List instanceWrapperElements = rootElement.elements("instance-wrapper");
            for (Element instanceWrapperElement : instanceWrapperElements) {
                String parentDir = instanceWrapperElement.attributeValue("parent-dir");
                String srcFile = instanceWrapperElement.attributeValue("src-file");
                this._createIW(parentDir, srcFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _createIW(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] javaMethods = javaClass.getMethods();
        StringBundler sb = new StringBundler();
        sb.append("package ");
        sb.append(javaClass.getPackage().getName());
        sb.append(";");
        sb.append("public class ");
        sb.append(javaClass.getName());
        sb.append("_IW {");
        sb.append("public static ");
        sb.append(javaClass.getName());
        sb.append("_IW getInstance() {return _instance;}\n");
        for (JavaMethod javaMethod : javaMethods) {
            Object[] docletTags;
            String methodName = javaMethod.getName();
            if (!javaMethod.isPublic() || !javaMethod.isStatic()) continue;
            if (methodName.equals("getInstance")) {
                methodName = "getWrappedInstance";
            }
            if (ArrayUtil.isNotEmpty((Object[])(docletTags = javaMethod.getTagsByName("deprecated")))) {
                sb.append("\t/**\n");
                sb.append("\t * @deprecated\n");
                sb.append("\t */\n");
                sb.append("\t@Deprecated\n");
            }
            sb.append("public ");
            TypeVariable[] typeParameters = javaMethod.getTypeParameters();
            if (typeParameters.length > 0) {
                sb.append(" <");
                for (int i = 0; i < typeParameters.length; ++i) {
                    TypeVariable typeParameter = typeParameters[i];
                    sb.append(typeParameter.getName());
                    sb.append(", ");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("> ");
            }
            sb.append(this._getTypeGenericsName(javaMethod.getReturnType()));
            sb.append(" ");
            sb.append(methodName);
            sb.append("(");
            JavaParameter[] javaParameters = javaMethod.getParameters();
            for (int i = 0; i < javaParameters.length; ++i) {
                JavaParameter javaParameter = javaParameters[i];
                sb.append(this._getTypeGenericsName(javaParameter.getType()));
                if (javaParameter.isVarArgs()) {
                    sb.append("...");
                }
                sb.append(" ");
                sb.append(javaParameter.getName());
                sb.append(", ");
            }
            if (javaParameters.length > 0) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(")");
            Type[] thrownExceptions = javaMethod.getExceptions();
            LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
            for (int j = 0; j < thrownExceptions.length; ++j) {
                Type thrownException = thrownExceptions[j];
                newExceptions.add(thrownException.getValue());
            }
            if (!newExceptions.isEmpty()) {
                sb.append(" throws ");
                for (String newException : newExceptions) {
                    sb.append(newException);
                    sb.append(", ");
                }
                sb.setIndex(sb.index() - 1);
            }
            sb.append("{\n");
            Type returnType = javaMethod.getReturnType();
            String returnTypeValue = returnType.getValue();
            if (!returnTypeValue.equals("void")) {
                sb.append("return ");
            }
            sb.append(javaClass.getName());
            sb.append(".");
            sb.append(javaMethod.getName());
            sb.append("(");
            for (int j = 0; j < javaParameters.length; ++j) {
                JavaParameter javaParameter = javaParameters[j];
                sb.append(javaParameter.getName());
                sb.append(", ");
            }
            if (javaParameters.length > 0) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(");}\n");
        }
        sb.append("private ");
        sb.append(javaClass.getName());
        sb.append("_IW() {}");
        sb.append("private static ");
        sb.append(javaClass.getName());
        sb.append("_IW _instance = new ");
        sb.append(javaClass.getName());
        sb.append("_IW();");
        sb.append("}");
        File file = new File(parentDir + "/" + StringUtil.replace((String)javaClass.getPackage().getName(), (char)'.', (char)'/') + "/" + javaClass.getName() + "_IW.java");
        ToolsUtil.writeFile(file, sb.toString(), null);
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        for (int i = 0; i < type.getDimensions(); ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace((String)srcFile.substring(0, srcFile.length() - 5), (char)'/', (char)'.');
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(parentDir + "/" + srcFile));
        return builder.getClassByName(className);
    }

    private String _getTypeGenericsName(Type type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments == null) {
            String value = type.getValue();
            return value.concat(this._getDimensions(type));
        }
        StringBundler sb = new StringBundler(actualTypeArguments.length * 2 + 3);
        sb.append(type.getValue());
        sb.append("<");
        for (int i = 0; i < actualTypeArguments.length; ++i) {
            sb.append(this._getTypeGenericsName(actualTypeArguments[i]));
            sb.append(", ");
        }
        if (actualTypeArguments.length > 0) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(">");
        sb.append(this._getDimensions(type));
        return sb.toString();
    }
}

