/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletApp;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portlet.EventImpl;
import com.liferay.portlet.PortletRequestImpl;
import com.liferay.portlet.PortletResponseImpl;
import com.liferay.portlet.PublicRenderParametersPool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.Event;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;

public abstract class StateAwareResponseImpl
extends PortletResponseImpl
implements StateAwareResponse {
    private static final Log _log = LogFactoryUtil.getLog(StateAwareResponseImpl.class);
    private boolean _calledSetRenderParameter;
    private final List<Event> _events = new ArrayList<Event>();
    private Layout _layout;
    private Map<String, String[]> _params = new LinkedHashMap<String, String[]>();
    private PortletMode _portletMode;
    private Map<String, String[]> _publicRenderParameters;
    private String _redirectLocation;
    private User _user;
    private WindowState _windowState;

    public String getDefaultNamespace() {
        Portlet portlet = this.getPortlet();
        if (portlet != null) {
            return portlet.getPortletApp().getDefaultNamespace();
        }
        return "";
    }

    public List<Event> getEvents() {
        return this._events;
    }

    public Layout getLayout() {
        return this._layout;
    }

    public PortletMode getPortletMode() {
        return this._portletMode;
    }

    public String getRedirectLocation() {
        return this._redirectLocation;
    }

    public Map<String, String[]> getRenderParameterMap() {
        return this._params;
    }

    public User getUser() {
        return this._user;
    }

    public WindowState getWindowState() {
        return this._windowState;
    }

    public boolean isCalledSetRenderParameter() {
        return this._calledSetRenderParameter;
    }

    public void removePublicRenderParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        PublicRenderParameter publicRenderParameter = this.getPortlet().getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Public parameter " + name + "does not exist"));
            }
            return;
        }
        com.liferay.portal.kernel.xml.QName qName = publicRenderParameter.getQName();
        String key = PortletQNameUtil.getPublicRenderParameterName((com.liferay.portal.kernel.xml.QName)qName);
        this._publicRenderParameters.remove(key);
    }

    public void setEvent(QName name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this._events.add(new EventImpl(name.getLocalPart(), name, value));
    }

    public void setEvent(String name, Serializable value) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.setEvent(new QName(this.getDefaultNamespace(), name), value);
    }

    public void setPortletMode(PortletMode portletMode) throws PortletModeException {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (!this.portletRequestImpl.isPortletModeAllowed(portletMode)) {
            throw new PortletModeException(portletMode.toString(), portletMode);
        }
        try {
            this._portletMode = PortalUtil.updatePortletMode((String)this.portletName, (User)this._user, (Layout)this._layout, (PortletMode)portletMode, (HttpServletRequest)this.portletRequestImpl.getHttpServletRequest());
            this.portletRequestImpl.setPortletMode(this._portletMode);
        }
        catch (Exception e) {
            throw new PortletModeException((Throwable)e, portletMode);
        }
        this._calledSetRenderParameter = true;
    }

    public void setRedirectLocation(String redirectLocation) {
        this._redirectLocation = redirectLocation;
    }

    public void setRenderParameter(String name, String value) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (name == null || value == null) {
            throw new IllegalArgumentException();
        }
        this.setRenderParameter(name, new String[]{value});
    }

    public void setRenderParameter(String name, String[] values) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (name == null || values == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new IllegalArgumentException();
        }
        if (!this.setPublicRenderParameter(name, values)) {
            this._params.put(name, values);
        }
        this._calledSetRenderParameter = true;
    }

    public void setRenderParameters(Map<String, String[]> params) {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (params == null) {
            throw new IllegalArgumentException();
        }
        LinkedHashMap<String, String[]> newParams = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (value == null) {
                throw new IllegalArgumentException();
            }
            if (this.setPublicRenderParameter(key, value)) continue;
            newParams.put(key, value);
        }
        this._params = newParams;
        this._calledSetRenderParameter = true;
    }

    public void setWindowState(WindowState windowState) throws WindowStateException {
        if (this._redirectLocation != null) {
            throw new IllegalStateException();
        }
        if (!this.portletRequestImpl.isWindowStateAllowed(windowState)) {
            throw new WindowStateException(windowState.toString(), windowState);
        }
        try {
            this._windowState = PortalUtil.updateWindowState((String)this.portletName, (User)this._user, (Layout)this._layout, (WindowState)windowState, (HttpServletRequest)this.portletRequestImpl.getHttpServletRequest());
            this.portletRequestImpl.setWindowState(this._windowState);
        }
        catch (Exception e) {
            throw new WindowStateException((Throwable)e, windowState);
        }
        this._calledSetRenderParameter = true;
    }

    @Deprecated
    protected void init(PortletRequestImpl portletRequestImpl, HttpServletResponse response, String portletName, User user, Layout layout, WindowState windowState, PortletMode portletMode) throws PortletModeException, WindowStateException {
        this.init(portletRequestImpl, response, user, layout, true);
    }

    protected void init(PortletRequestImpl portletRequestImpl, HttpServletResponse response, User user, Layout layout, boolean setWindowStateAndPortletMode) throws PortletModeException, WindowStateException {
        super.init(portletRequestImpl, response);
        this._user = user;
        this._layout = layout;
        Portlet portlet = portletRequestImpl.getPortlet();
        PortletApp portletApp = portlet.getPortletApp();
        this._publicRenderParameters = PublicRenderParametersPool.get(this.getHttpServletRequest(), layout.getPlid(), portletApp.isWARFile());
        if (setWindowStateAndPortletMode) {
            this.setWindowState(portletRequestImpl.getWindowState());
            this.setPortletMode(portletRequestImpl.getPortletMode());
        }
        this._calledSetRenderParameter = false;
    }

    protected void reset() {
        this._calledSetRenderParameter = false;
        this._events.clear();
        this._params.clear();
        this._portletMode = null;
        this._redirectLocation = null;
        this._windowState = null;
    }

    protected boolean setPublicRenderParameter(String name, String[] values) {
        Portlet portlet = this.getPortlet();
        PublicRenderParameter publicRenderParameter = portlet.getPublicRenderParameter(name);
        if (publicRenderParameter == null) {
            return false;
        }
        com.liferay.portal.kernel.xml.QName qName = publicRenderParameter.getQName();
        Object[] oldValues = this._publicRenderParameters.get(name);
        if (oldValues != null) {
            values = (String[])ArrayUtil.append((Object[])oldValues, (Object[])values);
        }
        this._publicRenderParameters.put(PortletQNameUtil.getPublicRenderParameterName((com.liferay.portal.kernel.xml.QName)qName), values);
        return true;
    }
}

